/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.node.info.NodeInfo;
import org.opensearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.opensearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.action.ActionListener;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.ClusterAdminClient;

public class NodesInfo {
    private static final Logger LOGGER = Loggers.getLogger(NodesInfo.class, (String[])new String[]{"os-bpc-plugin"});
    private final Client client;
    private final ClusterService clusterService;
    private String _thisNodeName;

    public NodesInfo(Client client, ClusterService clusterService) {
        LOGGER.debug("NodesInfo client={}, clusterService={}", (Object)client, (Object)clusterService);
        this.client = client;
        this.clusterService = clusterService;
        this._thisNodeName = null;
    }

    public String getLocalNodeName() throws NullPointerException {
        if (this._thisNodeName == null) {
            try {
                this._thisNodeName = this.clusterService.localNode().getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this._thisNodeName == null) {
            throw new NullPointerException("Failed to get the name of the local node.");
        }
        return this._thisNodeName;
    }

    public boolean isLocalNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return false;
        }
        return nodeInfo.getNode().getName().equals(this.getLocalNodeName());
    }

    public List<DiscoveryNode> getAllOtherNodes() {
        ArrayList<DiscoveryNode> result = new ArrayList<DiscoveryNode>();
        DiscoveryNode localNode = this.clusterService.localNode();
        DiscoveryNodes discoveryNodes = this.clusterService.state().nodes();
        for (DiscoveryNode discoveryNode : discoveryNodes) {
            if (discoveryNode.getId().equals(localNode.getId())) continue;
            result.add(discoveryNode);
        }
        return result;
    }

    public void ifThisNodeIsTheMasterNode(NodeRunnable ifExistRunnable) {
        this.ifNodeIsTheMasterNodeOrElse(this.getLocalNodeName(), ifExistRunnable, null);
    }

    public void ifThisNodeIsTheMasterNodeOrElse(NodeRunnable ifExistRunnable, NodeRunnable orElseRunnable) {
        this.ifNodeIsTheMasterNodeOrElse(this.getLocalNodeName(), ifExistRunnable, orElseRunnable);
    }

    public void ifNodeIsTheMasterNode(String nodeName, NodeRunnable ifExistsRunnable) {
        this.ifNodeIsTheMasterNodeOrElse(nodeName, ifExistsRunnable, null);
    }

    public void ifNodeIsTheMasterNodeOrElse(final String nodeName, final NodeRunnable ifExistsRunnable, final NodeRunnable orElseRunnable) {
        ClusterAdminClient clusterAdminClient = this.client.admin().cluster();
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[]{"_master"}).clear();
        clusterAdminClient.nodesInfo(nodesInfoRequest, (ActionListener)new ActionListener<NodesInfoResponse>(){

            public void onResponse(NodesInfoResponse nodeInfos) {
                if (NodesInfo.this.isThisNodeTheMasterNode(nodeName, nodeInfos)) {
                    ifExistsRunnable.run();
                } else if (orElseRunnable != null) {
                    orElseRunnable.run();
                }
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Failed to check if the current node is the master node.", (Throwable)ex);
            }
        });
    }

    private boolean isThisNodeTheMasterNode(String nodeName, NodesInfoResponse nodeInfos) {
        for (NodeInfo node : nodeInfos.getNodes()) {
            String masterNodeName = node.getNode().getName();
            if (!nodeName.equals(masterNodeName)) continue;
            LOGGER.debug("isThisNodeTheMasterNode nodeName={} : YES", (Object)nodeName);
            return true;
        }
        LOGGER.debug("isThisNodeTheMasterNode nodeName={} : NO", (Object)nodeName);
        return false;
    }

    @FunctionalInterface
    public static interface NodeRunnable {
        public void run();
    }
}

