/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ReplicationJob;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopAction;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopActions;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobsComputator;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobsPerServerDistributor;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;

public class ReplicationJobsOrchestrator {
    private static final Logger LOGGER = Loggers.getLogger(ReplicationJobsOrchestrator.class, (String[])new String[]{"os-bpc-plugin"});
    private final ReplicationJobs currentReplicationJobs;
    private final String transactionId;

    public ReplicationJobsOrchestrator(ReplicationJobs currentReplicationJobs) {
        this.currentReplicationJobs = currentReplicationJobs;
        this.transactionId = StringUtil.randomUUID();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void updateStateOfReplicationJobsOfNoLongerConnectedServers(Set<String> connectedServerUUIDs) {
        LOGGER.debug("updateStateOfReplicationJobsOfNoLongerConnectedServers connectedServerUUIDs={}", connectedServerUUIDs);
        Set<String> removedServerUUIDs = this.currentReplicationJobs.evaluateRemovedServerUUIDs(connectedServerUUIDs);
        this.currentReplicationJobs.setThoseAsStoppedUsingServerUUIDs(removedServerUUIDs);
    }

    public boolean areJobsEquallyDistributed(Set<String> serverUUIDs) {
        LOGGER.debug("areJobsEquallyDistributed serverUUIDs={}", serverUUIDs);
        List<ReplicationJob> stoppedReplicationJobs = this.currentReplicationJobs.getReplicationJobsByState(ReplicationJob.State.STOPPED);
        for (ReplicationJob stoppedReplicationJob : stoppedReplicationJobs) {
            if (!stoppedReplicationJob.isEnabled()) continue;
            return false;
        }
        if (!serverUUIDs.containsAll(this.currentReplicationJobs.getUsedServerUUIDs())) {
            return false;
        }
        ReplicationJobsComputator jobsComputator = new ReplicationJobsComputator(this.currentReplicationJobs, serverUUIDs);
        ReplicationJobsPerServerDistributor jobsDistributor = new ReplicationJobsPerServerDistributor(serverUUIDs, this.currentReplicationJobs);
        int lowestNumberOfJobsOnServer = -1;
        int highestNumberOfJobsOnServer = -1;
        int processedServersWithMaxJobs = 0;
        for (String serverUUID : serverUUIDs) {
            int numberOfJobsOnServer = jobsDistributor.getNumberOfJobsOnServer(serverUUID);
            if (lowestNumberOfJobsOnServer == -1 || numberOfJobsOnServer < lowestNumberOfJobsOnServer) {
                lowestNumberOfJobsOnServer = numberOfJobsOnServer;
            }
            if (highestNumberOfJobsOnServer == -1 || numberOfJobsOnServer > highestNumberOfJobsOnServer) {
                highestNumberOfJobsOnServer = numberOfJobsOnServer;
            }
            if (numberOfJobsOnServer > jobsComputator.getMaxJobsPerServer()) {
                return false;
            }
            if (numberOfJobsOnServer == jobsComputator.getMaxJobsPerServer()) {
                ++processedServersWithMaxJobs;
            }
            if (processedServersWithMaxJobs <= jobsComputator.getNumberOfServersWhichMustHaveMaxJobs()) continue;
            return false;
        }
        return highestNumberOfJobsOnServer - lowestNumberOfJobsOnServer <= 1;
    }

    public ReplicationJobStopActions getReplicationJobStopActions(Set<String> serverUUIDs) {
        LOGGER.debug("getReplicationJobStopActions serverUUIDs={}", serverUUIDs);
        Set<String> currentlyUsedServerUUIDs = this.currentReplicationJobs.getUsedServerUUIDs();
        ReplicationJobStopActions stopActions = new ReplicationJobStopActions(this.transactionId);
        if (serverUUIDs != null && !serverUUIDs.isEmpty()) {
            stopActions.addAll(this.createReplicationJobStopActionsForStoppedServers(serverUUIDs));
            stopActions.addAll(this.createReplicationStopActionsForMaxedOutServers(serverUUIDs));
        } else {
            stopActions.addAll(this.createReplicationJobStopActionsForNoLongerExistingServers(currentlyUsedServerUUIDs));
        }
        return stopActions;
    }

    private List<ReplicationJobStopAction> createReplicationJobStopActionsForStoppedServers(Set<String> serverUUIDs) {
        LOGGER.debug("createReplicationJobStopActionsForStoppedServers serverUUIDs={}", serverUUIDs);
        ArrayList<ReplicationJobStopAction> stopActions = new ArrayList<ReplicationJobStopAction>();
        Set<String> removedServerUUIDs = this.currentReplicationJobs.evaluateRemovedServerUUIDs(serverUUIDs);
        if (!removedServerUUIDs.isEmpty()) {
            for (String removedServerUUID : removedServerUUIDs) {
                Set<ReplicationJob> replicationJobs = this.currentReplicationJobs.getReplicationJobsByServerUUID(removedServerUUID);
                for (ReplicationJob replicationJobToStop : replicationJobs) {
                    ReplicationJobStopAction stopAction = new ReplicationJobStopAction(replicationJobToStop.getId(), removedServerUUID);
                    LOGGER.info("{}: The replication job with the ID '{}' belongs to a stopped server '{}' and must be stopped.", (Object)this.transactionId, (Object)stopAction.getReplicationJobId(), (Object)stopAction.getServerUUID());
                    stopActions.add(stopAction);
                }
            }
        }
        return stopActions;
    }

    private List<ReplicationJobStopAction> createReplicationStopActionsForMaxedOutServers(Set<String> serverUUIDs) {
        LOGGER.debug("createReplicationStopActionsForMaxedOutServers serverUUIDs={}", serverUUIDs);
        ArrayList<ReplicationJobStopAction> stopActions = new ArrayList<ReplicationJobStopAction>();
        ReplicationJobsComputator jobsComputator = new ReplicationJobsComputator(this.currentReplicationJobs, serverUUIDs);
        int processedServersWithMaxJobs = 0;
        for (String serverUUID : serverUUIDs) {
            Set<ReplicationJob> replicationJobs = this.currentReplicationJobs.getReplicationJobsByServerUUID(serverUUID);
            int currentNumberOfJobsOnServer = replicationJobs.size();
            int maxAllowedJobsOnServer = jobsComputator.getMaxJobsPerServer();
            if (processedServersWithMaxJobs >= jobsComputator.getNumberOfServersWhichMustHaveMaxJobs()) {
                maxAllowedJobsOnServer = jobsComputator.getMaxJobsPerServer() - 1;
            }
            if (currentNumberOfJobsOnServer > maxAllowedJobsOnServer) {
                int numberOfJobsToStop = currentNumberOfJobsOnServer - maxAllowedJobsOnServer;
                ArrayList<ReplicationJob> jobs = new ArrayList<ReplicationJob>(replicationJobs);
                for (int i = 0; i < numberOfJobsToStop; ++i) {
                    ReplicationJob replicationJobToStop = (ReplicationJob)jobs.get(i);
                    ReplicationJobStopAction stopAction = new ReplicationJobStopAction(replicationJobToStop.getId(), serverUUID);
                    LOGGER.info("{}: The replication job with the ID '{}' belongs to a maxed-out server '{}' and must be stopped.", (Object)this.transactionId, (Object)stopAction.getReplicationJobId(), (Object)stopAction.getServerUUID());
                    stopActions.add(stopAction);
                }
            }
            if (currentNumberOfJobsOnServer < maxAllowedJobsOnServer) continue;
            ++processedServersWithMaxJobs;
        }
        return stopActions;
    }

    private List<ReplicationJobStopAction> createReplicationJobStopActionsForNoLongerExistingServers(Set<String> currentlyUsedServerUUIDs) {
        LOGGER.debug("createReplicationJobStopActionsForNoLongerExistingServers currentlyUsedServerUUIDs={}", currentlyUsedServerUUIDs);
        ArrayList<ReplicationJobStopAction> stopActions = new ArrayList<ReplicationJobStopAction>();
        for (String usedServerUUID : currentlyUsedServerUUIDs) {
            Set<ReplicationJob> replicationJobs = this.currentReplicationJobs.getReplicationJobsByServerUUID(usedServerUUID);
            for (ReplicationJob replicationJobToStop : replicationJobs) {
                ReplicationJobStopAction stopAction = new ReplicationJobStopAction(replicationJobToStop.getId(), usedServerUUID);
                LOGGER.info(this.transactionId + ": The replication job with the ID '" + stopAction.getReplicationJobId() + "' belongs to a no longer existing server '" + stopAction.getServerUUID() + "' and must be stopped.");
                stopActions.add(stopAction);
            }
        }
        return stopActions;
    }

    public ReplicationJobStartActions getReplicationJobStartActions(Set<String> serverUUIDs) {
        LOGGER.debug("getReplicationJobStartActions serverUUIDs={}", serverUUIDs);
        ReplicationJobStartActions actions = new ReplicationJobStartActions(this.transactionId);
        if (serverUUIDs != null && !serverUUIDs.isEmpty()) {
            ArrayList<ReplicationJob> replicationJobsToStart = new ArrayList<ReplicationJob>();
            List<ReplicationJob> stoppedReplicationJobs = this.currentReplicationJobs.getReplicationJobsByStates(List.of(ReplicationJob.State.STOPPING, ReplicationJob.State.STOPPED));
            for (ReplicationJob stoppedReplicationJob : stoppedReplicationJobs) {
                if (!stoppedReplicationJob.isEnabled()) continue;
                replicationJobsToStart.add(stoppedReplicationJob);
            }
            if (!replicationJobsToStart.isEmpty()) {
                ReplicationJobsPerServerDistributor jobsPerServerDistributor = new ReplicationJobsPerServerDistributor(serverUUIDs, this.currentReplicationJobs);
                for (ReplicationJob replicationJobToStart : replicationJobsToStart) {
                    String serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                    ReplicationJobStartAction startAction = new ReplicationJobStartAction(replicationJobToStart.getId(), serverUuidWithFewestNumberOfJobs);
                    LOGGER.info("{}: The replication job with the ID '{}' gets started on server '{}'.", (Object)this.transactionId, (Object)startAction.getReplicationJobId(), (Object)startAction.getServerUUID());
                    actions.add(startAction);
                }
            }
        }
        return actions;
    }

    public ReplicationJobStopActions getReplicationJobStopActions(ReplicationJobs latestReplicationJobs, Set<String> serverUUIDs) {
        ReplicationJobStopAction stopAction;
        ReplicationJob latestReplicationJob;
        ReplicationJob currentReplicationJob;
        LOGGER.debug("getReplicationJobStopActions latestReplicationJobs={}, serverUUIDs={}", (Object)latestReplicationJobs, serverUUIDs);
        ReplicationJobStopActions stopActions = new ReplicationJobStopActions(this.transactionId);
        Set<String> currentJobIDs = this.currentReplicationJobs.getReplicationJobIDs();
        Set<String> latestJobIDs = latestReplicationJobs.getReplicationJobIDs();
        HashSet<String> removedJobIDs = new HashSet<String>(currentJobIDs);
        removedJobIDs.removeAll(latestJobIDs);
        for (String string : removedJobIDs) {
            ReplicationJob removedReplicationJob;
            if (stopActions.existsForReplicationJobId(string) || (removedReplicationJob = this.currentReplicationJobs.getById(string)) == null || !removedReplicationJob.isRunningOnSomeServer()) continue;
            ReplicationJobStopAction stopAction2 = new ReplicationJobStopAction(removedReplicationJob.getId(), removedReplicationJob.getServerUUID());
            LOGGER.info("{}: The replication job with the ID '{}' does no longer exist and must be stopped on server '{}'.", (Object)this.transactionId, (Object)stopAction2.getReplicationJobId(), (Object)stopAction2.getServerUUID());
            stopActions.add(stopAction2);
        }
        for (String string : latestJobIDs) {
            if (stopActions.existsForReplicationJobId(string)) continue;
            currentReplicationJob = this.currentReplicationJobs.getById(string);
            latestReplicationJob = latestReplicationJobs.getById(string);
            if (currentReplicationJob == null || latestReplicationJob == null || !currentReplicationJob.isEnabled() || latestReplicationJob.isEnabled() || !currentReplicationJob.isRunningOnSomeServer()) continue;
            stopAction = new ReplicationJobStopAction(currentReplicationJob.getId(), currentReplicationJob.getServerUUID());
            LOGGER.info("{}: The replication job with the ID '{}' is now disabled and must be stopped on server '{}'.", (Object)this.transactionId, (Object)stopAction.getReplicationJobId(), (Object)stopAction.getServerUUID());
            stopActions.add(stopAction);
        }
        for (String string : latestJobIDs) {
            if (stopActions.existsForReplicationJobId(string)) continue;
            currentReplicationJob = this.currentReplicationJobs.getById(string);
            latestReplicationJob = latestReplicationJobs.getById(string);
            if (currentReplicationJob == null || latestReplicationJob == null || currentReplicationJob.getSettingsHash() == latestReplicationJob.getSettingsHash() || !currentReplicationJob.isRunningOnSomeServer()) continue;
            stopAction = new ReplicationJobStopAction(currentReplicationJob.getId(), currentReplicationJob.getServerUUID());
            LOGGER.info("{}: The replication job with the ID '{}' has been updated and must be stopped on server '{}'.", (Object)this.transactionId, (Object)stopAction.getReplicationJobId(), (Object)stopAction.getServerUUID());
            stopActions.add(stopAction);
        }
        if (!stopActions.isEmpty()) {
            ReplicationJobs tmpReplicationJobs = new ReplicationJobs();
            for (ReplicationJob job : this.currentReplicationJobs) {
                tmpReplicationJobs.add(new ReplicationJob(job));
            }
            tmpReplicationJobs.updateWithStopActions(stopActions);
            tmpReplicationJobs.updateWithLatestJobs(latestReplicationJobs);
            ReplicationJobsComputator replicationJobsComputator = new ReplicationJobsComputator(tmpReplicationJobs, serverUUIDs);
            int processedServersWithMaxJobs = 0;
            for (String serverUUID : serverUUIDs) {
                Set<ReplicationJob> replicationJobsByServerUUID = tmpReplicationJobs.getReplicationJobsByServerUUID(serverUUID);
                int maxJobsOnServer = replicationJobsComputator.getMaxJobsPerServer();
                if (processedServersWithMaxJobs >= replicationJobsComputator.getNumberOfServersWhichMustHaveMaxJobs()) {
                    maxJobsOnServer = replicationJobsComputator.getMaxJobsPerServer() - 1;
                }
                if (replicationJobsByServerUUID.size() > maxJobsOnServer) {
                    ++processedServersWithMaxJobs;
                    int numberOfJobsToStop = replicationJobsByServerUUID.size() - maxJobsOnServer;
                    ArrayList<ReplicationJob> jobs = new ArrayList<ReplicationJob>(replicationJobsByServerUUID);
                    for (int i = 0; i < numberOfJobsToStop; ++i) {
                        ReplicationJob replicationJobToStop = (ReplicationJob)jobs.get(i);
                        ReplicationJobStopAction stopAction3 = new ReplicationJobStopAction(replicationJobToStop.getId(), serverUUID);
                        LOGGER.info("{}: The replication job with the ID '{}' runs on a maxed-out server '{}' and must be stopped.", (Object)this.transactionId, (Object)stopAction3.getReplicationJobId(), (Object)stopAction3.getServerUUID());
                        stopActions.add(stopAction3);
                    }
                    continue;
                }
                if (replicationJobsByServerUUID.size() != maxJobsOnServer) continue;
                ++processedServersWithMaxJobs;
            }
        }
        return stopActions;
    }

    public ReplicationJobStartActions getReplicationJobStartActions(ReplicationJobs latestReplicationJobs, Set<String> serverUUIDs) {
        LOGGER.debug("getReplicationJobStartActions latestReplicationJobs={}, serverUUIDs={}", (Object)latestReplicationJobs, serverUUIDs);
        ReplicationJobStartActions actions = new ReplicationJobStartActions(this.transactionId);
        if (serverUUIDs != null && !serverUUIDs.isEmpty()) {
            ReplicationJob replicationJob;
            ReplicationJobStartAction startAction;
            String serverUuidWithFewestNumberOfJobs;
            ReplicationJob latestReplicationJob;
            ReplicationJob currentReplicationJob;
            Set<String> currentJobIDs = this.currentReplicationJobs.getReplicationJobIDs();
            Set<String> latestJobIDs = latestReplicationJobs.getReplicationJobIDs();
            ReplicationJobsPerServerDistributor jobsPerServerDistributor = new ReplicationJobsPerServerDistributor(serverUUIDs, this.currentReplicationJobs);
            for (String jobID : latestJobIDs) {
                currentReplicationJob = this.currentReplicationJobs.getById(jobID);
                latestReplicationJob = latestReplicationJobs.getById(jobID);
                if (currentReplicationJob == null || latestReplicationJob == null || currentReplicationJob.isEnabled() || !latestReplicationJob.isEnabled()) continue;
                serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                startAction = new ReplicationJobStartAction(jobID, serverUuidWithFewestNumberOfJobs);
                LOGGER.info("{}: The replication job with the ID '{}' is now enabled and must be started on server '{}'.", (Object)this.transactionId, (Object)startAction.getReplicationJobId(), (Object)startAction.getServerUUID());
                actions.add(startAction);
            }
            for (String jobID : latestJobIDs) {
                currentReplicationJob = this.currentReplicationJobs.getById(jobID);
                latestReplicationJob = latestReplicationJobs.getById(jobID);
                if (currentReplicationJob == null || latestReplicationJob == null || currentReplicationJob.getSettingsHash() == latestReplicationJob.getSettingsHash()) continue;
                serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                startAction = new ReplicationJobStartAction(jobID, serverUuidWithFewestNumberOfJobs);
                LOGGER.info("{}: The replication job with the ID '{}' has been updated and must be started on server '{}'.", (Object)this.transactionId, (Object)startAction.getReplicationJobId(), (Object)startAction.getServerUUID());
                actions.add(startAction);
            }
            HashSet<String> newJobIDs = new HashSet<String>(latestJobIDs);
            newJobIDs.removeAll(currentJobIDs);
            for (String jobID : newJobIDs) {
                replicationJob = latestReplicationJobs.getById(jobID);
                if (!replicationJob.isEnabled()) continue;
                serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                startAction = new ReplicationJobStartAction(jobID, serverUuidWithFewestNumberOfJobs);
                LOGGER.info("{}: The replication job with the ID '{}' is new (+ enabled) and must be started on server '{}'.", (Object)this.transactionId, (Object)startAction.getReplicationJobId(), (Object)startAction.getServerUUID());
                actions.add(startAction);
            }
            for (String jobID : currentJobIDs) {
                replicationJob = this.currentReplicationJobs.getById(jobID);
                if (replicationJob.isEnabled()) {
                    if (replicationJob.isInState(List.of(ReplicationJob.State.STOPPING, ReplicationJob.State.STOPPED))) {
                        serverUuidWithFewestNumberOfJobs = jobsPerServerDistributor.getNextServerUuidWithFewestNumberOfJobs();
                        startAction = new ReplicationJobStartAction(jobID, serverUuidWithFewestNumberOfJobs);
                        LOGGER.info("{}: The replication job with the ID '{}' is stopped (+ enabled) and must be started on server '{}'.", (Object)this.transactionId, (Object)startAction.getReplicationJobId(), (Object)startAction.getServerUUID());
                        actions.add(startAction);
                        continue;
                    }
                    LOGGER.info("{}: The replication job with the ID '{}' is enabled and already running on server '{}'.", (Object)this.transactionId, (Object)replicationJob.getId(), (Object)replicationJob.getServerUUID());
                    continue;
                }
                LOGGER.info("{}: The replication job with the ID '{}' is disabled and must not be started on any server.", (Object)this.transactionId, (Object)replicationJob.getId());
            }
        }
        return actions;
    }
}

