/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.parser.split;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.decanter.api.parser.Parser;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.karaf.decanter.parser.split", immediate=true, property={"parserId=split"})
public class SplitParser
implements Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplitParser.class);
    private String separator;
    private String keys = null;
    private Boolean useDefaultKey;

    @Activate
    public void activate(ComponentContext componentContext) {
        this.activate(componentContext.getProperties());
    }

    public void activate(Dictionary<String, Object> config) {
        this.separator = config.get("separator") != null ? (String)config.get("separator") : ",";
        this.keys = config.get("keys") != null ? (String)config.get("keys") : null;
        this.useDefaultKey = config.get("useDefaultKey") != null ? Boolean.parseBoolean((String)config.get("useDefaultKey")) : false;
    }

    public Map<String, Object> parse(String key, String line) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isByPassed = false;
        if (line != null) {
            int i;
            String[] keysArray;
            String[] valuesArray = line.split(this.separator);
            if (this.keys != null) {
                keysArray = this.keys.split(",");
                if (keysArray.length != valuesArray.length) {
                    if (this.useDefaultKey.booleanValue()) {
                        LOGGER.warn("keys count and values count don't match, using default key ID");
                        keysArray = new String[valuesArray.length];
                        for (i = 0; i < valuesArray.length; ++i) {
                            keysArray[i] = "key-" + i;
                        }
                    } else {
                        LOGGER.warn("keys count and values count don't match, bypassing default key ID");
                        isByPassed = true;
                    }
                }
            } else {
                keysArray = new String[valuesArray.length];
                for (i = 0; i < valuesArray.length; ++i) {
                    keysArray[i] = "key-" + i;
                }
            }
            if (!isByPassed) {
                for (i = 0; i < valuesArray.length; ++i) {
                    try {
                        map.put(keysArray[i], Integer.parseInt(valuesArray[i]));
                        continue;
                    }
                    catch (Exception exception) {
                        try {
                            map.put(keysArray[i], Long.parseLong(valuesArray[i]));
                            continue;
                        }
                        catch (Exception exception2) {
                            map.put(keysArray[i], valuesArray[i]);
                        }
                    }
                }
            }
        }
        return map;
    }
}

