/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.analysis.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.service.HttpProxyService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.module.analysis.AnalysisModule;
import de.virtimo.bpc.module.analysis.datasource.DataSource;
import de.virtimo.bpc.module.analysis.datasource.Http;
import de.virtimo.bpc.module.analysis.datasource.Inubit;
import de.virtimo.bpc.module.analysis.datasource.Json;
import de.virtimo.bpc.module.analysis.datasource.OpenSearch;
import de.virtimo.bpc.module.analysis.dto.DataModifier;
import de.virtimo.bpc.module.analysis.exceptions.LocalHostAccessDenied;
import de.virtimo.bpc.module.analysis.modifier.EngineNotFoundException;
import de.virtimo.bpc.module.analysis.modifier.GroovyModifier;
import de.virtimo.bpc.module.analysis.modifier.JSScriptEngineFactory;
import de.virtimo.bpc.module.analysis.modifier.JavascriptModifier;
import de.virtimo.bpc.module.analysis.security.AnalysisPolicy;
import java.io.IOException;
import java.security.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="/")
public class Analysis {
    private static final Logger LOGGER = LogManager.getLogger(Analysis.class);
    private static final String MODIFIER_TYPE_JAVASCRIPT = "javascript";
    private static final String MODIFIER_TYPE_GROOVY = "groovy";
    private final BundleContext bundleContext;
    private BpcServicesTracker<HttpProxyService> httpProxyServiceTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private JSScriptEngineFactory jsScriptEngineFactory;

    public Analysis(BundleContext bundleContext) {
        LOGGER.info("AbstractCollabEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.httpProxyServiceTracker = new BpcServicesTracker(this.bundleContext, HttpProxyService.class);
        this.openSearchServiceTracker = new BpcServicesTracker(this.bundleContext, OpenSearchService.class);
        this.jsScriptEngineFactory = new JSScriptEngineFactory();
        Policy.setPolicy(new AnalysisPolicy());
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        this.jsScriptEngineFactory.destroy();
        BpcServicesTracker.stopAll((Object)this);
    }

    private Response errorResponse(Response.Status errorStatus, String errorMessage, Exception cause) {
        if (errorMessage != null && errorMessage.length() > 0) {
            LOGGER.warn(errorMessage);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", errorMessage);
            if (cause != null) {
                errorResponse.put("cause", cause.getMessage());
            }
            return Response.status((Response.Status)errorStatus).entity(errorResponse).build();
        }
        return Response.noContent().status(errorStatus).build();
    }

    private Response modifierErrorResponse(Response.Status errorStatus, String errorMessage, Exception cause, Map causedModifierConfig) {
        if (errorMessage != null && errorMessage.length() > 0) {
            LOGGER.warn(errorMessage);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", errorMessage);
            if (causedModifierConfig != null) {
                errorResponse.put("causedModifierName", causedModifierConfig.get("name"));
            }
            if (cause != null) {
                errorResponse.put("cause", cause.getMessage());
            }
            return Response.status((Response.Status)errorStatus).entity(errorResponse).build();
        }
        return Response.noContent().status(errorStatus).build();
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="data/{moduleInstanceId}/{dataSetId}")
    @BpcUserSessionRequired
    public Response getData(@PathParam(value="moduleInstanceId") String moduleInstanceId, @PathParam(value="dataSetId") String dataSetId, @Context UserSession userSession, @Context HttpHeaders httpHeaders, @Context UriInfo uriInfo) {
        try {
            ModuleInstance mi = AnalysisModule.getInstance().getModuleInstance(moduleInstanceId);
            if (mi == null || !userSession.hasUseModuleInstanceRight(mi)) {
                throw new ModuleInstanceNotFoundException("analysis", moduleInstanceId);
            }
            Map dataSetConfig = this.getDataSetConfig(moduleInstanceId, dataSetId);
            if (dataSetConfig == null) {
                return this.errorResponse(Response.Status.BAD_REQUEST, "ANALYSIS_DATA_SET_NOT_FOUND", null);
            }
            MultivaluedMap variables = uriInfo.getQueryParameters();
            variables.remove("_dc");
            if (!this.checkVarsValidity(dataSetConfig, (Map<String, List<String>>)variables)) {
                return this.errorResponse(Response.Status.BAD_REQUEST, "One or more variables are not valid", null);
            }
            String resultData = this.getData(dataSetConfig, (Map<String, List<String>>)variables, userSession, httpHeaders);
            if (resultData != null) {
                return Response.ok((Object)resultData).build();
            }
            return this.errorResponse(Response.Status.BAD_REQUEST, "ANALYSIS_DATA_SOURCE_TYPE_NOT_FOUND", null);
        }
        catch (LocalHostAccessDenied e) {
            return this.errorResponse(Response.Status.BAD_REQUEST, e.getMessage(), e);
        }
        catch (Exception e) {
            LOGGER.error("Query could not be executed.", (Throwable)e);
            return this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Query could not be executed.", e);
        }
    }

    private String getData(Map dataSetConfig, Map<String, List<String>> variables, UserSession userSession, HttpHeaders httpHeaders) throws Exception {
        DataSource dataSource = null;
        String dataSourceType = dataSetConfig.get("sourceType").toString().toLowerCase();
        if (dataSourceType.equals("opensearch")) {
            dataSource = new OpenSearch((OpenSearchService)this.openSearchServiceTracker.getService());
        } else if (dataSourceType.equals("json")) {
            dataSource = new Json();
        } else if (dataSourceType.equals("http")) {
            dataSource = new Http();
        } else if (dataSourceType.equals("inubit")) {
            dataSource = new Inubit((HttpProxyService)this.httpProxyServiceTracker.getService(), userSession, httpHeaders);
        }
        if (dataSource != null) {
            return dataSource.getData(dataSetConfig, variables);
        }
        return null;
    }

    private Map getDataSetConfig(String moduleInstanceId, String dataSetId) {
        ModuleInstance mi = AnalysisModule.getInstance().getModuleInstance(moduleInstanceId);
        List dataSetConfigs = (List)mi.getConfiguration().getSetting("dataSets_configs").getValue();
        Map dataSetConfig = dataSetConfigs.stream().filter(config -> config.get("id").equals(dataSetId)).findFirst().orElse(null);
        return dataSetConfig;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="data/{moduleInstanceId}/{dataSetId}/modify")
    @BpcUserSessionRequired
    public Response getModifiedData(@PathParam(value="moduleInstanceId") String moduleInstanceId, @PathParam(value="dataSetId") String dataSetId, @Context UserSession userSession, @Context HttpHeaders headers, @Context UriInfo uriInfo, String requestBody) throws ModuleInstanceNotFoundException, JsonProcessingException {
        ModuleInstance mi = AnalysisModule.getInstance().getModuleInstance(moduleInstanceId);
        if (mi == null || !userSession.hasUseModuleInstanceRight(mi)) {
            throw new ModuleInstanceNotFoundException("analysis", moduleInstanceId);
        }
        Map dataSetConfig = this.getDataSetConfig(moduleInstanceId, dataSetId);
        if (dataSetConfig == null) {
            return this.errorResponse(Response.Status.BAD_REQUEST, "ANALYSIS_DATA_SET_NOT_FOUND", null);
        }
        MultivaluedMap variables = uriInfo.getQueryParameters();
        variables.remove("_dc");
        if (!this.checkVarsValidity(dataSetConfig, (Map<String, List<String>>)variables)) {
            return this.errorResponse(Response.Status.BAD_REQUEST, "One or more variables are not valid", null);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        DataModifier dataModifier = (DataModifier)objectMapper.readValue(requestBody, DataModifier.class);
        int currentIndex = dataModifier.getCurrentModifierIndex();
        List allModifiers = (List)dataSetConfig.get("modifiers");
        List modifiers = currentIndex < 0 ? allModifiers : allModifiers.subList(0, currentIndex + 1);
        Map lastExecutedModifier = null;
        try {
            String data;
            String result = data = this.getData(dataSetConfig, (Map<String, List<String>>)variables, userSession, headers);
            for (Object modifier : modifiers) {
                String modifierCode;
                Map modifierJsonObj;
                lastExecutedModifier = modifierJsonObj = (Map)modifier;
                String type = (String)modifierJsonObj.get("type");
                Object temp = this.executeModifier(result, type, modifierCode = (String)modifierJsonObj.get("modifier"), (Map<String, List<String>>)variables, dataSetConfig);
                if (temp instanceof HashMap || temp instanceof ArrayList) {
                    result = objectMapper.writeValueAsString(temp);
                    continue;
                }
                result = (String)temp;
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).type("application/json").build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NoSuchMethodException e) {
            return this.modifierErrorResponse(Response.Status.BAD_REQUEST, "ANALYSIS_MODIFY_METHOD_NOT_AVAILABLE", e, lastExecutedModifier);
        }
        catch (ScriptException e) {
            return this.modifierErrorResponse(Response.Status.BAD_REQUEST, "ANALYSIS_SCRIPT_EXECUTION_ERROR", e, lastExecutedModifier);
        }
        catch (EngineNotFoundException e) {
            return this.modifierErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Engine not found", e, lastExecutedModifier);
        }
        catch (Exception e) {
            return this.modifierErrorResponse(Response.Status.BAD_REQUEST, "ANALYSIS_SCRIPT_EXECUTION_ERROR", e, lastExecutedModifier);
        }
    }

    private Object executeModifier(String data, String modifierType, String modifier, Map<String, List<String>> variables, Map dataSetConfig) throws Exception {
        switch (modifierType) {
            case "javascript": {
                try (GraalJSScriptEngine jsScriptEngine = this.jsScriptEngineFactory.createSecureJsScriptEngine();){
                    JavascriptModifier jsModifier = new JavascriptModifier((ScriptEngine)jsScriptEngine, dataSetConfig);
                    Object object = jsModifier.modify(data, modifier, variables);
                    return object;
                }
            }
            case "groovy": {
                GroovyModifier groovyModifier = new GroovyModifier(dataSetConfig);
                return groovyModifier.modify(data, modifier, variables);
            }
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="data/inubit/{connectionId}/report/reportdata")
    @BpcUserSessionRequired
    public Response getAllInubitReports(@PathParam(value="connectionId") String connectionId, @Context UserSession userSession, @Context HttpHeaders headers) {
        try {
            String inubitReportApi = "/ibis/rest/report/reportdata?userType=processEngineUser";
            Response response = ((HttpProxyService)this.httpProxyServiceTracker.getService()).doGet(connectionId, inubitReportApi, null, null, headers, userSession);
            return response;
        }
        catch (Exception e) {
            return this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Error while get Inubit Reports", null);
        }
    }

    private boolean checkVarsValidity(Map dataSetConfig, Map<String, List<String>> variables) {
        List variableConfigs = (List)dataSetConfig.get("variables");
        try {
            for (Map.Entry<String, List<String>> var : variables.entrySet()) {
                List availableValues;
                String key = var.getKey();
                String currentValue = var.getValue().get(0);
                Map variableConfig = variableConfigs.stream().filter(config -> ((Map)config).get("name").equals(key)).findAny().orElse(null);
                if (variableConfig == null) continue;
                String type = (String)variableConfig.get("type");
                if (type.equals("number")) {
                    float max;
                    float min;
                    float value = Float.parseFloat(currentValue);
                    String minString = (String)variableConfig.get("min");
                    if (minString != null && !minString.equals("") && value < (min = Float.parseFloat((String)variableConfig.get("min")))) {
                        return false;
                    }
                    String maxString = (String)variableConfig.get("max");
                    if (maxString != null && !maxString.equals("") && value > (max = Float.parseFloat((String)variableConfig.get("max")))) {
                        return false;
                    }
                }
                if (!type.equals("list") || (availableValues = (List)variableConfig.get("_valueList")).contains(currentValue)) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

