/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingResultSet;
import oracle.jdbc.driver.AbstractShardingStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleNClob;
import oracle.jdbc.internal.OracleRef;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.sql.DatumWithConnection;

@ProxyFor(value={OracleBlob.class, OracleClob.class, OracleNClob.class, OracleBfile.class, OracleStruct.class, OracleRef.class, OracleArray.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractShardingLob {
    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract Object getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Object var1);

    public void close() throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        Object delegate = this.getDelegate();
        if (delegate instanceof OracleBlob) {
            ((OracleBlob)delegate).close();
            databaseConnection = ((OracleBlob)delegate).getInternalConnection();
        } else if (delegate instanceof OracleClob) {
            ((OracleClob)delegate).close();
            databaseConnection = ((OracleClob)delegate).getInternalConnection();
        } else if (delegate instanceof OracleNClob) {
            ((OracleNClob)delegate).close();
            databaseConnection = ((OracleNClob)delegate).getInternalConnection();
        } else if (delegate instanceof OracleBfile) {
            ((OracleBfile)delegate).close();
            databaseConnection = ((OracleBfile)delegate).getInternalConnection();
        }
        if (this.isCreatedByConnectionObject()) {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    public void free() throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        Object delegate = this.getDelegate();
        if (delegate instanceof OracleBlob) {
            ((OracleBlob)delegate).free();
            databaseConnection = ((OracleBlob)delegate).getInternalConnection();
        } else if (delegate instanceof OracleClob) {
            ((OracleClob)delegate).free();
            databaseConnection = ((OracleClob)delegate).getInternalConnection();
        } else if (delegate instanceof OracleNClob) {
            ((OracleNClob)delegate).free();
            databaseConnection = ((OracleNClob)delegate).getInternalConnection();
        } else if (delegate instanceof OracleArray) {
            ((OracleArray)delegate).free();
            databaseConnection = ((OracleArray)delegate).getInternalConnection();
        }
        if (this.isCreatedByConnectionObject()) {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    public void freeTemporary() throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        Object delegate = this.getDelegate();
        if (delegate instanceof OracleBlob) {
            ((OracleBlob)delegate).freeTemporary();
            databaseConnection = ((OracleBlob)delegate).getInternalConnection();
        } else if (delegate instanceof OracleClob) {
            ((OracleClob)delegate).freeTemporary();
            databaseConnection = ((OracleClob)delegate).getInternalConnection();
        } else if (delegate instanceof OracleNClob) {
            ((OracleNClob)delegate).freeTemporary();
            databaseConnection = ((OracleNClob)delegate).getInternalConnection();
        }
        if (this.isCreatedByConnectionObject()) {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() {
        Object creator = this.getCreator();
        if (creator instanceof AbstractShardingConnection) {
            return (oracle.jdbc.internal.OracleConnection)creator;
        }
        AbstractShardingResultSet applicationResultSet = (AbstractShardingResultSet)this.getCreator();
        AbstractShardingStatement applicationStatement = (AbstractShardingStatement)applicationResultSet.getCreator();
        return (oracle.jdbc.internal.OracleConnection)applicationStatement.getCreator();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        return this.getInternalConnection();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.getOracleConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    public void setPhysicalConnectionOf(Connection conn) {
        DatumWithConnection delegate = (DatumWithConnection)this.getDelegate();
        delegate.setPhysicalConnectionOf(conn);
    }

    @Pre
    @Methods(signatures={@Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={})})
    protected void preUnsupportedResultSetMethods(Method m, Object receiver, Object ... args) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    boolean isCreatedByConnectionObject() {
        Object creator = this.getCreator();
        return creator instanceof AbstractShardingConnection;
    }
}

