/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.TimerTask;
import oracle.jdbc.internal.Monitor;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;

public final class AsyncOutboundTimeoutHandler {
    private final AsyncOutboundTimeoutHandler loginTimeoutHandler;
    private final Monitor monitor = Monitor.newInstance();
    private SocketChannel channel = null;
    private TimerTask timeoutTask = null;
    private Thread interruptThread = null;
    private IOException timeoutException;

    private AsyncOutboundTimeoutHandler(AsyncOutboundTimeoutHandler loginTimeoutHandler) {
        this.loginTimeoutHandler = loginTimeoutHandler;
    }

    final void setChannel(SocketChannel channel) throws IOException {
        if (this.loginTimeoutHandler != null) {
            this.loginTimeoutHandler.setChannel(channel);
        }
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            this.ensureUnexpired();
            this.channel = channel;
        }
    }

    public void setInterruptThread(Thread thread) throws IOException {
        if (this.loginTimeoutHandler != null) {
            this.loginTimeoutHandler.setInterruptThread(thread);
        }
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            this.ensureUnexpired();
            this.interruptThread = thread;
        }
    }

    public final void scheduleTimeout(Duration duration, IOException timeoutException) throws IOException {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            this.ensureUnexpired();
            this.cancelTimeout();
            this.scheduleTimeoutTask(duration, timeoutException);
        }
    }

    private void scheduleTimeoutTask(Duration duration, IOException timeoutException) {
        this.timeoutTask = TimeoutInterruptHandler.scheduleTask(() -> this.executeTimeout(timeoutException), duration.toMillis());
    }

    private void executeTimeout(IOException timeoutException) {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            this.timeoutException = timeoutException;
            if (this.channel != null) {
                TcpMultiplexer.cancelRegistration(this.channel, timeoutException);
            }
            if (this.interruptThread != null) {
                this.interruptThread.interrupt();
            }
        }
    }

    public final boolean cancelTimeout() {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            boolean bl = this.timeoutTask == null ? false : this.timeoutTask.cancel();
            return bl;
        }
    }

    private final void ensureUnexpired() throws IOException {
        if (this.timeoutException != null) {
            throw this.timeoutException;
        }
    }

    public static AsyncOutboundTimeoutHandler newInstance(AsyncOutboundTimeoutHandler loginTimeoutHandler) {
        return new AsyncOutboundTimeoutHandler(loginTimeoutHandler);
    }

    public static AsyncOutboundTimeoutHandler newScheduledInstance(AsyncOutboundTimeoutHandler loginTimeoutHandler, Duration duration, IOException timeoutException) {
        AsyncOutboundTimeoutHandler newHandler = new AsyncOutboundTimeoutHandler(loginTimeoutHandler);
        newHandler.scheduleTimeoutTask(duration, timeoutException);
        return newHandler;
    }
}

