/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.opensearch.index.query.ParsedQuery;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.security.privileges.dlsfls.AbstractRuleBasedPrivileges;
import org.opensearch.security.privileges.dlsfls.DocumentPrivileges;
import org.opensearch.security.queries.QueryBuilderTraverser;

public class DlsRestriction
extends AbstractRuleBasedPrivileges.Rule {
    public static final DlsRestriction NONE = new DlsRestriction(Collections.emptyList());
    public static final DlsRestriction FULL = new DlsRestriction((List<DocumentPrivileges.RenderedDlsQuery>)ImmutableList.of((Object)DocumentPrivileges.RenderedDlsQuery.MATCH_NONE));
    private static final Query NON_NESTED_QUERY = new BooleanQuery.Builder().add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER).add((Query)new PrefixQuery(new Term("_type", "__")), BooleanClause.Occur.MUST_NOT).build();
    private final ImmutableList<DocumentPrivileges.RenderedDlsQuery> queries;

    DlsRestriction(List<DocumentPrivileges.RenderedDlsQuery> queries) {
        this.queries = ImmutableList.copyOf(queries);
    }

    @Override
    public boolean isUnrestricted() {
        return this.queries.isEmpty();
    }

    public BooleanQuery.Builder toBooleanQueryBuilder(QueryShardContext queryShardContext, Function<Query, Query> queryMapFunction) {
        if (this.queries.isEmpty()) {
            return null;
        }
        boolean hasNestedMapping = queryShardContext.getMapperService().hasNested();
        BooleanQuery.Builder dlsQueryBuilder = new BooleanQuery.Builder();
        dlsQueryBuilder.setMinimumNumberShouldMatch(1);
        for (DocumentPrivileges.RenderedDlsQuery query : this.queries) {
            ParsedQuery parsedQuery = queryShardContext.toQuery(query.getQueryBuilder());
            Query luceneQuery = parsedQuery.query();
            if (queryMapFunction != null) {
                luceneQuery = queryMapFunction.apply(luceneQuery);
            }
            dlsQueryBuilder.add(luceneQuery, BooleanClause.Occur.SHOULD);
            if (!hasNestedMapping) continue;
            BitSetProducer parentDocumentsFilter = queryShardContext.bitsetFilter(NON_NESTED_QUERY);
            dlsQueryBuilder.add((Query)new ToChildBlockJoinQuery(luceneQuery, parentDocumentsFilter), BooleanClause.Occur.SHOULD);
        }
        return dlsQueryBuilder;
    }

    public boolean containsTermLookupQuery() {
        for (DocumentPrivileges.RenderedDlsQuery query : this.queries) {
            if (!QueryBuilderTraverser.exists(query.getQueryBuilder(), q -> q instanceof TermsQueryBuilder && ((TermsQueryBuilder)q).termsLookup() != null)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.isUnrestricted()) {
            return "DLS:<none>";
        }
        return "DLS:" + String.valueOf(this.queries);
    }

    public ImmutableList<DocumentPrivileges.RenderedDlsQuery> getQueries() {
        return this.queries;
    }
}

