/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.LongValues;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeDocument;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.builder.BaseStarTreeBuilder;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.SequentialDocValuesIterator;
import org.opensearch.index.mapper.MapperService;

@ExperimentalApi
public class OnHeapStarTreeBuilder
extends BaseStarTreeBuilder {
    private final List<StarTreeDocument> starTreeDocuments = new ArrayList<StarTreeDocument>();

    public OnHeapStarTreeBuilder(IndexOutput metaOut, IndexOutput dataOut, StarTreeField starTreeField, SegmentWriteState segmentWriteState, MapperService mapperService) throws IOException {
        super(metaOut, dataOut, starTreeField, segmentWriteState, mapperService);
    }

    @Override
    public void appendStarTreeDocument(StarTreeDocument starTreeDocument) {
        this.starTreeDocuments.add(starTreeDocument);
    }

    @Override
    public StarTreeDocument getStarTreeDocument(int docId) {
        return this.starTreeDocuments.get(docId);
    }

    @Override
    public List<StarTreeDocument> getStarTreeDocuments() {
        return this.starTreeDocuments;
    }

    @Override
    public Long getDimensionValue(int docId, int dimensionId) {
        return this.starTreeDocuments.get((int)docId).dimensions[dimensionId];
    }

    @Override
    public Iterator<StarTreeDocument> sortAndAggregateSegmentDocuments(SequentialDocValuesIterator[] dimensionReaders, List<SequentialDocValuesIterator> metricReaders) throws IOException {
        StarTreeDocument[] starTreeDocuments = new StarTreeDocument[this.totalSegmentDocs];
        for (int currentDocId = 0; currentDocId < this.totalSegmentDocs; ++currentDocId) {
            starTreeDocuments[currentDocId] = this.getSegmentStarTreeDocument(currentDocId, dimensionReaders, metricReaders);
        }
        return this.sortAndAggregateStarTreeDocuments(starTreeDocuments, false);
    }

    @Override
    public void build(List<StarTreeValues> starTreeValuesSubs, AtomicInteger fieldNumberAcrossStarTrees, DocValuesConsumer starTreeDocValuesConsumer) throws IOException {
        this.build(this.mergeStarTrees(starTreeValuesSubs), fieldNumberAcrossStarTrees, starTreeDocValuesConsumer);
    }

    @Override
    Iterator<StarTreeDocument> mergeStarTrees(List<StarTreeValues> starTreeValuesSubs) throws IOException {
        this.isMerge = true;
        return this.sortAndAggregateStarTreeDocuments(this.getSegmentsStarTreeDocuments(starTreeValuesSubs), true);
    }

    StarTreeDocument[] getSegmentsStarTreeDocuments(List<StarTreeValues> starTreeValuesSubs) throws IOException {
        ArrayList<StarTreeDocument> starTreeDocuments = new ArrayList<StarTreeDocument>();
        Map<String, OrdinalMap> ordinalMaps = this.getOrdinalMaps(starTreeValuesSubs);
        int seg = 0;
        for (StarTreeValues starTreeValues : starTreeValuesSubs) {
            SequentialDocValuesIterator[] dimensionReaders = new SequentialDocValuesIterator[this.numDimensions];
            ArrayList<SequentialDocValuesIterator> metricReaders = new ArrayList<SequentialDocValuesIterator>();
            AtomicInteger numSegmentDocs = new AtomicInteger();
            this.setReadersAndNumSegmentDocsDuringMerge(dimensionReaders, metricReaders, numSegmentDocs, starTreeValues);
            int currentDocId = 0;
            LinkedHashMap<String, LongValues> longValuesMap = new LinkedHashMap<String, LongValues>();
            for (Map.Entry<String, OrdinalMap> entry : ordinalMaps.entrySet()) {
                longValuesMap.put(entry.getKey(), entry.getValue().getGlobalOrds(seg));
            }
            while (currentDocId < numSegmentDocs.get()) {
                starTreeDocuments.add(this.getStarTreeDocument(currentDocId, dimensionReaders, metricReaders, longValuesMap));
                ++currentDocId;
            }
            ++seg;
        }
        StarTreeDocument[] starTreeDocumentsArr = new StarTreeDocument[starTreeDocuments.size()];
        return starTreeDocuments.toArray(starTreeDocumentsArr);
    }

    Iterator<StarTreeDocument> sortAndAggregateStarTreeDocuments(StarTreeDocument[] starTreeDocuments, boolean isMerge) {
        this.sortStarTreeDocumentsFromDimensionId(starTreeDocuments, -1);
        return this.mergeStarTreeDocuments(starTreeDocuments, isMerge);
    }

    private Iterator<StarTreeDocument> mergeStarTreeDocuments(final StarTreeDocument[] starTreeDocuments, final boolean isMerge) {
        return new Iterator<StarTreeDocument>(this){
            boolean hasNext = true;
            StarTreeDocument currentStarTreeDocument = starTreeDocuments[0];
            int docId = 1;
            final /* synthetic */ OnHeapStarTreeBuilder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public StarTreeDocument next() {
                StarTreeDocument next = this.this$0.reduceSegmentStarTreeDocuments(null, this.currentStarTreeDocument, isMerge);
                while (this.docId < starTreeDocuments.length) {
                    StarTreeDocument starTreeDocument = starTreeDocuments[this.docId];
                    ++this.docId;
                    if (!Arrays.equals((Object[])starTreeDocument.dimensions, (Object[])next.dimensions)) {
                        this.currentStarTreeDocument = starTreeDocument;
                        return next;
                    }
                    next = this.this$0.reduceSegmentStarTreeDocuments(next, starTreeDocument, isMerge);
                }
                this.hasNext = false;
                return next;
            }
        };
    }

    @Override
    public Iterator<StarTreeDocument> generateStarTreeDocumentsForStarNode(int startDocId, int endDocId, final int dimensionId) {
        final int numDocs = endDocId - startDocId;
        final StarTreeDocument[] starTreeDocuments = new StarTreeDocument[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            starTreeDocuments[i] = this.getStarTreeDocument(startDocId + i);
        }
        this.sortStarTreeDocumentsFromDimensionId(starTreeDocuments, dimensionId);
        return new Iterator<StarTreeDocument>(){
            boolean hasNext = true;
            StarTreeDocument currentStarTreeDocument = starTreeDocuments[0];
            int docId = 1;
            final /* synthetic */ OnHeapStarTreeBuilder this$0;
            {
                this.this$0 = this$0;
            }

            private boolean hasSameDimensions(StarTreeDocument starTreeDocument1, StarTreeDocument starTreeDocument2) {
                for (int i = dimensionId + 1; i < this.this$0.numDimensions; ++i) {
                    if (Objects.equals(starTreeDocument1.dimensions[i], starTreeDocument2.dimensions[i])) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public StarTreeDocument next() {
                StarTreeDocument next = this.this$0.reduceStarTreeDocuments(null, this.currentStarTreeDocument);
                next.dimensions[dimensionId] = BaseStarTreeBuilder.STAR_IN_DOC_VALUES_INDEX;
                while (this.docId < numDocs) {
                    StarTreeDocument starTreeDocument = starTreeDocuments[this.docId];
                    ++this.docId;
                    if (!this.hasSameDimensions(starTreeDocument, this.currentStarTreeDocument)) {
                        this.currentStarTreeDocument = starTreeDocument;
                        return next;
                    }
                    next = this.this$0.reduceStarTreeDocuments(next, starTreeDocument);
                }
                this.hasNext = false;
                return next;
            }
        };
    }

    private void sortStarTreeDocumentsFromDimensionId(StarTreeDocument[] starTreeDocuments, int dimensionId) {
        Arrays.sort(starTreeDocuments, (doc1, doc2) -> {
            for (int i = dimensionId + 1; i < this.numDimensions; ++i) {
                if (Objects.equals(doc1.dimensions[i], doc2.dimensions[i])) continue;
                return ((Comparator)this.dimensionComparators.get(i)).compare(doc1.dimensions[i], doc2.dimensions[i]);
            }
            return 0;
        });
    }
}

