/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.suggest.phrase;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.opensearch.search.suggest.phrase.CandidateGenerator;
import org.opensearch.search.suggest.phrase.CandidateScorer;
import org.opensearch.search.suggest.phrase.Correction;
import org.opensearch.search.suggest.phrase.DirectCandidateGenerator;
import org.opensearch.search.suggest.phrase.WordScorer;

final class NoisyChannelSpellChecker {
    public static final double REAL_WORD_LIKELIHOOD = 0.95;
    public static final int DEFAULT_TOKEN_LIMIT = 10;
    private final double realWordLikelihood;
    private final boolean requireUnigram;
    private final int tokenLimit;

    NoisyChannelSpellChecker(double nonErrorLikelihood, boolean requireUnigram, int tokenLimit) {
        this.realWordLikelihood = nonErrorLikelihood;
        this.requireUnigram = requireUnigram;
        this.tokenLimit = tokenLimit;
    }

    Result getCorrections(TokenStream stream, final CandidateGenerator generator, float maxErrors, int numCorrections, WordScorer wordScorer, float confidence, int gramSize) throws IOException {
        final ArrayList candidateSetsList = new ArrayList();
        DirectCandidateGenerator.analyze(stream, new DirectCandidateGenerator.TokenConsumer(this){
            DirectCandidateGenerator.CandidateSet currentSet = null;
            private TypeAttribute typeAttribute;
            private final BytesRefBuilder termsRef = new BytesRefBuilder();
            private boolean anyUnigram = false;
            private boolean anyTokens = false;
            final /* synthetic */ NoisyChannelSpellChecker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void reset(TokenStream stream) {
                super.reset(stream);
                this.typeAttribute = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
            }

            @Override
            public void nextToken() throws IOException {
                this.anyTokens = true;
                BytesRef term = this.fillBytesRef(this.termsRef);
                if (this.this$0.requireUnigram && this.typeAttribute.type() == "shingle") {
                    return;
                }
                this.anyUnigram = true;
                if (this.posIncAttr.getPositionIncrement() == 0 && this.typeAttribute.type() == "SYNONYM") {
                    assert (this.currentSet != null);
                    TermStats termStats = generator.termStats(term);
                    if (termStats.docFreq() > 0) {
                        this.currentSet.addOneCandidate(generator.createCandidate(BytesRef.deepCopyOf((BytesRef)term), termStats, this.this$0.realWordLikelihood));
                    }
                } else {
                    if (this.currentSet != null) {
                        candidateSetsList.add(this.currentSet);
                    }
                    this.currentSet = new DirectCandidateGenerator.CandidateSet(DirectCandidateGenerator.Candidate.EMPTY, generator.createCandidate(BytesRef.deepCopyOf((BytesRef)term), true));
                }
            }

            @Override
            public void end() {
                if (this.currentSet != null) {
                    candidateSetsList.add(this.currentSet);
                }
                if (this.this$0.requireUnigram && !this.anyUnigram && this.anyTokens) {
                    throw new IllegalStateException("At least one unigram is required but all tokens were ngrams");
                }
            }
        });
        if (candidateSetsList.isEmpty() || candidateSetsList.size() >= this.tokenLimit) {
            return Result.EMPTY;
        }
        for (DirectCandidateGenerator.CandidateSet candidateSet : candidateSetsList) {
            generator.drawCandidates(candidateSet);
        }
        double cutoffScore = Double.MIN_VALUE;
        CandidateScorer scorer = new CandidateScorer(wordScorer, numCorrections, gramSize);
        DirectCandidateGenerator.CandidateSet[] candidateSets = candidateSetsList.toArray(new DirectCandidateGenerator.CandidateSet[0]);
        if ((double)confidence > 0.0) {
            DirectCandidateGenerator.Candidate[] candidates = new DirectCandidateGenerator.Candidate[candidateSets.length];
            for (int i = 0; i < candidates.length; ++i) {
                candidates[i] = candidateSets[i].originalTerm;
            }
            double inputPhraseScore = scorer.score(candidates, candidateSets);
            cutoffScore = inputPhraseScore * (double)confidence;
        }
        Correction[] bestCandidates = scorer.findBestCandiates(candidateSets, maxErrors, cutoffScore);
        return new Result(bestCandidates, cutoffScore);
    }

    static class Result {
        public static final Result EMPTY = new Result(Correction.EMPTY, Double.MIN_VALUE);
        public final Correction[] corrections;
        public final double cutoffScore;

        private Result(Correction[] corrections, double cutoffScore) {
            this.corrections = corrections;
            this.cutoffScore = cutoffScore;
        }
    }
}

