/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.http.jwt;

import com.google.common.annotations.VisibleForTesting;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.auth.http.jwt.keybyoidc.AuthenticatorUnavailableException;
import org.opensearch.security.auth.http.jwt.keybyoidc.BadCredentialsException;
import org.opensearch.security.auth.http.jwt.keybyoidc.JwtVerifier;
import org.opensearch.security.auth.http.jwt.keybyoidc.KeyProvider;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.user.AuthCredentials;

public abstract class AbstractHTTPJwtAuthenticator
implements HTTPAuthenticator {
    private static final Logger log = LogManager.getLogger(AbstractHTTPJwtAuthenticator.class);
    private static final DeprecationLogger deprecationLog = DeprecationLogger.getLogger(AbstractHTTPJwtAuthenticator.class);
    private static final String BEARER = "bearer ";
    private static final Pattern BASIC = Pattern.compile("^\\s*Basic\\s.*", 2);
    private KeyProvider keyProvider;
    private JwtVerifier jwtVerifier;
    private final String jwtHeaderName;
    private final boolean isDefaultAuthHeader;
    private final String jwtUrlParameter;
    private final List<String> subjectKey;
    private final List<String> rolesKey;
    private final List<String> requiredAudience;
    private final String requiredIssuer;
    public static final int DEFAULT_CLOCK_SKEW_TOLERANCE_SECONDS = 30;
    private final int clockSkewToleranceSeconds;

    public AbstractHTTPJwtAuthenticator(Settings settings, Path configPath) {
        this.jwtUrlParameter = settings.get("jwt_url_parameter");
        this.jwtHeaderName = settings.get("jwt_header", "Authorization");
        this.isDefaultAuthHeader = "Authorization".equalsIgnoreCase(this.jwtHeaderName);
        this.rolesKey = settings.getAsList("roles_key");
        this.subjectKey = settings.getAsList("subject_key");
        this.clockSkewToleranceSeconds = settings.getAsInt("jwt_clock_skew_tolerance_seconds", Integer.valueOf(30));
        this.requiredAudience = settings.getAsList("required_audience");
        this.requiredIssuer = settings.get("required_issuer");
        if (!this.jwtHeaderName.equals("Authorization")) {
            deprecationLog.deprecate("jwt_header", "The 'jwt_header' setting will be removed in the next major version of OpenSearch.  Consult https://github.com/opensearch-project/security/issues/3886 for more details.", new Object[0]);
        }
        try {
            this.keyProvider = this.initKeyProvider(settings, configPath);
            this.jwtVerifier = new JwtVerifier(this.keyProvider, this.clockSkewToleranceSeconds, this.requiredIssuer, this.requiredAudience);
        }
        catch (Exception e) {
            log.error("Error creating JWT authenticator. JWT authentication will not work", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public AuthCredentials extractCredentials(final SecurityRequest request, ThreadContext context) throws OpenSearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AuthCredentials creds = AccessController.doPrivileged(new PrivilegedAction<AuthCredentials>(){
            final /* synthetic */ AbstractHTTPJwtAuthenticator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public AuthCredentials run() {
                return this.this$0.extractCredentials0(request);
            }
        });
        return creds;
    }

    private AuthCredentials extractCredentials0(SecurityRequest request) throws OpenSearchSecurityException {
        JWTClaimsSet claimsSet;
        String jwtString = this.getJwtTokenString(request);
        if (Strings.isNullOrEmpty((String)jwtString)) {
            return null;
        }
        try {
            SignedJWT jwt = this.jwtVerifier.getVerifiedJwtToken(jwtString);
            claimsSet = jwt.getJWTClaimsSet();
        }
        catch (AuthenticatorUnavailableException e) {
            log.info(e.toString());
            throw new OpenSearchSecurityException(e.getMessage(), RestStatus.SERVICE_UNAVAILABLE, new Object[0]);
        }
        catch (ParseException | BadCredentialsException e) {
            if (log.isTraceEnabled()) {
                log.trace("Extracting JWT token from {} failed", (Object)jwtString, (Object)e);
            }
            return null;
        }
        String subject = this.extractSubject(claimsSet);
        if (subject == null) {
            log.error("No subject found in JWT token");
            return null;
        }
        String[] roles = this.extractRoles(claimsSet);
        AuthCredentials ac = new AuthCredentials(subject, roles).markComplete();
        for (Map.Entry claim : claimsSet.getClaims().entrySet()) {
            ac.addAttribute("attr.jwt." + (String)claim.getKey(), String.valueOf(claim.getValue()));
        }
        return ac;
    }

    protected String getJwtTokenString(SecurityRequest request) {
        String jwtToken = request.header(this.jwtHeaderName);
        if (this.isDefaultAuthHeader && jwtToken != null && BASIC.matcher(jwtToken).matches()) {
            jwtToken = null;
        }
        if (this.jwtUrlParameter != null) {
            if (jwtToken == null || jwtToken.isEmpty()) {
                jwtToken = request.params().get(this.jwtUrlParameter);
            } else {
                request.params().get(this.jwtUrlParameter);
            }
        }
        if (jwtToken == null) {
            return null;
        }
        int index = jwtToken.toLowerCase().indexOf(BEARER);
        if (index > -1) {
            jwtToken = jwtToken.substring(index + BEARER.length());
        }
        return jwtToken;
    }

    @VisibleForTesting
    public String extractSubject(JWTClaimsSet claims) {
        String subject = claims.getSubject();
        if (this.subjectKey != null && !this.subjectKey.isEmpty()) {
            Object subjectObject = null;
            Map claimsMap = claims.getClaims();
            for (int i = 0; i < this.subjectKey.size(); ++i) {
                if (i == this.subjectKey.size() - 1) {
                    subjectObject = claimsMap.get(this.subjectKey.get(i));
                    continue;
                }
                if (claimsMap.get(this.subjectKey.get(i)) instanceof Map) {
                    claimsMap = (Map)claimsMap.get(this.subjectKey.get(i));
                    continue;
                }
                log.warn("Failed to get subject from JWT claims with subject_key '{}'.", this.subjectKey);
                return null;
            }
            if (subjectObject == null) {
                log.warn("Failed to get subject from JWT claims, check if subject_key '{}' is correct.", this.subjectKey);
                return null;
            }
            if (!(subjectObject instanceof String)) {
                log.warn("Expected type String for roles in the JWT for subject_key {}, but value was '{}' ({}). Will convert this value to String.", this.subjectKey, subjectObject, subjectObject.getClass());
                subject = String.valueOf(subjectObject);
            } else {
                subject = (String)subjectObject;
            }
        }
        return subject;
    }

    @VisibleForTesting
    public String[] extractRoles(JWTClaimsSet claims) {
        if (this.rolesKey == null) {
            return new String[0];
        }
        Object rolesObject = null;
        Map claimsMap = claims.getClaims();
        for (int i = 0; i < this.rolesKey.size(); ++i) {
            if (i == this.rolesKey.size() - 1) {
                rolesObject = claimsMap.get(this.rolesKey.get(i));
                continue;
            }
            if (claimsMap.get(this.rolesKey.get(i)) instanceof Map) {
                claimsMap = (Map)claimsMap.get(this.rolesKey.get(i));
                continue;
            }
            log.warn("Failed to get roles from JWT claims with roles_key '{}'. Check if this key is correct and available in the JWT payload.", this.rolesKey);
            return new String[0];
        }
        if (rolesObject == null) {
            log.warn("Failed to get roles from JWT claims with roles_key '{}'. Check if this key is correct and available in the JWT payload.", this.rolesKey);
            return new String[0];
        }
        String[] roles = String.valueOf(rolesObject).split(",");
        if (!(rolesObject instanceof String) && !(rolesObject instanceof Collection)) {
            log.warn("Expected type String or Collection for roles in the JWT for roles_key {}, but value was '{}' ({}). Will convert this value to String.", this.rolesKey, rolesObject, rolesObject.getClass());
        } else if (rolesObject instanceof Collection) {
            roles = ((Collection)rolesObject).toArray(new String[0]);
        }
        return roles;
    }

    protected abstract KeyProvider initKeyProvider(Settings var1, Path var2) throws Exception;

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest request, AuthCredentials authCredentials) {
        return Optional.of(new SecurityResponse(401, Map.of("WWW-Authenticate", "Bearer realm=\"OpenSearch Security\""), ""));
    }

    public List<String> getRequiredAudience() {
        return this.requiredAudience;
    }

    public String getRequiredIssuer() {
        return this.requiredIssuer;
    }
}

