/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

public abstract class AsymmetricECKey
implements AsymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private Algorithm algorithm;
    protected ECDomainParameters domainParameters;

    AsymmetricECKey(Algorithm algorithm, ECDomainParameters eCDomainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = eCDomainParameters;
    }

    AsymmetricECKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID) {
        this(algorithm, ECDomainParametersIndex.lookupDomainParameters(eCDomainParametersID));
    }

    AsymmetricECKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this(algorithm, ECDomainParameters.decodeCurveParameters(algorithmIdentifier));
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public ECDomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }

    protected final boolean isThreadCorrectMode() {
        return this.approvedModeOnly == CryptoServicesRegistrar.isInApprovedOnlyMode();
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (!this.isThreadCorrectMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }
}

