/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.document.bulk;

import java.util.List;
import java.util.Objects;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.index.VersionType;
import org.opensearch.protobufs.BulkRequest;
import org.opensearch.protobufs.BulkRequestBody;
import org.opensearch.protobufs.CreateOperation;
import org.opensearch.protobufs.DeleteOperation;
import org.opensearch.protobufs.IndexOperation;
import org.opensearch.protobufs.OpType;
import org.opensearch.protobufs.UpdateOperation;
import org.opensearch.script.Script;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.grpc.proto.request.common.FetchSourceContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.common.ScriptProtoUtils;
import org.opensearch.transport.grpc.proto.response.document.common.VersionTypeProtoUtils;

public class BulkRequestParserProtoUtils {
    protected BulkRequestParserProtoUtils() {
    }

    private static String valueOrDefault(String value, String globalDefault) {
        if (Strings.isNullOrEmpty((String)value) && !Strings.isNullOrEmpty((String)globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    private static Boolean valueOrDefault(Boolean value, Boolean globalDefault) {
        if (Objects.isNull(value) && !Objects.isNull(globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    public static DocWriteRequest<?>[] getDocWriteRequests(BulkRequest request, String defaultIndex, String defaultRouting, FetchSourceContext defaultFetchSourceContext, String defaultPipeline, Boolean defaultRequireAlias) {
        List bulkRequestBodyList = request.getRequestBodyList();
        DocWriteRequest[] docWriteRequests = new DocWriteRequest[bulkRequestBodyList.size()];
        for (int i = 0; i < bulkRequestBodyList.size(); ++i) {
            BulkRequestBody bulkRequestBodyEntry = (BulkRequestBody)bulkRequestBodyList.get(i);
            String index = defaultIndex;
            String id = null;
            String routing = BulkRequestParserProtoUtils.valueOrDefault(defaultRouting, request.getRouting());
            FetchSourceContext fetchSourceContext = defaultFetchSourceContext;
            OpType opType = null;
            long version = -3L;
            VersionType versionType = VersionType.INTERNAL;
            long ifSeqNo = -2L;
            long ifPrimaryTerm = 0L;
            int retryOnConflict = 0;
            String pipeline = BulkRequestParserProtoUtils.valueOrDefault(defaultPipeline, request.getPipeline());
            Boolean requireAlias = BulkRequestParserProtoUtils.valueOrDefault(defaultRequireAlias, request.getRequireAlias());
            docWriteRequests[i] = switch (bulkRequestBodyEntry.getOperationContainerCase()) {
                case BulkRequestBody.OperationContainerCase.CREATE -> BulkRequestParserProtoUtils.buildCreateRequest(bulkRequestBodyEntry.getCreate(), bulkRequestBodyEntry.getDoc().toByteArray(), index, id, routing, version, versionType, pipeline, ifSeqNo, ifPrimaryTerm, requireAlias);
                case BulkRequestBody.OperationContainerCase.INDEX -> BulkRequestParserProtoUtils.buildIndexRequest(bulkRequestBodyEntry.getIndex(), bulkRequestBodyEntry.getDoc().toByteArray(), opType, index, id, routing, version, versionType, pipeline, ifSeqNo, ifPrimaryTerm, requireAlias);
                case BulkRequestBody.OperationContainerCase.UPDATE -> BulkRequestParserProtoUtils.buildUpdateRequest(bulkRequestBodyEntry.getUpdate(), bulkRequestBodyEntry.getDoc().toByteArray(), bulkRequestBodyEntry, index, id, routing, fetchSourceContext, retryOnConflict, pipeline, ifSeqNo, ifPrimaryTerm, requireAlias);
                case BulkRequestBody.OperationContainerCase.DELETE -> BulkRequestParserProtoUtils.buildDeleteRequest(bulkRequestBodyEntry.getDelete(), index, id, routing, version, versionType, ifSeqNo, ifPrimaryTerm);
                default -> throw new IllegalArgumentException("Invalid BulkRequestBody. An OperationContainer (create, index, update, or delete) must be provided.");
            };
        }
        return docWriteRequests;
    }

    public static IndexRequest buildCreateRequest(CreateOperation createOperation, byte[] document, String index, String id, String routing, long version, VersionType versionType, String pipeline, long ifSeqNo, long ifPrimaryTerm, boolean requireAlias) {
        index = createOperation.hasIndex() ? createOperation.getIndex() : index;
        id = createOperation.hasId() ? createOperation.getId() : id;
        routing = createOperation.hasRouting() ? createOperation.getRouting() : routing;
        long l = version = createOperation.hasVersion() ? createOperation.getVersion() : version;
        if (createOperation.hasVersionType()) {
            versionType = VersionTypeProtoUtils.fromProto(createOperation.getVersionType());
        }
        pipeline = createOperation.hasPipeline() ? createOperation.getPipeline() : pipeline;
        ifSeqNo = createOperation.hasIfSeqNo() ? createOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = createOperation.hasIfPrimaryTerm() ? createOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        requireAlias = createOperation.hasRequireAlias() ? createOperation.getRequireAlias() : requireAlias;
        IndexRequest indexRequest = new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create(true).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(document, MediaTypeRegistry.JSON).setRequireAlias(requireAlias);
        return indexRequest;
    }

    public static IndexRequest buildIndexRequest(IndexOperation indexOperation, byte[] document, OpType opType, String index, String id, String routing, long version, VersionType versionType, String pipeline, long ifSeqNo, long ifPrimaryTerm, boolean requireAlias) {
        opType = indexOperation.hasOpType() ? indexOperation.getOpType() : opType;
        index = indexOperation.hasIndex() ? indexOperation.getIndex() : index;
        id = indexOperation.hasId() ? indexOperation.getId() : id;
        routing = indexOperation.hasRouting() ? indexOperation.getRouting() : routing;
        long l = version = indexOperation.hasVersion() ? indexOperation.getVersion() : version;
        if (indexOperation.hasVersionType()) {
            versionType = VersionTypeProtoUtils.fromProto(indexOperation.getVersionType());
        }
        pipeline = indexOperation.hasPipeline() ? indexOperation.getPipeline() : pipeline;
        ifSeqNo = indexOperation.hasIfSeqNo() ? indexOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = indexOperation.hasIfPrimaryTerm() ? indexOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        requireAlias = indexOperation.hasRequireAlias() ? indexOperation.getRequireAlias() : requireAlias;
        IndexRequest indexRequest = opType == null ? new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(document, MediaTypeRegistry.JSON).setRequireAlias(requireAlias) : new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create(opType.equals((Object)OpType.OP_TYPE_CREATE)).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(document, MediaTypeRegistry.JSON).setRequireAlias(requireAlias);
        return indexRequest;
    }

    public static UpdateRequest buildUpdateRequest(UpdateOperation updateOperation, byte[] document, BulkRequestBody bulkRequestBody, String index, String id, String routing, FetchSourceContext fetchSourceContext, int retryOnConflict, String pipeline, long ifSeqNo, long ifPrimaryTerm, boolean requireAlias) {
        index = updateOperation.hasIndex() ? updateOperation.getIndex() : index;
        id = updateOperation.hasId() ? updateOperation.getId() : id;
        routing = updateOperation.hasRouting() ? updateOperation.getRouting() : routing;
        fetchSourceContext = bulkRequestBody.hasSource() ? FetchSourceContextProtoUtils.fromProto(bulkRequestBody.getSource()) : fetchSourceContext;
        retryOnConflict = updateOperation.hasRetryOnConflict() ? updateOperation.getRetryOnConflict() : retryOnConflict;
        ifSeqNo = updateOperation.hasIfSeqNo() ? updateOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = updateOperation.hasIfPrimaryTerm() ? updateOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        requireAlias = updateOperation.hasRequireAlias() ? updateOperation.getRequireAlias() : requireAlias;
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(id).routing(routing).retryOnConflict(retryOnConflict).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).setRequireAlias(requireAlias).routing(routing);
        updateRequest = BulkRequestParserProtoUtils.fromProto(updateRequest, document, bulkRequestBody, updateOperation);
        if (fetchSourceContext != null) {
            updateRequest.fetchSource(fetchSourceContext);
        }
        return updateRequest;
    }

    public static UpdateRequest fromProto(UpdateRequest updateRequest, byte[] document, BulkRequestBody bulkRequestBody, UpdateOperation updateOperation) {
        if (bulkRequestBody.hasScript()) {
            Script script = ScriptProtoUtils.parseFromProtoRequest(bulkRequestBody.getScript());
            updateRequest.script(script);
        }
        if (bulkRequestBody.hasScriptedUpsert()) {
            updateRequest.scriptedUpsert(bulkRequestBody.getScriptedUpsert());
        }
        if (bulkRequestBody.hasUpsert()) {
            updateRequest.upsert(new Object[]{bulkRequestBody.getUpsert(), MediaTypeRegistry.JSON});
        }
        updateRequest.doc(document, MediaTypeRegistry.JSON);
        if (bulkRequestBody.hasDocAsUpsert()) {
            updateRequest.docAsUpsert(bulkRequestBody.getDocAsUpsert());
        }
        if (bulkRequestBody.hasDetectNoop()) {
            updateRequest.detectNoop(bulkRequestBody.getDetectNoop());
        }
        if (bulkRequestBody.hasDocAsUpsert()) {
            updateRequest.docAsUpsert(bulkRequestBody.getDocAsUpsert());
        }
        if (bulkRequestBody.hasSource()) {
            updateRequest.fetchSource(FetchSourceContextProtoUtils.fromProto(bulkRequestBody.getSource()));
        }
        if (updateOperation.hasIfSeqNo()) {
            updateRequest.setIfSeqNo(updateOperation.getIfSeqNo());
        }
        if (updateOperation.hasIfPrimaryTerm()) {
            updateRequest.setIfPrimaryTerm(updateOperation.getIfPrimaryTerm());
        }
        return updateRequest;
    }

    public static DeleteRequest buildDeleteRequest(DeleteOperation deleteOperation, String index, String id, String routing, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm) {
        index = deleteOperation.hasIndex() ? deleteOperation.getIndex() : index;
        id = deleteOperation.hasId() ? deleteOperation.getId() : id;
        routing = deleteOperation.hasRouting() ? deleteOperation.getRouting() : routing;
        long l = version = deleteOperation.hasVersion() ? deleteOperation.getVersion() : version;
        if (deleteOperation.hasVersionType()) {
            versionType = VersionTypeProtoUtils.fromProto(deleteOperation.getVersionType());
        }
        ifSeqNo = deleteOperation.hasIfSeqNo() ? deleteOperation.getIfSeqNo() : ifSeqNo;
        ifPrimaryTerm = deleteOperation.hasIfPrimaryTerm() ? deleteOperation.getIfPrimaryTerm() : ifPrimaryTerm;
        DeleteRequest deleteRequest = new DeleteRequest(index).id(id).routing(routing).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm);
        return deleteRequest;
    }
}

