/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import org.opensearch.core.xcontent.ToXContent;

public class BackupJobScheduleWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "BackupJobScheduleMessage:::";
    private final BackupJobScheduleActionDTO scheduleAction;
    private final Instant sendedAtInUtc;

    public BackupJobScheduleWebsocketMessage(BackupJobScheduleActionDTO scheduleAction) {
        this(scheduleAction, TimestampUtil.nowInUtc());
    }

    public BackupJobScheduleWebsocketMessage(BackupJobScheduleActionDTO scheduleAction, Instant sendedAtInUtc) {
        this.scheduleAction = scheduleAction;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public BackupJobScheduleWebsocketMessage(Map<String, Object> msgMap) {
        this(new BackupJobScheduleActionDTO(MapUtil.getValueAsMap(msgMap, (String)"action", null)), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
        this.checkForWellKnownKeys(msgMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> msgMap) {
        MapUtil.checkForWellKnownKeys(msgMap, Set.of("action", "sendedAt"));
    }

    private Map<String, Object> asMap() throws IOException {
        return MapUtil.mapOf((Object[])new Object[]{"action", JsonUtil.asMap((ToXContent)this.scheduleAction), "sendedAt", this.sendedAtInUtc});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static BackupJobScheduleWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new BackupJobScheduleWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + BackupJobScheduleWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public BackupJobScheduleActionDTO getScheduleAction() {
        return this.scheduleAction;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "BackupJobScheduleWebsocketMessage{, scheduleAction=" + String.valueOf(this.scheduleAction) + ", sendedAtInUtc=" + String.valueOf(this.sendedAtInUtc) + "}";
    }
}

