/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.annotation.MultipartConfig;
import org.apache.tomcat.util.bcel.classfile.AnnotationElementValue;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.ArrayElementValue;
import org.apache.tomcat.util.bcel.classfile.ClassParser;
import org.apache.tomcat.util.bcel.classfile.ElementValue;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;
import org.apache.tomcat.util.bcel.classfile.EnumElementValue;
import org.apache.tomcat.util.bcel.classfile.JavaClass;
import org.apache.tomcat.util.bcel.classfile.SimpleElementValue;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.MultipartDef;
import org.apache.tomcat.util.descriptor.web.ServletDef;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.ops4j.pax.web.extender.war.internal.WarExtenderContext;
import org.ops4j.pax.web.extender.war.internal.model.AttributeCollectingServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContextClassLoader;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWebApplicationClassSpace {
    public static final Logger LOG = LoggerFactory.getLogger(BundleWebApplicationClassSpace.class);
    private static final Set<ServletContainerInitializer> NO_SCIS = new HashSet<ServletContainerInitializer>();
    private final Bundle wabBundle;
    private OsgiServletContextClassLoader wabClassLoader;
    private final WarExtenderContext extenderContext;
    private final Map<String, URL> wabClassPath = new LinkedHashMap<String, URL>();
    private final Map<String, Boolean> wabClassPathSkipped = new HashMap<String, Boolean>();
    private final Map<String, Bundle> containerFragmentBundles = new LinkedHashMap<String, Bundle>();
    private final Map<String, Bundle> applicationFragmentBundles = new LinkedHashMap<String, Bundle>();
    private final Map<String, WebXml> fragments = new HashMap<String, WebXml>();
    private final Map<String, WebXml> orderedFragments = new LinkedHashMap<String, WebXml>();
    private List<String> orderedLibs = null;
    private boolean fragmentParsingOK = true;
    private WebXml mainWebXml;

    public BundleWebApplicationClassSpace(Bundle wabBundle, WarExtenderContext extenderContext) {
        this.wabBundle = wabBundle;
        this.extenderContext = extenderContext;
    }

    public boolean isFragmentParsingOK() {
        return this.fragmentParsingOK;
    }

    public Set<WebXml> getOrderedFragments() {
        return new LinkedHashSet<WebXml>(this.orderedFragments.values());
    }

    public List<String> getOrderedLibs() {
        return this.orderedLibs;
    }

    public Collection<URL> getWabClassPath() {
        return this.wabClassPath.values();
    }

    public Set<URL> getWabClassPathNotScanned() {
        HashSet<URL> skipped = new HashSet<URL>();
        this.wabClassPath.forEach((name, url) -> {
            Boolean b = this.wabClassPathSkipped.get(name);
            if (b != null && b.booleanValue()) {
                skipped.add((URL)url);
            }
        });
        return skipped;
    }

    public Map<Bundle, URL> getApplicationFragmentBundles() {
        LinkedHashMap<Bundle, URL> result = new LinkedHashMap<Bundle, URL>(this.applicationFragmentBundles.size());
        for (Bundle b : this.applicationFragmentBundles.values()) {
            result.put(b, b.getEntry("/"));
        }
        return result;
    }

    public Collection<Bundle> getContainerFragmentBundles() {
        return this.containerFragmentBundles.values();
    }

    public void initialize(WebXml mainWebXml, OsgiServletContextClassLoader wabClassLoader) {
        Bundle undertowWebSocketBundle;
        Bundle tomcatWebSocketBundle;
        Bundle jettyWebSocketBundle;
        List hostWires;
        URL[] jars;
        this.mainWebXml = mainWebXml;
        this.wabClassLoader = wabClassLoader;
        Set absoluteOrdering = mainWebXml.getAbsoluteOrdering();
        boolean parseRequired = absoluteOrdering == null || !absoluteOrdering.isEmpty();
        Bundle paxWebJspBundle = Utils.getPaxWebJspBundle((Bundle)this.wabBundle);
        LOG.trace("Searching for web fragments in WAB Bundle-ClassPath jars");
        for (URL url : jars = ClassPathUtil.getClassPathJars((Bundle)this.wabBundle, (boolean)false)) {
            LOG.trace("  Checking embedded jar {}", (Object)url);
            try {
                String jarName = this.extractJarFileName(url.toString());
                boolean skipScanning = this.extenderContext.skipJarScanning(jarName);
                WebXml fragment = this.process(url, parseRequired && !skipScanning, skipScanning, jarName);
                fragment.setWebappJar(true);
                this.addFragment(fragment);
                this.wabClassPath.put(fragment.getJarName(), url);
                this.wabClassPathSkipped.put(fragment.getJarName(), skipScanning);
            }
            catch (Exception e) {
                LOG.warn("  Problem scanning embedded jar {}: {}", new Object[]{url, e.getMessage(), e});
            }
        }
        LOG.trace("Searching for web fragments in WAB bundle fragments");
        BundleWiring wiring = (BundleWiring)this.wabBundle.adapt(BundleWiring.class);
        if (wiring != null && (hostWires = wiring.getProvidedWires("osgi.wiring.host")) != null) {
            for (BundleWire wire : hostWires) {
                Bundle b = wire.getRequirerWiring().getBundle();
                LOG.trace("  Checking bundle fragment {}", (Object)b);
                try {
                    URL fragmentRootURL = b.getEntry("/");
                    boolean skipScanning = this.extenderContext.skipBundleScanning(b);
                    WebXml fragment = this.process(fragmentRootURL, parseRequired && !skipScanning, skipScanning, this.extractJarFileName(b));
                    fragment.setWebappJar(true);
                    this.addFragment(fragment);
                    this.wabClassPath.put(fragment.getJarName(), fragmentRootURL);
                    this.wabClassPathSkipped.put(fragment.getJarName(), skipScanning);
                }
                catch (Exception e) {
                    LOG.warn("  Problem scanning bundle fragment {}: {}", new Object[]{b, e.getMessage(), e});
                }
            }
        }
        LOG.trace("Searching for web fragments in WAB wired bundles");
        HashSet<Bundle> processedBundles = new HashSet<Bundle>();
        HashSet<Bundle> reached = new HashSet<Bundle>();
        LinkedList<Bundle> bundles = new LinkedList<Bundle>();
        bundles.add(this.wabBundle);
        processedBundles.add(this.wabBundle);
        reached.add(this.wabBundle);
        if (paxWebJspBundle != null) {
            bundles.add(paxWebJspBundle);
            reached.add(paxWebJspBundle);
        }
        if ((jettyWebSocketBundle = Utils.getJettyWebSocketBundle((Bundle)this.wabBundle)) != null) {
            bundles.add(jettyWebSocketBundle);
            reached.add(jettyWebSocketBundle);
        }
        if ((tomcatWebSocketBundle = Utils.getTomcatWebSocketBundle((Bundle)this.wabBundle)) != null) {
            bundles.add(tomcatWebSocketBundle);
            reached.add(tomcatWebSocketBundle);
        }
        if ((undertowWebSocketBundle = Utils.getUndertowWebSocketBundle((Bundle)this.wabBundle)) != null) {
            bundles.add(undertowWebSocketBundle);
            reached.add(undertowWebSocketBundle);
        }
        HashSet reachable = new HashSet();
        ClassPathUtil.getBundlesInClassSpace((Bundle)this.wabBundle, reachable, (boolean)false);
        for (Bundle rb : reachable) {
            if (reached.contains(rb) || processedBundles.contains(rb) || Utils.isFragment((Bundle)rb)) continue;
            reached.add(rb);
            bundles.add(rb);
        }
        while (bundles.size() > 0) {
            Bundle scannedBundle = (Bundle)bundles.pop();
            if (this.extenderContext.skipBundleScanning(scannedBundle) || scannedBundle.getBundleId() == 0L) {
                if (!processedBundles.add(scannedBundle)) continue;
                LOG.trace("  Skipped checking of wired bundle {}", (Object)scannedBundle);
                continue;
            }
            if (processedBundles.contains(scannedBundle)) continue;
            LOG.trace("  Checking wired bundle {}", (Object)scannedBundle);
            try {
                this.extenderContext.skipBundleScanning(scannedBundle);
                List<WebXml> fragmentList = this.process(scannedBundle, parseRequired);
                for (WebXml fragment : fragmentList) {
                    this.addFragment(fragment);
                    if (!fragment.getWebappJar()) {
                        this.containerFragmentBundles.put(fragment.getJarName(), scannedBundle);
                        continue;
                    }
                    this.applicationFragmentBundles.put(fragment.getJarName(), scannedBundle);
                }
                processedBundles.add(scannedBundle);
            }
            catch (Exception e) {
                LOG.warn("  Problem scanning wired bundle {}: {}", new Object[]{scannedBundle, e.getMessage(), e});
            }
        }
        AttributeCollectingServletContext context = new AttributeCollectingServletContext();
        Set fragments = WebXml.orderWebFragments((WebXml)mainWebXml, this.fragments, (ServletContext)context);
        for (WebXml fragment : fragments) {
            this.orderedFragments.put(fragment.getJarName(), fragment);
        }
        this.orderedLibs = (List)context.getAttribute("javax.servlet.context.orderedLibs");
        LinkedHashSet<Bundle> delegateBundles = new LinkedHashSet<Bundle>();
        delegateBundles.addAll(this.applicationFragmentBundles.values());
        delegateBundles.addAll(this.containerFragmentBundles.values());
        delegateBundles.remove(this.wabBundle);
        delegateBundles.forEach(arg_0 -> ((OsgiServletContextClassLoader)this.wabClassLoader).addBundle(arg_0));
    }

    private WebXml process(URL url, boolean parseRequired, boolean skip, String jarName) throws IOException {
        List urls;
        WebXml fragment = new WebXml();
        fragment.setName(jarName);
        fragment.setURL(url);
        fragment.setJarName(jarName);
        URL fragmentURL = null;
        if (parseRequired && (urls = ClassPathUtil.findEntries((Bundle)this.wabBundle, (URL[])new URL[]{url}, (String)"META-INF", (String)"web-fragment.xml", (boolean)false)).size() > 0) {
            fragmentURL = (URL)urls.get(0);
        }
        if (fragmentURL != null) {
            if (!this.extenderContext.getParser().parseWebXml(fragmentURL, fragment, true)) {
                this.fragmentParsingOK = false;
                LOG.trace("    Found web fragment with invalid descriptor, name: {}, url: {}, jarName: {}", new Object[]{fragment.getName(), url, jarName});
            } else {
                LOG.trace("    Found web fragment with descriptor, name: {}, url: {}, jarName: {}", new Object[]{fragment.getName(), url, jarName});
            }
        } else if (!skip) {
            LOG.trace("    Found web fragment without descriptor, url: {}, jarName: {}", (Object)url, (Object)jarName);
        } else {
            LOG.trace("    Skipped web fragment, url: {}, jarName: {}", (Object)url, (Object)jarName);
        }
        return fragment;
    }

    private List<WebXml> process(Bundle bundle, boolean parseRequired) throws IOException {
        LinkedList fragmentURLs = new LinkedList();
        if (parseRequired) {
            List urls = ClassPathUtil.findEntries((Bundle)bundle, (String)"META-INF", (String)"web-fragment.xml", (boolean)false, (boolean)false);
            fragmentURLs.addAll(urls);
        }
        if (fragmentURLs.isEmpty()) {
            WebXml fragment = new WebXml();
            fragment.setWebappJar(false);
            URL fragmentRootURL = bundle.getEntry("/");
            fragment.setURL(fragmentRootURL);
            fragment.setJarName(this.extractJarFileName(bundle));
            fragment.setName(fragment.getJarName());
            LOG.trace("    Found web fragment without descriptor, url: {}, jarName: {}", (Object)fragmentRootURL, (Object)fragment.getJarName());
            return Collections.singletonList(fragment);
        }
        ArrayList<WebXml> fragments = new ArrayList<WebXml>(fragmentURLs.size());
        for (URL fragmentURL : fragmentURLs) {
            WebXml fragment = new WebXml();
            fragment.setWebappJar(true);
            fragment.setURL(new URL(String.format("%s://%s:%d/", fragmentURL.getProtocol(), fragmentURL.getHost(), fragmentURL.getPort())));
            fragment.setJarName(this.extractJarFileName(fragmentURL.toString()));
            boolean ok = this.extenderContext.getParser().parseWebXml(fragmentURL, fragment, true);
            if (fragment.getName() == null) {
                fragment.setName(fragment.getJarName());
            }
            if (ok) {
                LOG.trace("    Found web fragment with descriptor, name: {}, url: {}, jarName: {}", new Object[]{fragment.getName(), fragment.getURL(), fragment.getJarName()});
            } else {
                LOG.trace("    Found web fragment with invalid descriptor, name: {}, url: {}, jarName: {}", new Object[]{fragment.getName(), fragment.getURL(), fragment.getJarName()});
            }
            this.fragmentParsingOK &= ok;
            fragments.add(fragment);
        }
        return fragments;
    }

    private String extractJarFileName(String uri) {
        if (uri.startsWith("bundle://") && uri.indexOf(46) > 10) {
            try {
                String id = uri.substring(9, uri.indexOf(46));
                String uuid = this.wabBundle.getBundleContext().getProperty("org.osgi.framework.uuid");
                if (uuid != null && id.startsWith(uuid)) {
                    id = id.substring(uuid.length() + 1);
                }
                Bundle b = this.wabBundle.getBundleContext().getBundle(Long.parseLong(id));
                return this.extractJarFileName(b);
            }
            catch (Exception e) {
                return uri;
            }
        }
        if (uri.startsWith("bundleentry://") && uri.indexOf(46) > 15) {
            try {
                String id = uri.substring(14, uri.indexOf(46));
                Bundle b = this.wabBundle.getBundleContext().getBundle(Long.parseLong(id));
                return this.extractJarFileName(b);
            }
            catch (Exception e) {
                return uri;
            }
        }
        if (uri.endsWith("!/")) {
            uri = uri.substring(0, uri.length() - 2);
        }
        return uri.substring(uri.lastIndexOf(47) + 1);
    }

    private String extractJarFileName(Bundle bundle) {
        return String.format("%s-%s.bundle", bundle.getSymbolicName(), bundle.getVersion().toString());
    }

    private void addFragment(WebXml fragment) {
        if (this.fragments.containsKey(fragment.getName())) {
            String duplicateName = fragment.getName();
            this.fragments.get(duplicateName).addDuplicate(fragment.getURL().toString());
            if (fragment.getJarName() != null) {
                LOG.warn("There already exists a web fragment named {}. Renaming to {}.", (Object)duplicateName, (Object)fragment.getJarName());
                fragment.setName(fragment.getJarName());
            } else {
                throw new IllegalArgumentException("Can't add a fragment named \"" + fragment.getName() + "\". It is already added.");
            }
        }
        this.fragments.put(fragment.getName(), fragment);
    }

    public List<ServletContainerInitializer> loadSCIs() throws IOException {
        LinkedHashMap<Bundle, List> containerSCIURLs = new LinkedHashMap<Bundle, List>();
        LinkedHashMap<Bundle, List> applicationSCIURLs = new LinkedHashMap<Bundle, List>();
        LinkedList wabSCIURLs = new LinkedList();
        String sciService = "META-INF/services/" + ServletContainerInitializer.class.getName();
        LOG.trace("Searching for ServletContainerInitializers in container fragments");
        for (String string : this.containerFragmentBundles.keySet()) {
            Bundle bundle = this.containerFragmentBundles.get(string);
            LOG.trace("  Scanning container fragment {}", (Object)string);
            List urls3 = ClassPathUtil.getResources(Collections.singletonList(bundle), (String)sciService);
            containerSCIURLs.put(bundle, urls3);
            if (!LOG.isTraceEnabled()) continue;
            for (URL url2 : urls3) {
                LOG.trace("    Found SCI service {}", (Object)url2);
            }
        }
        if (this.orderedLibs == null) {
            HashSet<Bundle> processed = new HashSet<Bundle>();
            LOG.trace("Searching for ServletContainerInitializers in application fragments");
            for (Map.Entry<String, Bundle> entry : this.applicationFragmentBundles.entrySet()) {
                String fragmentJarName = entry.getKey();
                Bundle b2 = entry.getValue();
                if (this.wabClassPath.containsKey(fragmentJarName) || !processed.add(b2)) continue;
                LOG.trace("  Scanning application fragment {}", (Object)fragmentJarName);
                List urls2 = ClassPathUtil.getResources(Collections.singletonList(b2), (String)sciService);
                applicationSCIURLs.put(b2, urls2);
                if (!LOG.isTraceEnabled()) continue;
                Iterator iterator = urls2.iterator();
                while (iterator.hasNext()) {
                    URL url3 = (URL)iterator.next();
                    LOG.trace("    Found SCI service {}", (Object)url3);
                }
            }
            LOG.trace("Searching for ServletContainerInitializers in the WAB");
            LOG.trace("  Scanning the WAB");
            List list = ClassPathUtil.getResources(Collections.singletonList(this.wabBundle), (String)sciService);
            wabSCIURLs.addAll(list);
            if (LOG.isTraceEnabled()) {
                for (URL url4 : list) {
                    LOG.trace("    Found SCI service {}", (Object)url4);
                }
            }
        } else {
            LOG.trace("Searching for ServletContainerInitializers in the WAB");
            LOG.trace("  Scanning the WAB directory entries");
            List wabURLs = ClassPathUtil.findEntries((Bundle)this.wabBundle, (URL[])ClassPathUtil.getClassPathNonJars((Bundle)this.wabBundle), (String)"META-INF/services", (String)ServletContainerInitializer.class.getName(), (boolean)false);
            wabSCIURLs.addAll(wabURLs);
            if (LOG.isTraceEnabled()) {
                for (URL uRL : wabURLs) {
                    LOG.trace("    Found SCI service {}", (Object)uRL);
                }
            }
            LOG.trace("Searching for ServletContainerInitializers in ordered fragments");
            HashMap<Bundle, String> hashMap = new HashMap<Bundle, String>();
            for (String jarName : this.orderedLibs) {
                if (this.wabClassPath.containsKey(jarName)) {
                    if (this.extenderContext.skipJarScanning(jarName)) {
                        LOG.trace("  Skipped scanning of embedded JAR {}", (Object)jarName);
                        continue;
                    }
                    LOG.trace("  Scanning embedded JAR {}", (Object)jarName);
                    List urls5 = ClassPathUtil.findEntries((Bundle)this.wabBundle, (URL[])new URL[]{this.orderedFragments.get(jarName).getURL()}, (String)"META-INF/services", (String)ServletContainerInitializer.class.getName(), (boolean)false);
                    wabSCIURLs.addAll(urls5);
                    if (!LOG.isTraceEnabled()) continue;
                    for (URL url6 : urls5) {
                        LOG.trace("    Found SCI service {}", (Object)url6);
                    }
                    continue;
                }
                if (!this.applicationFragmentBundles.containsKey(jarName)) continue;
                Bundle fragmentBundle = this.applicationFragmentBundles.get(jarName);
                if (hashMap.containsKey(fragmentBundle)) {
                    LOG.trace("  Skipping application fragment {} (SCIs already loaded through {} from fragment {})", new Object[]{jarName, fragmentBundle, hashMap.get(fragmentBundle)});
                    continue;
                }
                hashMap.put(fragmentBundle, jarName);
                LOG.trace("  Scanning application fragment {}", (Object)jarName);
                List urls2 = ClassPathUtil.findEntries((Bundle)fragmentBundle, (URL[])new URL[]{this.orderedFragments.get(jarName).getURL()}, (String)"META-INF/services", (String)ServletContainerInitializer.class.getName(), (boolean)false);
                applicationSCIURLs.put(fragmentBundle, urls2);
                if (!LOG.isTraceEnabled()) continue;
                for (URL url7 : urls2) {
                    LOG.trace("    Found SCI service {}", (Object)url7);
                }
            }
        }
        LinkedList<ServletContainerInitializer> detectedSCIs = new LinkedList<ServletContainerInitializer>();
        LOG.trace("Instantiating ServletContainerInitializers");
        containerSCIURLs.forEach((b, urls) -> {
            LOG.trace("  Loading SCIs from {}", b);
            for (URL url : urls) {
                this.loadSCI(url, (Bundle)b, (List<ServletContainerInitializer>)detectedSCIs);
            }
        });
        applicationSCIURLs.forEach((b, urls) -> {
            LOG.trace("  Loading SCIs from {}", b);
            for (URL url : urls) {
                this.loadSCI(url, (Bundle)b, (List<ServletContainerInitializer>)detectedSCIs);
            }
        });
        LOG.trace("  Loading SCIs from WAB");
        wabSCIURLs.forEach(url -> this.loadSCI((URL)url, this.wabBundle, (List<ServletContainerInitializer>)detectedSCIs));
        return detectedSCIs;
    }

    private void loadSCI(URL url, Bundle bundle, List<ServletContainerInitializer> scis) {
        LOG.trace("    Loading {}", (Object)url);
        try (InputStream is = url.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String name = line.trim();
                if (name.startsWith("#")) continue;
                int idx = name.indexOf(35);
                if (idx > 0) {
                    name = name.substring(0, idx).trim();
                }
                if (name.length() <= 0) continue;
                try {
                    Class sciClass = bundle.loadClass(name);
                    ServletContainerInitializer sci = (ServletContainerInitializer)sciClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    LOG.trace("      Loaded SCI {}", sci.getClass());
                    scis.add(sci);
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.error("      Problem loading SCI class from {}: {}", new Object[]{url, e.getMessage(), e});
                }
            }
        }
        catch (IOException e) {
            LOG.error("    Problem reading SCI service class from {}: {}", new Object[]{url, e.getMessage(), e});
        }
    }

    public void scanClasses(Map<Class<?>, Set<ServletContainerInitializer>> htToSci, Map<ServletContainerInitializer, Set<Class<?>>> sciToHt, boolean thereAreHTClasses, boolean thereAreHTAnnotations) throws IOException {
        HashMap<String, ClassCacheEntry> javaClassCache = new HashMap<String, ClassCacheEntry>();
        ClassCacheEntry root = new ClassCacheEntry();
        root.scis = NO_SCIS;
        root.superClassName = Object.class.getName();
        root.interfaceNames = new String[0];
        javaClassCache.put(root.superClassName, root);
        LOG.trace("Scanning classes in WAB directory entries");
        URL[] urls = ClassPathUtil.getClassPathNonJars((Bundle)this.wabBundle);
        boolean htOnly = this.mainWebXml.isMetadataComplete();
        HashSet<String> processedRoots = new HashSet<String>();
        for (URL url : urls) {
            LOG.trace("  Scanning embedded directory: {}", (Object)url);
            List classes = ClassPathUtil.findEntries((Bundle)this.wabBundle, (URL[])new URL[]{url}, (String)"/", (String)"*.class", (boolean)true);
            for (URL u : classes) {
                processedRoots.add(u.toExternalForm());
                if (!u.getPath().endsWith(".class")) continue;
                LOG.trace("    Scanning {}", (Object)u);
                this.processClass(u, this.mainWebXml, this.wabBundle, htOnly, htToSci, sciToHt, javaClassCache, thereAreHTClasses, thereAreHTAnnotations);
            }
        }
        LOG.trace("Scanning classes in ordered fragments");
        LinkedHashMap<String, Bundle> allFragmentBundles = new LinkedHashMap<String, Bundle>(this.containerFragmentBundles);
        allFragmentBundles.putAll(this.applicationFragmentBundles);
        HashMap<Bundle, String> processed = new HashMap<Bundle, String>();
        for (Map.Entry<String, WebXml> entry : this.orderedFragments.entrySet()) {
            String jarName = entry.getKey();
            WebXml fragment = entry.getValue();
            boolean bundleFragment = jarName.endsWith(".bundle");
            Bundle fragmentBundle = (Bundle)allFragmentBundles.get(jarName);
            if (fragmentBundle == null) {
                fragmentBundle = this.wabBundle;
            }
            if (processed.containsKey(fragmentBundle) && bundleFragment) {
                LOG.trace("  Skipping ordered fragment {} (already scanned through {} from fragment {})", new Object[]{jarName, fragmentBundle, processed.get(fragmentBundle)});
                continue;
            }
            Boolean skipJar = this.wabClassPathSkipped.get(jarName);
            if (skipJar != null && skipJar.booleanValue()) {
                LOG.trace("  Skipping ordered fragment {} (by configuration)", (Object)jarName);
                continue;
            }
            if (bundleFragment) {
                processed.put(fragmentBundle, jarName);
            }
            LOG.trace("  Scanning ordered fragment {}, {} ({})", new Object[]{jarName, fragment.getURL(), fragment.getWebappJar() ? "WAB" : "container"});
            List classes = ClassPathUtil.findEntries((Bundle)fragmentBundle, (URL[])new URL[]{fragment.getURL()}, (String)"/", (String)"*.class", (boolean)true);
            boolean fragmentHtOnly = htOnly || fragment.isMetadataComplete() || !fragment.getWebappJar();
            for (URL u : classes) {
                if (fragmentBundle == this.wabBundle && bundleFragment) {
                    String ef = u.toExternalForm();
                    boolean skip = false;
                    for (String pr : processedRoots) {
                        if (!ef.startsWith(pr)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) {
                        LOG.trace("    Skipping {}", (Object)u);
                        continue;
                    }
                }
                if (!u.getPath().endsWith(".class")) continue;
                LOG.trace("    Scanning {}", (Object)u);
                this.processClass(u, fragment, fragmentBundle, fragmentHtOnly, htToSci, sciToHt, javaClassCache, thereAreHTClasses, thereAreHTAnnotations);
            }
        }
        javaClassCache.clear();
    }

    private void processClass(URL url, WebXml fragment, Bundle bundle, boolean fragmentHtOnly, Map<Class<?>, Set<ServletContainerInitializer>> htToSci, Map<ServletContainerInitializer, Set<Class<?>>> sciToHt, Map<String, ClassCacheEntry> javaClassCache, boolean thereAreHTClasses, boolean thereAreHTAnnotations) {
        try (InputStream is = url.openStream();){
            ClassParser parser = new ClassParser(is);
            JavaClass clazz = parser.parse();
            if ((thereAreHTClasses || thereAreHTAnnotations) && (clazz.getAccessFlags() & 0x2000) == 0) {
                this.checkHandlesTypes(clazz, bundle, htToSci, sciToHt, javaClassCache, thereAreHTClasses, thereAreHTAnnotations);
            }
            if (!fragmentHtOnly) {
                this.checkClass(fragment, bundle, htToSci, clazz, javaClassCache);
            }
        }
        catch (IOException e) {
            LOG.warn("Can't read {}: {}", new Object[]{url, e.getMessage(), e});
        }
    }

    private void checkHandlesTypes(JavaClass clazz, Bundle bundle, Map<Class<?>, Set<ServletContainerInitializer>> htToSci, Map<ServletContainerInitializer, Set<Class<?>>> sciToHt, Map<String, ClassCacheEntry> javaClassCache, boolean thereAreHTClasses, boolean thereAreHTAnnotations) {
        String className = clazz.getClassName();
        Class loadedClass = null;
        if (thereAreHTClasses) {
            this.addSuperClassesAndInterfacesToTheCache(clazz, className, bundle, htToSci, javaClassCache);
            ClassCacheEntry cce = javaClassCache.get(className);
            if (!cce.scis.isEmpty()) {
                try {
                    LOG.trace("      Loading {}, using {}", (Object)className, (Object)bundle);
                    loadedClass = bundle.loadClass(className);
                }
                catch (Throwable t) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("      Can't load {}, using {}: {}. Skipping.", new Object[]{className, bundle, t.getMessage()});
                    }
                    return;
                }
                if (loadedClass == null) {
                    return;
                }
                for (ServletContainerInitializer sci : cce.scis) {
                    sciToHt.computeIfAbsent(sci, s -> new HashSet()).add(loadedClass);
                }
            }
        }
        if (thereAreHTAnnotations) {
            if (clazz.getAnnotationEntries() == null) {
                return;
            }
            for (AnnotationEntry ae : clazz.getAnnotationEntries()) {
                String annotationClassName = this.className(ae.getAnnotationType());
                if (annotationClassName == null) continue;
                for (Map.Entry<Class<?>, Set<ServletContainerInitializer>> entry : htToSci.entrySet()) {
                    Class<?> c = entry.getKey();
                    if (!c.isAnnotation()) continue;
                    Set<ServletContainerInitializer> scis = entry.getValue();
                    if (!annotationClassName.equals(c.getName())) continue;
                    if (loadedClass == null) {
                        try {
                            LOG.trace("      Loading {} annotated with {}, using {}", new Object[]{className, annotationClassName, bundle});
                            loadedClass = bundle.loadClass(className);
                        }
                        catch (Throwable t) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("      Can't load {} annotated with {}, using {}: {}. Skipping.", new Object[]{className, annotationClassName, bundle, t.getMessage()});
                            }
                            return;
                        }
                        if (loadedClass == null) {
                            return;
                        }
                    }
                    for (ServletContainerInitializer sci : entry.getValue()) {
                        sciToHt.computeIfAbsent(sci, s -> new HashSet()).add(loadedClass);
                    }
                }
            }
        }
    }

    private void checkClass(WebXml fragment, Bundle bundle, Map<Class<?>, Set<ServletContainerInitializer>> htToSci, JavaClass clazz, Map<String, ClassCacheEntry> javaClassCache) {
        AnnotationEntry[] ae = clazz.getAnnotationEntries();
        if (ae == null) {
            return;
        }
        String webElementClassName = clazz.getClassName();
        this.addSuperClassesAndInterfacesToTheCache(clazz, webElementClassName, bundle, htToSci, javaClassCache);
        for (AnnotationEntry ann : ae) {
            switch (this.className(ann.getAnnotationType())) {
                case "javax.servlet.annotation.WebServlet": {
                    LOG.trace("      Processing annotated servlet {}", (Object)webElementClassName);
                    this.processAnnotatedServletClass(webElementClassName, fragment, bundle, ann, clazz, javaClassCache);
                    return;
                }
                case "javax.servlet.annotation.WebFilter": {
                    LOG.trace("      Processing annotated filter {}", (Object)webElementClassName);
                    this.processAnnotatedFilterClass(webElementClassName, fragment, bundle, ann, clazz);
                    return;
                }
                case "javax.servlet.annotation.WebListener": {
                    LOG.trace("      Processing annotated listener {}", (Object)webElementClassName);
                    fragment.addListener(webElementClassName);
                    return;
                }
            }
        }
    }

    private void processAnnotatedServletClass(String className, WebXml fragment, Bundle bundle, AnnotationEntry ann, JavaClass clazz, Map<String, ClassCacheEntry> javaClassCache) {
        AnnotationEntry[] ae;
        boolean extendsHttpServlet = false;
        String sc = clazz.getSuperclassName();
        while (!"java.lang.Object".equals(sc)) {
            if ("javax.servlet.http.HttpServlet".equals(sc)) {
                extendsHttpServlet = true;
                break;
            }
            sc = javaClassCache.get((Object)sc).superClassName;
        }
        if (!extendsHttpServlet) {
            LOG.warn("{} annotated with @WebServlet doesn't extend javax.servlet.http.HttpServlet. See chapter 8.1.1 of the Servlet specification.", (Object)className);
            return;
        }
        String servletName = className;
        String[] urlPatterns = null;
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        String loadOnStartup = null;
        String asyncSupported = null;
        String description = null;
        String displayName = null;
        List pairs = ann.getElementValuePairs();
        for (ElementValuePair evp : pairs) {
            String annKey = evp.getNameString();
            ElementValue elementValue = evp.getValue();
            switch (annKey) {
                case "name": {
                    servletName = elementValue.stringifyValue();
                    break;
                }
                case "value": 
                case "urlPatterns": {
                    if (urlPatterns != null) {
                        LOG.warn("{} has both value and urlPatterns in @WebServlet annotation", (Object)className);
                        break;
                    }
                    urlPatterns = this.extractStrings(className, elementValue);
                    break;
                }
                case "loadOnStartup": {
                    loadOnStartup = elementValue.stringifyValue();
                    break;
                }
                case "initParams": {
                    this.extractInitParams(className, elementValue, initParams);
                    break;
                }
                case "asyncSupported": {
                    asyncSupported = elementValue.stringifyValue();
                    break;
                }
                case "description": {
                    description = elementValue.stringifyValue();
                    break;
                }
                case "displayName": {
                    displayName = elementValue.stringifyValue();
                    break;
                }
            }
        }
        boolean override = false;
        ServletDef servlet = (ServletDef)fragment.getServlets().get(servletName);
        if (servlet != null) {
            override = true;
        } else {
            servlet = new ServletDef();
            servlet.setServletName(servletName);
            servlet.setServletClass(className);
        }
        if (servlet.getAsyncSupported() == null) {
            servlet.setAsyncSupported(asyncSupported);
        }
        if (servlet.getLoadOnStartup() == null && loadOnStartup != null) {
            servlet.setLoadOnStartup(loadOnStartup);
        }
        if (servlet.getDescription() == null) {
            servlet.setDescription(description);
        }
        if (servlet.getDisplayName() == null) {
            servlet.setDisplayName(displayName);
        }
        if (override) {
            Map existingInitParams = servlet.getParameterMap();
            for (Map.Entry entry : initParams.entrySet()) {
                String key = (String)entry.getKey();
                if (existingInitParams.containsKey(key)) continue;
                servlet.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            for (Map.Entry entry : initParams.entrySet()) {
                servlet.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        AnnotationEntry[] annotationEntryArray = ae = clazz.getAnnotationEntries();
        int n = annotationEntryArray.length;
        for (int i = 0; i < n; ++i) {
            AnnotationEntry annotationEntry = annotationEntryArray[i];
            if (!MultipartConfig.class.getName().equals(this.className(annotationEntry.getAnnotationType()))) continue;
            MultipartDef multipartDef = new MultipartDef();
            servlet.setMultipartDef(multipartDef);
            multipartDef.setFileSizeThreshold("0");
            multipartDef.setMaxFileSize("-1");
            multipartDef.setMaxRequestSize("-1");
            for (ElementValuePair evp : annotationEntry.getElementValuePairs()) {
                String annKey = evp.getNameString();
                ElementValue annValue = evp.getValue();
                switch (annKey) {
                    case "location": {
                        multipartDef.setLocation(annValue.stringifyValue());
                        break;
                    }
                    case "fileSizeThreshold": {
                        multipartDef.setFileSizeThreshold(annValue.stringifyValue());
                        break;
                    }
                    case "maxFileSize": {
                        multipartDef.setMaxFileSize(annValue.stringifyValue());
                        break;
                    }
                    case "maxRequestSize": {
                        multipartDef.setMaxRequestSize(annValue.stringifyValue());
                        break;
                    }
                }
            }
            break;
        }
        if (!override) {
            fragment.addServlet(servlet);
        }
        if (!fragment.getServletMappings().containsValue(servletName) && urlPatterns != null) {
            for (String string : urlPatterns) {
                fragment.addServletMapping(string, servletName);
            }
        }
    }

    private void processAnnotatedFilterClass(String className, WebXml fragment, Bundle bundle, AnnotationEntry ann, JavaClass clazz) {
        boolean hasFilter = false;
        for (String name : clazz.getInterfaceNames()) {
            if (!"javax.servlet.Filter".equals(name)) continue;
            hasFilter = true;
            break;
        }
        if (!hasFilter) {
            LOG.warn("{} annotated with @WebFilter doesn't implement javax.servlet.Filter. See chapter 8.1.2 of the Servlet specification.", (Object)className);
            return;
        }
        String filterName = className;
        String[] urlPatterns = null;
        String[] servletNames = null;
        String[] dispatcherTypes = null;
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        String asyncSupported = null;
        String description = null;
        String displayName = null;
        List pairs = ann.getElementValuePairs();
        for (ElementValuePair evp : pairs) {
            String annKey = evp.getNameString();
            ElementValue elementValue = evp.getValue();
            switch (annKey) {
                case "filterName": {
                    filterName = elementValue.stringifyValue();
                    break;
                }
                case "value": 
                case "urlPatterns": {
                    if (urlPatterns != null) {
                        LOG.warn("{} has both value and urlPatterns in @WebFilter annotation", (Object)className);
                        break;
                    }
                    urlPatterns = this.extractStrings(className, elementValue);
                    break;
                }
                case "initParams": {
                    this.extractInitParams(className, elementValue, initParams);
                    break;
                }
                case "asyncSupported": {
                    asyncSupported = elementValue.stringifyValue();
                    break;
                }
                case "description": {
                    description = elementValue.stringifyValue();
                    break;
                }
                case "displayName": {
                    displayName = elementValue.stringifyValue();
                    break;
                }
                case "servletNames": {
                    if (!(elementValue instanceof ArrayElementValue) && !(elementValue instanceof SimpleElementValue)) {
                        LOG.warn("{} has wrong servletNames annotation. Not an array/string.", (Object)className);
                        break;
                    }
                    servletNames = this.extractStrings(className, elementValue);
                    break;
                }
                case "dispatcherTypes": {
                    if (!(elementValue instanceof ArrayElementValue) && !(elementValue instanceof EnumElementValue)) {
                        LOG.warn("{} has wrong dispatcherTypes annotation. Not an array/enum.", (Object)className);
                        break;
                    }
                    dispatcherTypes = this.extractStrings(className, elementValue);
                    break;
                }
            }
        }
        boolean override = false;
        FilterDef filter = (FilterDef)fragment.getFilters().get(filterName);
        if (filter != null) {
            override = true;
        } else {
            filter = new FilterDef();
            filter.setFilterName(filterName);
            filter.setFilterClass(className);
        }
        if (filter.getAsyncSupported() == null) {
            filter.setAsyncSupported(asyncSupported);
        }
        if (filter.getDescription() == null) {
            filter.setDescription(description);
        }
        if (filter.getDisplayName() == null) {
            filter.setDisplayName(displayName);
        }
        if (override) {
            Map existingInitParams = filter.getParameterMap();
            for (Map.Entry entry : initParams.entrySet()) {
                String key = (String)entry.getKey();
                if (existingInitParams.containsKey(key)) continue;
                filter.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            for (Map.Entry entry : initParams.entrySet()) {
                filter.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!override) {
            FilterMap filterMap = new FilterMap();
            fragment.addFilter(filter);
            filterMap.setFilterName(filterName);
            if (urlPatterns != null) {
                for (String up : urlPatterns) {
                    filterMap.addURLPattern(up);
                }
            }
            if (servletNames != null) {
                for (String sn : servletNames) {
                    filterMap.addServletName(sn);
                }
            }
            if (dispatcherTypes != null) {
                for (String dt : dispatcherTypes) {
                    filterMap.setDispatcher(dt);
                }
            }
            fragment.addFilterMapping(filterMap);
        } else {
            FilterMap existingMapping = null;
            for (FilterMap filterMap : fragment.getFilterMappings()) {
                if (!filterName.equals(filterMap.getFilterName())) continue;
                existingMapping = filterMap;
                break;
            }
            if (existingMapping != null) {
                String[] stringArray = existingMapping.getServletNames();
                String[] stringArray2 = existingMapping.getURLPatterns();
                String[] existingDispatcherNames = existingMapping.getDispatcherNames();
                if ((stringArray == null || stringArray.length == 0) && servletNames != null) {
                    for (String sn : servletNames) {
                        existingMapping.addServletName(sn);
                    }
                }
                if ((stringArray2 == null || stringArray2.length == 0) && urlPatterns != null) {
                    for (String up : urlPatterns) {
                        existingMapping.addURLPattern(up);
                    }
                }
                if ((existingDispatcherNames == null || existingDispatcherNames.length == 0) && dispatcherTypes != null) {
                    for (String dt : dispatcherTypes) {
                        existingMapping.setDispatcher(dt);
                    }
                }
            }
        }
    }

    private String[] extractStrings(String className, ElementValue annValue) {
        String[] result = null;
        if (!(annValue instanceof ArrayElementValue) && !(annValue instanceof SimpleElementValue)) {
            LOG.warn("{} has wrong urlPatterns annotation. Not an array/string.", (Object)className);
        } else if (annValue instanceof ArrayElementValue) {
            ArrayElementValue aev = (ArrayElementValue)annValue;
            ElementValue[] arr = aev.getElementValuesArray();
            result = new String[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                ElementValue v = arr[i];
                result[i] = v.stringifyValue();
            }
        } else {
            result = new String[]{annValue.stringifyValue()};
        }
        return result;
    }

    private void extractInitParams(String className, ElementValue annValue, Map<String, String> initParams) {
        if (!(annValue instanceof ArrayElementValue) && !(annValue instanceof AnnotationElementValue)) {
            LOG.warn("{} has wrong initParams annotation. Not an array or @WebInitParam.", (Object)className);
        } else if (annValue instanceof ArrayElementValue) {
            ArrayElementValue aev = (ArrayElementValue)annValue;
            for (ElementValue ev : aev.getElementValuesArray()) {
                if (!(ev instanceof AnnotationElementValue)) continue;
                this.extractInitParam((AnnotationElementValue)ev, initParams);
            }
        } else {
            this.extractInitParam((AnnotationElementValue)annValue, initParams);
        }
    }

    private void extractInitParam(AnnotationElementValue aev, Map<String, String> initParams) {
        if (aev.getAnnotationEntry() != null) {
            String name = null;
            String value = null;
            for (ElementValuePair evp : aev.getAnnotationEntry().getElementValuePairs()) {
                String ak = evp.getNameString();
                ElementValue av = evp.getValue();
                switch (ak) {
                    case "name": {
                        name = av.stringifyValue();
                        break;
                    }
                    case "value": {
                        value = av.stringifyValue();
                        break;
                    }
                }
            }
            if (name != null && value != null) {
                initParams.put(name, value);
            }
        }
    }

    private ClassCacheEntry addSuperClassesAndInterfacesToTheCache(JavaClass clazz, String className, Bundle bundle, Map<Class<?>, Set<ServletContainerInitializer>> htToSci, Map<String, ClassCacheEntry> javaClassCache) {
        ClassCacheEntry cce = javaClassCache.get(className);
        if (cce != null) {
            return cce;
        }
        cce = new ClassCacheEntry();
        cce.superClassName = clazz.getSuperclassName();
        cce.interfaceNames = clazz.getInterfaceNames();
        javaClassCache.put(className, cce);
        this.addToCache(cce.superClassName, bundle, htToSci, javaClassCache);
        for (String name : cce.interfaceNames) {
            this.addToCache(name, bundle, htToSci, javaClassCache);
        }
        this.configureRelevantSCIs(cce, htToSci, javaClassCache);
        return cce;
    }

    private void addToCache(String className, Bundle bundle, Map<Class<?>, Set<ServletContainerInitializer>> htToSci, Map<String, ClassCacheEntry> javaClassCache) {
        if (javaClassCache.containsKey(className)) {
            return;
        }
        String resName = className.replace('.', '/') + ".class";
        URL url = this.wabClassLoader.getResource(resName);
        if (url == null) {
            return;
        }
        try (InputStream is = url.openStream();){
            ClassParser parser = new ClassParser(is);
            JavaClass clazz = parser.parse();
            this.addSuperClassesAndInterfacesToTheCache(clazz, className, bundle, htToSci, javaClassCache);
        }
        catch (Exception e) {
            LOG.warn("Can't get class resource {}: {}", new Object[]{url, e.getMessage(), e});
        }
    }

    private void configureRelevantSCIs(ClassCacheEntry cce, Map<Class<?>, Set<ServletContainerInitializer>> htToSci, Map<String, ClassCacheEntry> javaClassCache) {
        HashSet<ServletContainerInitializer> result = new HashSet<ServletContainerInitializer>();
        ClassCacheEntry sce = javaClassCache.get(cce.superClassName);
        if (sce != null) {
            if (sce.scis == null) {
                this.configureRelevantSCIs(sce, htToSci, javaClassCache);
            }
            result.addAll(sce.scis);
            result.addAll(this.findRelevantSCIs(cce.superClassName, htToSci));
        }
        for (String name : cce.interfaceNames) {
            ClassCacheEntry ie = javaClassCache.get(name);
            if (ie == null) continue;
            if (ie.scis == null) {
                this.configureRelevantSCIs(ie, htToSci, javaClassCache);
            }
            result.addAll(ie.scis);
            result.addAll(this.findRelevantSCIs(name, htToSci));
        }
        cce.scis = result;
    }

    private Collection<? extends ServletContainerInitializer> findRelevantSCIs(String name, Map<Class<?>, Set<ServletContainerInitializer>> htToSci) {
        for (Class<?> clazz : htToSci.keySet()) {
            if (!name.equals(clazz.getName())) continue;
            return htToSci.get(clazz);
        }
        return NO_SCIS;
    }

    private String className(String annotationBcelType) {
        if (annotationBcelType != null && annotationBcelType.startsWith("L") && annotationBcelType.endsWith(";")) {
            return annotationBcelType.substring(1, annotationBcelType.length() - 1).replace('/', '.');
        }
        return null;
    }

    private static final class ClassCacheEntry {
        String superClassName;
        String[] interfaceNames;
        Set<ServletContainerInitializer> scis;

        private ClassCacheEntry() {
        }
    }
}

