/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.legacy.support;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyInitialContextFinder
implements InitialContextFactoryBuilder {
    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
        String icf = (String)environment.get("java.naming.factory.initial");
        if (icf != null) {
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            try {
                Class<?> icfClass = Class.forName(icf, false, cl);
                if (InitialContextFactory.class.isAssignableFrom(icfClass)) {
                    return (InitialContextFactory)icfClass.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return null;
    }
}

