/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ReplicationJobStopAction;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class ReplicationJobStopActions
implements Iterable<ReplicationJobStopAction>,
OpenSearchPluginDTO {
    private final List<ReplicationJobStopAction> actions = new ArrayList<ReplicationJobStopAction>();
    private String transactionId;

    private ReplicationJobStopActions() {
        this.transactionId = null;
    }

    public ReplicationJobStopActions(String transactionId) {
        this.transactionId = transactionId;
    }

    public ReplicationJobStopActions(Map<String, Object> replicationJobActionsMap) {
        this();
        this.checkForWellKnownKeys(replicationJobActionsMap);
        this.actions.addAll(MapUtil.getArrayValueAsListOfObjects(replicationJobActionsMap, (String)"entries", ReplicationJobStopAction.class));
        this.transactionId = MapUtil.getValueAsString(replicationJobActionsMap, (String)"transactionId", null);
    }

    private void checkForWellKnownKeys(Map<String, Object> map) {
        MapUtil.checkForWellKnownKeys(map, Set.of("entries", "transactionId"));
    }

    public ReplicationJobStopActions(StreamInput in) throws IOException {
        this();
        this.actions.addAll(in.readList(ReplicationJobStopAction::new));
        this.transactionId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.actions);
        out.writeOptionalString(this.transactionId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("entries");
        for (ReplicationJobStopAction action : this.actions) {
            action.toXContent(builder, params);
        }
        builder.endArray();
        builder.field("transactionId", this.transactionId);
        builder.endObject();
        return builder;
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public int size() {
        return this.actions.size();
    }

    public int getNumberOfAffectedServers() {
        return this.getAffectedServersUUIDs().size();
    }

    public Set<String> getAffectedServersUUIDs() {
        HashSet<String> serverUUIDs = new HashSet<String>();
        for (ReplicationJobStopAction action : this.actions) {
            serverUUIDs.add(action.getServerUUID());
        }
        return serverUUIDs;
    }

    public void add(ReplicationJobStopAction action) {
        if (action != null && !this.existsForReplicationJobId(action.getReplicationJobId())) {
            this.actions.add(action);
        }
    }

    public void addAll(List<ReplicationJobStopAction> actions) {
        if (actions != null) {
            for (ReplicationJobStopAction action : actions) {
                this.add(action);
            }
        }
    }

    public boolean existsForReplicationJobId(String replicationJobId) {
        return this.getByReplicationJobId(replicationJobId) != null;
    }

    public ReplicationJobStopAction getByReplicationJobId(String replicationJobId) {
        if (!StringUtil.isNullOrEmpty((String)replicationJobId)) {
            for (ReplicationJobStopAction action : this.actions) {
                if (!replicationJobId.equals(action.getReplicationJobId())) continue;
                return action;
            }
        }
        return null;
    }

    public List<ReplicationJobStopAction> getByServerUUID(String serverUUID) {
        ArrayList<ReplicationJobStopAction> result = new ArrayList<ReplicationJobStopAction>();
        if (!StringUtil.isNullOrEmpty((String)serverUUID)) {
            for (ReplicationJobStopAction action : this.actions) {
                if (!serverUUID.equals(action.getServerUUID())) continue;
                result.add(action);
            }
        }
        return result;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public Iterator<ReplicationJobStopAction> iterator() {
        return this.actions.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobStopActions that = (ReplicationJobStopActions)o;
        return Objects.equals(this.actions, that.actions) && Objects.equals(this.transactionId, that.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.transactionId);
    }

    public String toString() {
        return "ReplicationJobStopActions{actions=" + String.valueOf(this.actions) + ", transactionId='" + this.transactionId + "'}";
    }
}

