/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ReplicationJob;
import de.virtimo.bpc.opensearch.plugin.ReplicationJobs;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;

class ReplicationJobsPerServerDistributor {
    private static final Logger LOGGER = Loggers.getLogger(ReplicationJobsPerServerDistributor.class, (String[])new String[]{"os-bpc-plugin"});
    private final Map<String, Integer> numberOfJobsPerServer = new HashMap<String, Integer>();

    public ReplicationJobsPerServerDistributor(Set<String> serverUUIDs, ReplicationJobs currentReplicationJobs) {
        if (serverUUIDs != null && currentReplicationJobs != null) {
            for (String serverUUID : serverUUIDs) {
                Set<ReplicationJob> replicationJobsByServerUUID = currentReplicationJobs.getReplicationJobsByServerUUID(serverUUID);
                this.numberOfJobsPerServer.put(serverUUID, replicationJobsByServerUUID.size());
            }
        }
    }

    public int getNumberOfJobsOnServer(String serverUUID) {
        if (serverUUID == null || !this.numberOfJobsPerServer.containsKey(serverUUID)) {
            return 0;
        }
        return this.numberOfJobsPerServer.get(serverUUID);
    }

    public String getNextServerUuidWithFewestNumberOfJobs() {
        LOGGER.debug("getNextServerUuidWithFewestNumberOfJobs");
        String serverUuidWithFewestNumberOfJobs = this.getServerUuidWithFewestNumberOfJobs(this.numberOfJobsPerServer);
        if (serverUuidWithFewestNumberOfJobs != null) {
            this.numberOfJobsPerServer.put(serverUuidWithFewestNumberOfJobs, this.numberOfJobsPerServer.get(serverUuidWithFewestNumberOfJobs) + 1);
        }
        return serverUuidWithFewestNumberOfJobs;
    }

    private String getServerUuidWithFewestNumberOfJobs(Map<String, Integer> numberOfJobsPerServerUUID) {
        LOGGER.debug("getServerUuidWithFewestNumberOfJobs numberOfJobsPerServerUUID={}", numberOfJobsPerServerUUID);
        String serverUuidwithLowestValue = null;
        Integer lowestValue = Integer.MAX_VALUE;
        for (String serverUUID : numberOfJobsPerServerUUID.keySet()) {
            Integer numberOfJobs = numberOfJobsPerServerUUID.get(serverUUID);
            if (numberOfJobs >= lowestValue) continue;
            serverUuidwithLowestValue = serverUUID;
            lowestValue = numberOfJobs;
        }
        return serverUuidwithLowestValue;
    }
}

