/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ConfigDTO
implements OpenSearchPluginDTO {
    private final Plugin plugin;
    private final Websocket websocket;

    public ConfigDTO(int websocketPort, String pluginName, String pluginVersion) {
        this.websocket = new Websocket(websocketPort);
        this.plugin = new Plugin(pluginName, pluginVersion);
    }

    public ConfigDTO(Map<String, Object> configMap) {
        this.checkForWellKnownKeys(configMap);
        this.websocket = new Websocket((Map)configMap.get("websocket"));
        this.plugin = new Plugin((Map)configMap.get("plugin"));
    }

    private void checkForWellKnownKeys(Map<String, Object> configMap) {
        MapUtil.checkForWellKnownKeys(configMap, Set.of("websocket", "plugin"));
    }

    public ConfigDTO(StreamInput in) throws IOException {
        this.plugin = (Plugin)in.readOptionalWriteable(Plugin::new);
        this.websocket = (Websocket)in.readOptionalWriteable(Websocket::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.plugin);
        out.writeOptionalWriteable((Writeable)this.websocket);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("websocket");
        this.websocket.toXContent(builder, params);
        builder.endObject();
        builder.startObject("plugin");
        this.plugin.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public ConfigDTO fromXContent(XContentParser parser) throws IOException {
        return new ConfigDTO(parser.map());
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Websocket getWebsocket() {
        return this.websocket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigDTO configDTO = (ConfigDTO)o;
        return Objects.equals(this.plugin, configDTO.plugin) && Objects.equals(this.websocket, configDTO.websocket);
    }

    public int hashCode() {
        return Objects.hash(this.plugin, this.websocket);
    }

    public String toString() {
        return "ConfigDTO{plugin=" + String.valueOf(this.plugin) + ", websocket=" + String.valueOf(this.websocket) + "}";
    }

    public static class Websocket
    implements OpenSearchPluginDTO {
        private final Integer port;

        public Websocket(Integer port) {
            this.port = port;
        }

        public Websocket(Map<String, Object> websocketMap) {
            this.port = MapUtil.getValueAsInt(websocketMap, (String)"port", (int)9201);
        }

        public Websocket(StreamInput in) throws IOException {
            this.port = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.port.intValue());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("port", this.port);
            return builder;
        }

        public Integer getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Websocket websocket = (Websocket)o;
            return Objects.equals(this.port, websocket.port);
        }

        public int hashCode() {
            return Objects.hash(this.port);
        }

        public String toString() {
            return "Websocket{port=" + this.port + "}";
        }
    }

    public static class Plugin
    implements OpenSearchPluginDTO {
        private final String name;
        private final String version;

        public Plugin(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public Plugin(Map<String, Object> pluginMap) {
            this.name = MapUtil.getValueAsString(pluginMap, (String)"name", null);
            this.version = MapUtil.getValueAsString(pluginMap, (String)"version", null);
        }

        public Plugin(StreamInput in) throws IOException {
            this.name = in.readString();
            this.version = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeString(this.version);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("name", this.name);
            builder.field("version", this.version);
            return builder;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plugin plugin = (Plugin)o;
            return Objects.equals(this.name, plugin.name) && Objects.equals(this.version, plugin.version);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version);
        }

        public String toString() {
            return "Plugin{name='" + this.name + "', version='" + this.version + "'}";
        }
    }
}

