/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterBinaryDocValues;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FilterSortedDocValues;
import org.apache.lucene.index.FilterSortedSetDocValues;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOBooleanSupplier;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.opensearch.ExceptionsHelper;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.compliance.ComplianceConfig;
import org.opensearch.security.compliance.FieldReadCallback;
import org.opensearch.security.privileges.dlsfls.FieldMasking;
import org.opensearch.security.privileges.dlsfls.FieldPrivileges;
import org.opensearch.security.privileges.dlsfls.FlsStoredFieldVisitor;

class DlsFlsFilterLeafReader
extends SequentialStoredFieldsLeafReader {
    private final FieldInfos flsFieldInfos;
    private final IndexService indexService;
    private final ThreadContext threadContext;
    private final ClusterService clusterService;
    private final AuditLog auditlog;
    private final ShardId shardId;
    private final FieldPrivileges.FlsRule flsRule;
    private final FieldMasking.FieldMaskingRule fmRule;
    private final Set<String> metaFields;
    private DlsGetEvaluator dge = null;

    DlsFlsFilterLeafReader(LeafReader delegate, FieldPrivileges.FlsRule flsRule, Query dlsQuery, IndexService indexService, ThreadContext threadContext, ClusterService clusterService, AuditLog auditlog, FieldMasking.FieldMaskingRule fmRule, ShardId shardId, Set<String> metaFields) {
        super(delegate);
        this.indexService = indexService;
        this.threadContext = threadContext;
        this.clusterService = clusterService;
        this.auditlog = auditlog;
        this.shardId = shardId;
        this.flsRule = flsRule;
        this.fmRule = fmRule;
        this.metaFields = metaFields;
        try {
            if (!flsRule.isAllowAll()) {
                FieldInfos originalFieldInfos = delegate.getFieldInfos();
                ArrayList<FieldInfo> restrictedFieldInfos = new ArrayList<FieldInfo>(originalFieldInfos.size());
                for (FieldInfo fieldInfo : originalFieldInfos) {
                    if (!metaFields.contains(fieldInfo.name) && !flsRule.isAllowedRecursive(fieldInfo.name)) continue;
                    restrictedFieldInfos.add(fieldInfo);
                }
                this.flsFieldInfos = new FieldInfos(restrictedFieldInfos.toArray(new FieldInfo[restrictedFieldInfos.size()]));
            } else {
                this.flsFieldInfos = delegate.getFieldInfos();
            }
            this.dge = new DlsGetEvaluator(this, dlsQuery, this.in, dlsQuery != null && this.applyDlsHere());
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
        return new DlsFlsStoredFieldsReader(reader);
    }

    private StoredFieldVisitor getDlsFlsVisitor(StoredFieldVisitor visitor) {
        ComplianceConfig complianceConfig = this.auditlog.getComplianceConfig();
        if (complianceConfig != null && complianceConfig.readHistoryEnabledForIndex(this.indexService.index().getName())) {
            visitor = new ComplianceAwareStoredFieldVisitor(visitor);
        }
        if (!this.flsRule.isAllowAll() || !this.fmRule.isAllowAll()) {
            visitor = new FlsStoredFieldVisitor(visitor, this.flsRule, this.fmRule, this.metaFields);
        }
        return visitor;
    }

    private void finishVisitor(StoredFieldVisitor visitor) {
        if (visitor instanceof FlsStoredFieldVisitor) {
            visitor = ((FlsStoredFieldVisitor)visitor).delegate();
        }
        if (visitor instanceof ComplianceAwareStoredFieldVisitor) {
            ((ComplianceAwareStoredFieldVisitor)visitor).finished();
        }
    }

    private boolean isAllowed(String fieldName) {
        return this.metaFields.contains(fieldName) || this.flsRule.isAllowedRecursive(fieldName) && !this.fmRule.isMasked(fieldName);
    }

    private boolean isAllowedButPossiblyMasked(String fieldName) {
        return this.metaFields.contains(fieldName) || this.flsRule.isAllowedRecursive(fieldName);
    }

    public FieldInfos getFieldInfos() {
        if (this.flsRule.isAllowAll()) {
            return this.in.getFieldInfos();
        }
        return this.flsFieldInfos;
    }

    public TermVectors termVectors() throws IOException {
        return new TermVectors(){

            public void prefetch(int docID) throws IOException {
                DlsFlsFilterLeafReader.this.in.termVectors().prefetch(docID);
            }

            public Fields get(int docID) throws IOException {
                final Fields fields = DlsFlsFilterLeafReader.this.in.termVectors().get(docID);
                if (DlsFlsFilterLeafReader.this.flsRule.isAllowAll() || fields == null) {
                    return fields;
                }
                return new Fields(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Iterator<String> iterator() {
                        return Iterators.filter((Iterator)fields.iterator(), input -> this.this$1.DlsFlsFilterLeafReader.this.isAllowedButPossiblyMasked((String)input));
                    }

                    public Terms terms(String field) throws IOException {
                        if ("_field_names".equals(field)) {
                            return this.this$1.DlsFlsFilterLeafReader.this.filteredFieldNameTerms(fields.terms(field));
                        }
                        return this.this$1.DlsFlsFilterLeafReader.this.isAllowed(field) ? fields.terms(field) : null;
                    }

                    public int size() {
                        return this.this$1.DlsFlsFilterLeafReader.this.flsFieldInfos.size();
                    }
                };
            }
        };
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return this.isAllowed(field) ? this.in.getNumericDocValues(field) : null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        if (this.metaFields.contains(field)) {
            return this.in.getBinaryDocValues(field);
        }
        if (!this.flsRule.isAllowedRecursive(field)) {
            return null;
        }
        final BinaryDocValues originalBinaryDocValues = this.in.getBinaryDocValues(field);
        if (originalBinaryDocValues == null) {
            return null;
        }
        final FieldMasking.FieldMaskingRule.Field fmRuleField = this.fmRule.get(field);
        if (fmRuleField != null) {
            return new FilterBinaryDocValues(this, originalBinaryDocValues){

                public BytesRef binaryValue() throws IOException {
                    return fmRuleField.apply(originalBinaryDocValues.binaryValue());
                }
            };
        }
        return originalBinaryDocValues;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        if (this.metaFields.contains(field)) {
            return this.in.getSortedDocValues(field);
        }
        if (!this.flsRule.isAllowedRecursive(field)) {
            return null;
        }
        final SortedDocValues originalDocValues = this.in.getSortedDocValues(field);
        if (originalDocValues == null) {
            return null;
        }
        final FieldMasking.FieldMaskingRule.Field fmRuleField = this.fmRule.get(field);
        if (fmRuleField != null) {
            return new FilterSortedDocValues(this, originalDocValues){

                public TermsEnum termsEnum() throws IOException {
                    return new MaskedTermsEnum(originalDocValues.termsEnum(), fmRuleField);
                }

                public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
                    return new MaskedTermsEnum(originalDocValues.intersect(automaton), fmRuleField);
                }

                public BytesRef lookupOrd(int ord) throws IOException {
                    return fmRuleField.apply(originalDocValues.lookupOrd(ord));
                }

                public int getValueCount() {
                    return originalDocValues.getValueCount();
                }
            };
        }
        return originalDocValues;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return this.isAllowed(field) ? this.in.getSortedNumericDocValues(field) : null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        if (this.metaFields.contains(field)) {
            return this.in.getSortedSetDocValues(field);
        }
        if (!this.flsRule.isAllowedRecursive(field)) {
            return null;
        }
        final SortedSetDocValues originalDocValues = this.in.getSortedSetDocValues(field);
        if (originalDocValues == null) {
            return null;
        }
        final FieldMasking.FieldMaskingRule.Field fmRuleField = this.fmRule.get(field);
        if (fmRuleField != null) {
            return new FilterSortedSetDocValues(this, originalDocValues){

                public TermsEnum termsEnum() throws IOException {
                    return new MaskedTermsEnum(originalDocValues.termsEnum(), fmRuleField);
                }

                public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
                    return new MaskedTermsEnum(originalDocValues.intersect(automaton), fmRuleField);
                }

                public BytesRef lookupOrd(long ord) throws IOException {
                    return fmRuleField.apply(originalDocValues.lookupOrd(ord));
                }
            };
        }
        return originalDocValues;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return this.isAllowed(field) ? this.in.getNormValues(field) : null;
    }

    public PointValues getPointValues(String field) throws IOException {
        return this.isAllowed(field) ? this.in.getPointValues(field) : null;
    }

    public Terms terms(String field) throws IOException {
        if ("_field_names".equals(field)) {
            return this.filteredFieldNameTerms(this.in.terms(field));
        }
        return this.isAllowed(field) ? this.in.terms(field) : null;
    }

    private Terms filteredFieldNameTerms(Terms originalTerms) throws IOException {
        if (originalTerms == null) {
            return null;
        }
        return new FilterLeafReader.FilterTerms(originalTerms){

            public TermsEnum iterator() throws IOException {
                return new FilterLeafReader.FilterTermsEnum(this.in.iterator()){

                    public BytesRef next() throws IOException {
                        BytesRef nextBytesRef = this.in.next();
                        while (nextBytesRef != null) {
                            if (this.isAllowedButPossiblyMasked(nextBytesRef)) {
                                return nextBytesRef;
                            }
                            nextBytesRef = this.in.next();
                        }
                        return null;
                    }

                    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                        TermsEnum.SeekStatus delegateStatus = this.in.seekCeil(text);
                        if (delegateStatus != TermsEnum.SeekStatus.END && this.isAllowedButPossiblyMasked(this.in.term())) {
                            return delegateStatus;
                        }
                        if (delegateStatus == TermsEnum.SeekStatus.END) {
                            return TermsEnum.SeekStatus.END;
                        }
                        if (this.next() != null) {
                            return TermsEnum.SeekStatus.NOT_FOUND;
                        }
                        return TermsEnum.SeekStatus.END;
                    }

                    public boolean seekExact(BytesRef term) throws IOException {
                        return this.isAllowedButPossiblyMasked(term) && this.in.seekExact(term);
                    }

                    public void seekExact(long ord) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public long ord() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public IOBooleanSupplier prepareSeekExact(BytesRef text) throws IOException {
                        return this.isAllowedButPossiblyMasked(text) ? this.in.prepareSeekExact(text) : () -> false;
                    }

                    private boolean isAllowedButPossiblyMasked(BytesRef term) {
                        return DlsFlsFilterLeafReader.this.isAllowedButPossiblyMasked(term.utf8ToString());
                    }
                };
            }
        };
    }

    public Bits getLiveDocs() {
        return this.dge.getLiveDocs();
    }

    public int numDocs() {
        return this.dge.numDocs();
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.dge.getReaderCacheHelper();
    }

    public boolean hasDeletions() {
        return this.dge.hasDeletions();
    }

    public StoredFields storedFields() throws IOException {
        this.ensureOpen();
        return new DlsFlsStoredFields(this.in.storedFields());
    }

    private String getRuntimeActionName() {
        return (String)this.threadContext.getTransient("_opendistro_security_action_name");
    }

    private boolean isSuggest() {
        return this.threadContext.getTransient("_opendistro_security_issuggest") == Boolean.TRUE;
    }

    private boolean isParentChildQuery() {
        return this.threadContext.getTransient("_opendistro_security_is_parent_child_query") == Boolean.TRUE;
    }

    private boolean applyDlsHere() {
        if (this.isSuggest() || this.isParentChildQuery()) {
            return true;
        }
        String action = this.getRuntimeActionName();
        assert (action != null);
        return !action.startsWith("indices:data/read/search");
    }

    private class DlsGetEvaluator {
        private final Bits liveBits;
        private final int numDocs;
        private final IndexReader.CacheHelper readerCacheHelper;
        private final boolean hasDeletions;

        public DlsGetEvaluator(DlsFlsFilterLeafReader dlsFlsFilterLeafReader, Query dlsQuery, LeafReader in, boolean applyDlsHere) throws IOException {
            if (dlsQuery != null && applyDlsHere) {
                IndexSearcher searcher = new IndexSearcher((IndexReader)dlsFlsFilterLeafReader);
                searcher.setQueryCache(null);
                Weight preserveWeight = searcher.rewrite(dlsQuery).createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                int maxDoc = in.maxDoc();
                FixedBitSet bits = new FixedBitSet(maxDoc);
                Scorer preserveScorer = preserveWeight.scorer(dlsFlsFilterLeafReader.getContext());
                if (preserveScorer != null) {
                    bits.or(preserveScorer.iterator());
                }
                if (in.hasDeletions()) {
                    Bits oldLiveDocs = in.getLiveDocs();
                    assert (oldLiveDocs != null);
                    BitSetIterator it = new BitSetIterator((BitSet)bits, 0L);
                    int i = it.nextDoc();
                    while (i != Integer.MAX_VALUE) {
                        if (!oldLiveDocs.get(i)) {
                            bits.clear(i);
                        }
                        i = it.nextDoc();
                    }
                }
                this.liveBits = bits;
                this.numDocs = in.numDocs();
                this.readerCacheHelper = null;
                this.hasDeletions = true;
            } else {
                this.liveBits = in.getLiveDocs();
                this.numDocs = in.numDocs();
                this.readerCacheHelper = in.getReaderCacheHelper();
                this.hasDeletions = in.hasDeletions();
            }
        }

        public Bits getLiveDocs() {
            return this.liveBits;
        }

        public int numDocs() {
            return this.numDocs;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.readerCacheHelper;
        }

        public boolean hasDeletions() {
            return this.hasDeletions;
        }
    }

    private class DlsFlsStoredFieldsReader
    extends StoredFieldsReader {
        private final StoredFieldsReader in;

        public DlsFlsStoredFieldsReader(StoredFieldsReader storedFieldsReader) {
            this.in = storedFieldsReader;
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            visitor = DlsFlsFilterLeafReader.this.getDlsFlsVisitor(visitor);
            try {
                this.in.document(docID, visitor);
            }
            finally {
                DlsFlsFilterLeafReader.this.finishVisitor(visitor);
            }
        }

        public StoredFieldsReader clone() {
            return new DlsFlsStoredFieldsReader(this.in.clone());
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private class ComplianceAwareStoredFieldVisitor
    extends StoredFieldVisitor {
        private final StoredFieldVisitor delegate;
        private FieldReadCallback fieldReadCallback;

        public ComplianceAwareStoredFieldVisitor(StoredFieldVisitor delegate) {
            this.fieldReadCallback = new FieldReadCallback(DlsFlsFilterLeafReader.this.threadContext, DlsFlsFilterLeafReader.this.indexService, DlsFlsFilterLeafReader.this.clusterService, DlsFlsFilterLeafReader.this.auditlog, DlsFlsFilterLeafReader.this.fmRule, DlsFlsFilterLeafReader.this.shardId);
            this.delegate = delegate;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.fieldReadCallback.binaryFieldRead(fieldInfo, value);
            this.delegate.binaryField(fieldInfo, value);
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.delegate.needsField(fieldInfo);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.fieldReadCallback.numericFieldRead(fieldInfo, value);
            this.delegate.intField(fieldInfo, value);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.fieldReadCallback.numericFieldRead(fieldInfo, value);
            this.delegate.longField(fieldInfo, value);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.fieldReadCallback.numericFieldRead(fieldInfo, Float.valueOf(value));
            this.delegate.floatField(fieldInfo, value);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.fieldReadCallback.numericFieldRead(fieldInfo, value);
            this.delegate.doubleField(fieldInfo, value);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void finished() {
            this.fieldReadCallback.finished();
            this.fieldReadCallback = null;
        }
    }

    private class DlsFlsStoredFields
    extends StoredFields {
        private final StoredFields in;

        public DlsFlsStoredFields(StoredFields storedFields) {
            this.in = storedFields;
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            visitor = DlsFlsFilterLeafReader.this.getDlsFlsVisitor(visitor);
            try {
                this.in.document(docID, visitor);
            }
            finally {
                DlsFlsFilterLeafReader.this.finishVisitor(visitor);
            }
        }
    }

    private static class MaskedTermsEnum
    extends TermsEnum {
        private final TermsEnum delegate;
        private final FieldMasking.FieldMaskingRule.Field fmRuleField;

        public MaskedTermsEnum(TermsEnum delegate, FieldMasking.FieldMaskingRule.Field fmRuleField) {
            this.delegate = delegate;
            this.fmRuleField = fmRuleField;
        }

        public BytesRef next() throws IOException {
            return this.delegate.next();
        }

        public AttributeSource attributes() {
            return this.delegate.attributes();
        }

        public boolean seekExact(BytesRef text) throws IOException {
            return this.delegate.seekExact(text);
        }

        public IOBooleanSupplier prepareSeekExact(BytesRef bytesRef) throws IOException {
            return this.delegate.prepareSeekExact(bytesRef);
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.delegate.seekCeil(text);
        }

        public void seekExact(long ord) throws IOException {
            this.delegate.seekExact(ord);
        }

        public void seekExact(BytesRef term, TermState state) throws IOException {
            this.delegate.seekExact(term, state);
        }

        public BytesRef term() throws IOException {
            return this.fmRuleField.apply(this.delegate.term());
        }

        public long ord() throws IOException {
            return this.delegate.ord();
        }

        public int docFreq() throws IOException {
            return this.delegate.docFreq();
        }

        public long totalTermFreq() throws IOException {
            return this.delegate.totalTermFreq();
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return this.delegate.postings(reuse, flags);
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            return this.delegate.impacts(flags);
        }

        public TermState termState() throws IOException {
            return this.delegate.termState();
        }
    }

    static class DlsFlsDirectoryReader
    extends FilterDirectoryReader {
        private final FieldPrivileges.FlsRule flsRule;
        private final Query dlsQuery;
        private final IndexService indexService;
        private final ThreadContext threadContext;
        private final ClusterService clusterService;
        private final AuditLog auditlog;
        private final FieldMasking.FieldMaskingRule fmRule;
        private final ShardId shardId;
        private final Set<String> metaFields;

        public DlsFlsDirectoryReader(DirectoryReader in, FieldPrivileges.FlsRule flsRule, Query dlsQuery, IndexService indexService, ThreadContext threadContext, ClusterService clusterService, AuditLog auditlog, FieldMasking.FieldMaskingRule fmRule, ShardId shardId, Set<String> metaFields) throws IOException {
            super(in, (FilterDirectoryReader.SubReaderWrapper)new DlsFlsSubReaderWrapper(flsRule, dlsQuery, indexService, threadContext, clusterService, auditlog, fmRule, shardId, metaFields));
            this.flsRule = flsRule;
            this.dlsQuery = dlsQuery;
            this.indexService = indexService;
            this.threadContext = threadContext;
            this.clusterService = clusterService;
            this.auditlog = auditlog;
            this.fmRule = fmRule;
            this.shardId = shardId;
            this.metaFields = metaFields;
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new DlsFlsDirectoryReader(in, this.flsRule, this.dlsQuery, this.indexService, this.threadContext, this.clusterService, this.auditlog, this.fmRule, this.shardId, this.metaFields);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static class DlsFlsSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final FieldPrivileges.FlsRule flsRule;
        private final Query dlsQuery;
        private final IndexService indexService;
        private final ThreadContext threadContext;
        private final ClusterService clusterService;
        private final AuditLog auditlog;
        private final FieldMasking.FieldMaskingRule fmRule;
        private final ShardId shardId;
        private final Set<String> metaFields;

        public DlsFlsSubReaderWrapper(FieldPrivileges.FlsRule flsRule, Query dlsQuery, IndexService indexService, ThreadContext threadContext, ClusterService clusterService, AuditLog auditlog, FieldMasking.FieldMaskingRule fmRule, ShardId shardId, Set<String> metaFields) {
            this.flsRule = flsRule;
            this.dlsQuery = dlsQuery;
            this.indexService = indexService;
            this.threadContext = threadContext;
            this.clusterService = clusterService;
            this.auditlog = auditlog;
            this.fmRule = fmRule;
            this.shardId = shardId;
            this.metaFields = metaFields;
        }

        public LeafReader wrap(LeafReader reader) {
            return new DlsFlsFilterLeafReader(reader, this.flsRule, this.dlsQuery, this.indexService, this.threadContext, this.clusterService, this.auditlog, this.fmRule, this.shardId, this.metaFields);
        }
    }
}

