/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class BroadcastToWebsocketMessage
implements WebsocketMessage,
Writeable {
    private static final String PREFIX = "[BROADCAST_TO]";
    private final List<String> receivers;
    private final String message;

    public BroadcastToWebsocketMessage(List<String> receivers, String message) {
        Objects.requireNonNull(receivers, "'receivers' must not be null");
        Objects.requireNonNull(message, "'message' must not be null");
        this.receivers = receivers;
        this.message = message;
    }

    public BroadcastToWebsocketMessage(List<String> receivers, WebsocketMessage websocketMessage) throws WebsocketMessageException {
        Objects.requireNonNull(receivers, "'receivers' must not be null");
        Objects.requireNonNull(websocketMessage, "'websocketMessage' must not be null");
        this.receivers = receivers;
        this.message = websocketMessage.getMessageToSend();
    }

    public BroadcastToWebsocketMessage(StreamInput in) throws IOException {
        this.receivers = new ArrayList<String>(in.readStringList());
        this.message = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.receivers);
        out.writeString(this.message);
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static BroadcastToWebsocketMessage createFromMessage(String websocketMessage) {
        String broadcastMessage = websocketMessage.substring(PREFIX.length());
        String serverUUIDs = broadcastMessage.substring(0, broadcastMessage.indexOf(":::"));
        List receivers = StringUtil.explode((String)serverUUIDs, (String)"@@@");
        String message = broadcastMessage.substring((serverUUIDs + ":::").length());
        return new BroadcastToWebsocketMessage((List<String>)receivers, message);
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        return PREFIX + StringUtil.implode((String)"@@@", this.receivers) + ":::" + this.message;
    }

    public List<String> getReceivers() {
        return this.receivers;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastToWebsocketMessage that = (BroadcastToWebsocketMessage)o;
        return Objects.equals(this.receivers, that.receivers) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.receivers, this.message);
    }

    public String toString() {
        return "BroadcastToWebsocketMessage{receivers=" + String.valueOf(this.receivers) + ", message='" + this.message + "'}";
    }
}

