/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.mapper.Uid;
import org.opensearch.index.translog.Translog;

public final class TranslogLeafReader
extends LeafReader {
    private final Translog.Index operation;
    private final EngineConfig engineConfig;
    private volatile LeafReader inMemoryIndexReader;
    private static final FieldInfo FAKE_SOURCE_FIELD = new FieldInfo("_source", 1, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
    private static final FieldInfo FAKE_ROUTING_FIELD = new FieldInfo("_routing", 2, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
    private static final FieldInfo FAKE_ID_FIELD = new FieldInfo("_id", 3, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
    public static Set<String> ALL_FIELD_NAMES = Sets.newHashSet((Object[])new String[]{TranslogLeafReader.FAKE_SOURCE_FIELD.name, TranslogLeafReader.FAKE_ROUTING_FIELD.name, TranslogLeafReader.FAKE_ID_FIELD.name});

    public TranslogLeafReader(Translog.Index operation, EngineConfig engineConfig) {
        this.operation = operation;
        this.engineConfig = engineConfig;
    }

    private LeafReader getInMemoryIndexReader() throws IOException {
        if (this.inMemoryIndexReader == null) {
            this.inMemoryIndexReader = TranslogLeafReader.createInMemoryIndexReader(this.operation, this.engineConfig);
        }
        return this.inMemoryIndexReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LeafReader createInMemoryIndexReader(Translog.Index operation, EngineConfig engineConfig) throws IOException {
        boolean success = false;
        ByteBuffersDirectory directory = new ByteBuffersDirectory();
        try {
            SourceToParse sourceToParse = new SourceToParse(engineConfig.getIndexSettings().getIndex().getName(), operation.id(), operation.source(), MediaTypeRegistry.xContentType((BytesReference)operation.source()), operation.routing());
            ParsedDocument parsedDocument = engineConfig.getDocumentMapperForTypeSupplier().get().getDocumentMapper().parse(sourceToParse);
            parsedDocument.updateSeqID(operation.seqNo(), operation.primaryTerm());
            parsedDocument.version().setLongValue(operation.version());
            IndexWriterConfig iwc = new IndexWriterConfig(engineConfig.getAnalyzer());
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            iwc.setCodec(engineConfig.getCodec());
            IndexWriter indexWriter = new IndexWriter((Directory)directory, iwc);
            indexWriter.addDocuments(parsedDocument.docs());
            DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)indexWriter);
            if (directoryReader.leaves().size() != 1 || ((LeafReaderContext)directoryReader.leaves().get(0)).reader().numDocs() != parsedDocument.docs().size()) {
                throw new IllegalStateException("Expected a single segment with " + parsedDocument.docs().size() + " documents, but [" + directoryReader.leaves().size() + " segments with " + ((LeafReaderContext)directoryReader.leaves().get(0)).reader().numDocs() + " documents");
            }
            LeafReader leafReader = ((LeafReaderContext)directoryReader.leaves().get(0)).reader();
            SequentialStoredFieldsLeafReader sequentialLeafReader = new SequentialStoredFieldsLeafReader(leafReader, (Directory)directory, leafReader){
                final /* synthetic */ Directory val$directory;
                final /* synthetic */ LeafReader val$leafReader;
                {
                    this.val$directory = directory;
                    this.val$leafReader = leafReader;
                    super(in);
                }

                protected void doClose() throws IOException {
                    IOUtils.close((Closeable[])new Closeable[]{() -> super.doClose(), this.val$directory});
                }

                public IndexReader.CacheHelper getCoreCacheHelper() {
                    return this.val$leafReader.getCoreCacheHelper();
                }

                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return this.val$leafReader.getReaderCacheHelper();
                }

                @Override
                public StoredFieldsReader getSequentialStoredFieldsReader() {
                    return Lucene.segmentReader(this.val$leafReader).getFieldsReader().getMergeInstance();
                }

                @Override
                protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
                    return reader;
                }
            };
            success = true;
            SequentialStoredFieldsLeafReader sequentialStoredFieldsLeafReader = sequentialLeafReader;
            return sequentialStoredFieldsLeafReader;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)directory);
            }
        }
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        throw new UnsupportedOperationException();
    }

    public Terms terms(String field) {
        throw new UnsupportedOperationException();
    }

    public NumericDocValues getNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public BinaryDocValues getBinaryDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public SortedDocValues getSortedDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public SortedSetDocValues getSortedSetDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public NumericDocValues getNormValues(String field) {
        throw new UnsupportedOperationException();
    }

    public FieldInfos getFieldInfos() {
        throw new UnsupportedOperationException();
    }

    public Bits getLiveDocs() {
        throw new UnsupportedOperationException();
    }

    public PointValues getPointValues(String field) {
        throw new UnsupportedOperationException();
    }

    public void checkIntegrity() {
    }

    public LeafMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public TermVectors termVectors() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int numDocs() {
        return 1;
    }

    public int maxDoc() {
        return 1;
    }

    public StoredFields storedFields() throws IOException {
        return new StoredFields(){

            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                if (docID != 0) {
                    throw new IllegalArgumentException("no such doc ID " + docID);
                }
                if (visitor.needsField(FAKE_SOURCE_FIELD) == StoredFieldVisitor.Status.YES) {
                    if (TranslogLeafReader.this.engineConfig.getIndexSettings().isDerivedSourceEnabled() && TranslogLeafReader.this.engineConfig.getIndexSettings().isDerivedSourceEnabledForTranslog()) {
                        LeafReader leafReader = TranslogLeafReader.this.getInMemoryIndexReader();
                        assert (leafReader != null && leafReader.leaves().size() == 1);
                        visitor.binaryField(FAKE_SOURCE_FIELD, TranslogLeafReader.this.engineConfig.getDocumentMapperForTypeSupplier().get().getDocumentMapper().root().deriveSource((LeafReader)leafReader, (int)docID).toBytesRef().bytes);
                    } else {
                        assert (TranslogLeafReader.this.operation.source().toBytesRef().offset == 0);
                        assert (TranslogLeafReader.this.operation.source().toBytesRef().length == TranslogLeafReader.this.operation.source().toBytesRef().bytes.length);
                        visitor.binaryField(FAKE_SOURCE_FIELD, TranslogLeafReader.this.operation.source().toBytesRef().bytes);
                    }
                }
                if (TranslogLeafReader.this.operation.routing() != null && visitor.needsField(FAKE_ROUTING_FIELD) == StoredFieldVisitor.Status.YES) {
                    visitor.stringField(FAKE_ROUTING_FIELD, TranslogLeafReader.this.operation.routing());
                }
                if (visitor.needsField(FAKE_ID_FIELD) == StoredFieldVisitor.Status.YES) {
                    BytesRef bytesRef = Uid.encodeId(TranslogLeafReader.this.operation.id());
                    byte[] id = new byte[bytesRef.length];
                    System.arraycopy(bytesRef.bytes, bytesRef.offset, id, 0, bytesRef.length);
                    visitor.binaryField(FAKE_ID_FIELD, id);
                }
            }
        };
    }

    protected void doClose() {
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        throw new UnsupportedOperationException();
    }

    public FloatVectorValues getFloatVectorValues(String field) {
        throw new UnsupportedOperationException();
    }

    public ByteVectorValues getByteVectorValues(String field) {
        throw new UnsupportedOperationException();
    }

    public void searchNearestVectors(String field, byte[] target, KnnCollector k, Bits acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void searchNearestVectors(String field, float[] target, KnnCollector k, Bits acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DocValuesSkipper getDocValuesSkipper(String field) throws IOException {
        throw new UnsupportedOperationException();
    }
}

