/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.approximate;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.sandbox.document.BigIntegerPoint;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.IntsRef;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumericPointEncoder;
import org.opensearch.search.approximate.ApproximateQuery;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortOrder;

public class ApproximatePointRangeQuery
extends ApproximateQuery {
    public static final Function<byte[], String> LONG_FORMAT = bytes -> Long.toString(LongPoint.decodeDimension((byte[])bytes, (int)0));
    public static final Function<byte[], String> INT_FORMAT = bytes -> Integer.toString(IntPoint.decodeDimension((byte[])bytes, (int)0));
    public static final Function<byte[], String> HALF_FLOAT_FORMAT = bytes -> Float.toString(HalfFloatPoint.decodeDimension((byte[])bytes, (int)0));
    public static final Function<byte[], String> FLOAT_FORMAT = bytes -> Float.toString(FloatPoint.decodeDimension((byte[])bytes, (int)0));
    public static final Function<byte[], String> DOUBLE_FORMAT = bytes -> Double.toString(DoublePoint.decodeDimension((byte[])bytes, (int)0));
    public static final Function<byte[], String> UNSIGNED_LONG_FORMAT = bytes -> BigIntegerPoint.decodeDimension((byte[])bytes, (int)0).toString();
    private int size;
    private SortOrder sortOrder;
    public PointRangeQuery pointRangeQuery;
    private final Function<byte[], String> valueToString;

    public ApproximatePointRangeQuery(String field, byte[] lowerPoint, byte[] upperPoint, int numDims, Function<byte[], String> valueToString) {
        this(field, lowerPoint, upperPoint, numDims, 10000, null, valueToString);
    }

    protected ApproximatePointRangeQuery(String field, byte[] lowerPoint, byte[] upperPoint, int numDims, int size, SortOrder sortOrder, final Function<byte[], String> valueToString) {
        this.size = size;
        this.sortOrder = sortOrder;
        this.valueToString = valueToString;
        this.pointRangeQuery = new PointRangeQuery(this, field, lowerPoint, upperPoint, numDims){

            protected String toString(int dimension, byte[] value) {
                return (String)valueToString.apply(value);
            }
        };
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return super.rewrite(indexSearcher);
    }

    public void visit(QueryVisitor visitor) {
        this.pointRangeQuery.visit(visitor);
    }

    public final ConstantScoreWeight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator((int)this.pointRangeQuery.getBytesPerDim());
        final Weight pointRangeQueryWeight = this.pointRangeQuery.createWeight(searcher, scoreMode, boost);
        return new ConstantScoreWeight(this, this, boost){
            final /* synthetic */ ApproximatePointRangeQuery this$0;
            {
                this.this$0 = this$0;
                super(query, score);
            }

            private boolean matches(byte[] packedValue) {
                for (int dim = 0; dim < this.this$0.pointRangeQuery.getNumDims(); ++dim) {
                    int offset = dim * this.this$0.pointRangeQuery.getBytesPerDim();
                    if (comparator.compare(packedValue, offset, this.this$0.pointRangeQuery.getLowerPoint(), offset) < 0) {
                        return false;
                    }
                    if (comparator.compare(packedValue, offset, this.this$0.pointRangeQuery.getUpperPoint(), offset) <= 0) continue;
                    return false;
                }
                return true;
            }

            private PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
                boolean crosses = false;
                for (int dim = 0; dim < this.this$0.pointRangeQuery.getNumDims(); ++dim) {
                    int offset = dim * this.this$0.pointRangeQuery.getBytesPerDim();
                    if (comparator.compare(minPackedValue, offset, this.this$0.pointRangeQuery.getUpperPoint(), offset) > 0 || comparator.compare(maxPackedValue, offset, this.this$0.pointRangeQuery.getLowerPoint(), offset) < 0) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    crosses |= comparator.compare(minPackedValue, offset, this.this$0.pointRangeQuery.getLowerPoint(), offset) < 0 || comparator.compare(maxPackedValue, offset, this.this$0.pointRangeQuery.getUpperPoint(), offset) > 0;
                }
                if (crosses) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }

            public PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result, final long[] docCount) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    public void visit(int docID) {
                        this.adder.add(docID);
                        docCount[0] = docCount[0] + 1L;
                    }

                    public void visit(DocIdSetIterator iterator) throws IOException {
                        this.adder.add(iterator);
                    }

                    public void visit(IntsRef ref) {
                        this.adder.add(ref);
                        docCount[0] = docCount[0] + (long)ref.length;
                    }

                    public void visit(int docID, byte[] packedValue) {
                        if (this.this$1.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (this.this$1.matches(packedValue)) {
                            this.adder.add(iterator);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return this.this$1.relate(minPackedValue, maxPackedValue);
                    }
                };
            }

            private boolean checkValidPointValues(PointValues values) throws IOException {
                if (values == null) {
                    return false;
                }
                if (values.getNumIndexDimensions() != this.this$0.pointRangeQuery.getNumDims()) {
                    throw new IllegalArgumentException("field=\"" + this.this$0.pointRangeQuery.getField() + "\" was indexed with numIndexDimensions=" + values.getNumIndexDimensions() + " but this query has numDims=" + this.this$0.pointRangeQuery.getNumDims());
                }
                if (this.this$0.pointRangeQuery.getBytesPerDim() != values.getBytesPerDimension()) {
                    throw new IllegalArgumentException("field=\"" + this.this$0.pointRangeQuery.getField() + "\" was indexed with bytesPerDim=" + values.getBytesPerDimension() + " but this query has bytesPerDim=" + this.this$0.pointRangeQuery.getBytesPerDim());
                }
                return true;
            }

            private void intersectLeft(PointValues.PointTree pointTree, PointValues.IntersectVisitor visitor, long[] docCount) throws IOException {
                this.intersectLeft(visitor, pointTree, docCount);
                assert (!pointTree.moveToParent());
            }

            private void intersectRight(PointValues.PointTree pointTree, PointValues.IntersectVisitor visitor, long[] docCount) throws IOException {
                this.intersectRight(visitor, pointTree, docCount);
                assert (!pointTree.moveToParent());
            }

            public void intersectLeft(PointValues.IntersectVisitor visitor, PointValues.PointTree pointTree, long[] docCount) throws IOException {
                long needed;
                long leftSize;
                if (docCount[0] >= (long)this.this$0.size) {
                    return;
                }
                PointValues.Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
                if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return;
                }
                if (!pointTree.moveToChild()) {
                    if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
                        pointTree.visitDocIDs(visitor);
                    } else {
                        pointTree.visitDocValues(visitor);
                    }
                    return;
                }
                if (r == PointValues.Relation.CELL_INSIDE_QUERY && (leftSize = pointTree.size()) >= (needed = (long)this.this$0.size - docCount[0])) {
                    this.intersectLeft(visitor, pointTree, docCount);
                    pointTree.moveToParent();
                    return;
                }
                PointValues.PointTree rightChild = null;
                if (pointTree.moveToSibling()) {
                    rightChild = pointTree.clone();
                    pointTree.moveToParent();
                    pointTree.moveToChild();
                }
                this.intersectLeft(visitor, pointTree, docCount);
                if (docCount[0] < (long)this.this$0.size && rightChild != null) {
                    this.intersectLeft(visitor, rightChild, docCount);
                }
                pointTree.moveToParent();
            }

            public void intersectRight(PointValues.IntersectVisitor visitor, PointValues.PointTree pointTree, long[] docCount) throws IOException {
                long needed;
                long rightSize;
                if (docCount[0] >= (long)this.this$0.size) {
                    return;
                }
                PointValues.Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
                if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return;
                }
                if (!pointTree.moveToChild()) {
                    if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
                        pointTree.visitDocIDs(visitor);
                    } else {
                        pointTree.visitDocValues(visitor);
                    }
                    return;
                }
                PointValues.PointTree leftChild = pointTree.clone();
                boolean hasRightChild = pointTree.moveToSibling();
                if (r == PointValues.Relation.CELL_INSIDE_QUERY && hasRightChild && (rightSize = pointTree.size()) >= (needed = (long)this.this$0.size - docCount[0])) {
                    this.intersectRight(visitor, pointTree, docCount);
                    pointTree.moveToParent();
                    return;
                }
                if (hasRightChild) {
                    this.intersectRight(visitor, pointTree, docCount);
                }
                if (docCount[0] < (long)this.this$0.size) {
                    this.intersectRight(visitor, leftChild, docCount);
                }
                pointTree.moveToParent();
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final long[] docCount = new long[]{0L};
                final PointValues values = reader.getPointValues(this.this$0.pointRangeQuery.getField());
                if (!this.checkValidPointValues(values)) {
                    return null;
                }
                if ((long)this.this$0.size > values.size()) {
                    return pointRangeQueryWeight.scorerSupplier(context);
                }
                if (this.this$0.sortOrder == null || this.this$0.sortOrder.equals((Object)SortOrder.ASC)) {
                    return new ScorerSupplier(this){
                        final DocIdSetBuilder result;
                        final PointValues.IntersectVisitor visitor;
                        long cost;
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.result = new DocIdSetBuilder(reader.maxDoc(), values);
                            this.visitor = this.this$1.getIntersectVisitor(this.result, docCount);
                            this.cost = -1L;
                        }

                        public Scorer get(long leadCost) throws IOException {
                            this.this$1.intersectLeft(values.getPointTree(), this.visitor, docCount);
                            DocIdSetIterator iterator = this.result.build().iterator();
                            return new ConstantScoreScorer(this.this$1.score(), scoreMode, iterator);
                        }

                        public long cost() {
                            if (this.cost == -1L) {
                                this.cost = values.estimateDocCount(this.visitor);
                                assert (this.cost >= 0L);
                            }
                            return this.cost;
                        }
                    };
                }
                int deletedDocs = reader.numDeletedDocs();
                this.this$0.size += deletedDocs;
                return new ScorerSupplier(this){
                    final DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    long cost;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values);
                        this.visitor = this.this$1.getIntersectVisitor(this.result, docCount);
                        this.cost = -1L;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        this.this$1.intersectRight(values.getPointTree(), this.visitor, docCount);
                        DocIdSetIterator iterator = this.result.build().iterator();
                        return new ConstantScoreScorer(this.this$1.score(), scoreMode, iterator);
                    }

                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(this.visitor);
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            public int count(LeafReaderContext context) throws IOException {
                return pointRangeQueryWeight.count(context);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    private byte[] computeEffectiveBound(SearchContext context, boolean isLowerBound) {
        boolean isAscending;
        byte[] originalBound = isLowerBound ? this.pointRangeQuery.getLowerPoint() : this.pointRangeQuery.getUpperPoint();
        boolean bl = isAscending = this.sortOrder == null || this.sortOrder.equals((Object)SortOrder.ASC);
        if (isLowerBound && isAscending || !isLowerBound && !isAscending) {
            Object searchAfterValue = context.request().source().searchAfter()[0];
            MappedFieldType fieldType = context.getQueryShardContext().fieldMapper(this.pointRangeQuery.getField());
            if (fieldType instanceof NumericPointEncoder) {
                NumericPointEncoder encoder = (NumericPointEncoder)((Object)fieldType);
                return encoder.encodePoint(searchAfterValue, isLowerBound);
            }
        }
        return originalBound;
    }

    @Override
    public boolean canApproximate(SearchContext context) {
        if (context == null) {
            return false;
        }
        if (context.aggregations() != null) {
            return false;
        }
        if (context.trackTotalHitsUpTo() == Integer.MAX_VALUE) {
            return false;
        }
        if (context.from() + context.size() == 0) {
            this.setSize(10000);
        } else {
            this.setSize(Math.max(context.from() + context.size(), context.trackTotalHitsUpTo()) + 1);
        }
        if (context.request() != null && context.request().source() != null) {
            if (context.request().source().sorts() != null && context.request().source().sorts().size() > 1) {
                return false;
            }
            FieldSortBuilder primarySortField = FieldSortBuilder.getPrimaryFieldSortOrNull(context.request().source());
            if (primarySortField != null) {
                if (!primarySortField.fieldName().equals(this.pointRangeQuery.getField())) {
                    return false;
                }
                if (primarySortField.missing() != null) {
                    return false;
                }
                this.setSortOrder(primarySortField.order());
                if (context.request().source().searchAfter() != null) {
                    byte[] upper;
                    byte[] lower;
                    if (this.sortOrder == SortOrder.ASC) {
                        lower = this.computeEffectiveBound(context, true);
                        upper = this.pointRangeQuery.getUpperPoint();
                    } else {
                        lower = this.pointRangeQuery.getLowerPoint();
                        upper = this.computeEffectiveBound(context, false);
                    }
                    this.pointRangeQuery = new PointRangeQuery(this.pointRangeQuery.getField(), lower, upper, this.pointRangeQuery.getNumDims()){

                        protected String toString(int dimension, byte[] value) {
                            return ApproximatePointRangeQuery.this.valueToString.apply(value);
                        }
                    };
                }
            }
            return context.request().source().terminateAfter() == 0;
        }
        return true;
    }

    public final int hashCode() {
        return this.pointRangeQuery.hashCode();
    }

    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((ApproximatePointRangeQuery)((Object)((Object)((Object)this)).getClass().cast(o)));
    }

    private boolean equalsTo(ApproximatePointRangeQuery other) {
        return Objects.equals(this.pointRangeQuery, other.pointRangeQuery);
    }

    public final String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("Approximate(");
        sb.append(this.pointRangeQuery.toString());
        sb.append(")");
        return sb.toString();
    }
}

