/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.function.LongSupplier;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateMathParser;
import org.opensearch.index.compositeindex.datacube.DateDimension;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitRounding;
import org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.RangeMatchDimFilter;
import org.opensearch.search.startree.filter.provider.DimensionFilterMapper;
import org.opensearch.search.startree.filter.provider.StarTreeRangeQuery;

class StarDateFieldMapper
implements DimensionFilterMapper {
    CompositeDataCubeFieldType compositeDataCubeFieldType;
    LongSupplier nowSupplier = () -> searchContext.getQueryShardContext().nowInMillis();
    String subDimensionField;
    DateDimension dateDimension;
    List<String> sortedSubDimensions;

    public StarDateFieldMapper(SearchContext searchContext) {
        this.compositeDataCubeFieldType = (CompositeDataCubeFieldType)searchContext.mapperService().getCompositeFieldTypes().iterator().next();
        this.dateDimension = this.compositeDataCubeFieldType.getDimensions().stream().filter(dim -> dim instanceof DateDimension).findFirst().orElse(null);
        this.sortedSubDimensions = this.dateDimension != null ? this.dateDimension.getSubDimensionNames() : null;
    }

    @Override
    public DimensionFilter getExactMatchFilter(MappedFieldType mappedFieldType, List<Object> rawValues) {
        return null;
    }

    @Override
    public DimensionFilter getRangeMatchFilter(MappedFieldType mappedFieldType, StarTreeRangeQuery rangeQuery) {
        DateFieldMapper.DateFieldType dateFieldType = (DateFieldMapper.DateFieldType)mappedFieldType;
        String field = rangeQuery.fieldName();
        assert (Objects.equals(this.dateDimension.getField(), rangeQuery.fieldName()));
        DateMathParser forcedDateParser = rangeQuery.format() != null ? DateFormatter.forPattern(rangeQuery.format()).toDateMathParser() : DateFieldMapper.getDefaultDateTimeFormatter().toDateMathParser();
        ZoneId timeZone = rangeQuery.timeZone() != null ? ZoneId.of(rangeQuery.timeZone()) : null;
        long l = Long.MIN_VALUE;
        long u = Long.MAX_VALUE;
        if (rangeQuery.from() != null) {
            l = DateFieldMapper.DateFieldType.parseToLong(rangeQuery.from(), !rangeQuery.includeLower(), timeZone, forcedDateParser, this.nowSupplier, dateFieldType.resolution());
            if (!rangeQuery.includeLower()) {
                ++l;
            }
        }
        if (rangeQuery.to() != null) {
            u = DateFieldMapper.DateFieldType.parseToLong(rangeQuery.to(), rangeQuery.includeUpper(), timeZone, forcedDateParser, this.nowSupplier, dateFieldType.resolution());
            if (!rangeQuery.includeUpper()) {
                --u;
            }
        }
        SequencedCollection intervals = this.dateDimension.getSortedCalendarIntervals().reversed();
        DateTimeUnitRounding matchingInterval = null;
        for (DateTimeUnitRounding interval : intervals) {
            boolean roundedHighMatches;
            boolean roundedLowMatches = l == Long.MIN_VALUE || interval.roundFloor(l) == l;
            boolean bl = roundedHighMatches = u == Long.MAX_VALUE || interval.roundFloor(u + 1L) == u + 1L;
            if (!roundedLowMatches || !roundedHighMatches) continue;
            matchingInterval = interval;
            break;
        }
        if (matchingInterval == null) {
            return null;
        }
        this.subDimensionField = field + "_" + matchingInterval.shortName();
        return new RangeMatchDimFilter(field, l, u, true, true){

            @Override
            public String getSubDimensionName() {
                return StarDateFieldMapper.this.subDimensionField;
            }
        };
    }

    @Override
    public boolean resolveUsingSubDimension() {
        return true;
    }

    @Override
    public List<DimensionFilter> getFinalDimensionFilters(List<DimensionFilter> filters) {
        if (filters == null || filters.size() <= 1) {
            return filters;
        }
        boolean needsFinalFilter = false;
        int lowestDimensionGranularity = this.sortedSubDimensions.indexOf(filters.getFirst().getSubDimensionName());
        for (DimensionFilter filter : filters) {
            int granularity = this.sortedSubDimensions.indexOf(filter.getSubDimensionName());
            if (lowestDimensionGranularity <= granularity) continue;
            needsFinalFilter = true;
            lowestDimensionGranularity = granularity;
        }
        if (!needsFinalFilter) {
            return filters;
        }
        final String finalSubDimensionField = this.sortedSubDimensions.get(lowestDimensionGranularity);
        String dimensionName = filters.getFirst().getDimensionName();
        ArrayList<DimensionFilter> updatedFilters = new ArrayList<DimensionFilter>();
        for (DimensionFilter filter : filters) {
            RangeMatchDimFilter rangeMatchDimFilter = (RangeMatchDimFilter)filter;
            updatedFilters.add(new RangeMatchDimFilter(this, dimensionName, rangeMatchDimFilter.getLow(), rangeMatchDimFilter.getHigh(), rangeMatchDimFilter.isIncludeLow(), rangeMatchDimFilter.isIncludeHigh()){

                @Override
                public String getSubDimensionName() {
                    return finalSubDimensionField;
                }
            });
        }
        return updatedFilters;
    }

    @Override
    public Optional<Long> getMatchingOrdinal(String dimensionName, Object value, StarTreeValues starTreeValues, DimensionFilter.MatchType matchType) {
        return Optional.of((Long)value);
    }

    @Override
    public int compareValues(Object v1, Object v2) {
        if (!(v1 instanceof Long) || !(v2 instanceof Long)) {
            throw new IllegalArgumentException("Expected Long values for date comparison");
        }
        return Long.compare((Long)v1, (Long)v2);
    }

    @Override
    public String getSubDimensionFieldEffective(String subDimensionField1, String subDimensionField2) {
        return this.sortedSubDimensions.indexOf(subDimensionField1) < this.sortedSubDimensions.indexOf(subDimensionField2) ? subDimensionField1 : subDimensionField2;
    }
}

