/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.BackupJobStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import org.opensearch.core.xcontent.ToXContent;

public class BackupJobStartWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "BackupJobStartMessage:::";
    private final String communicationId;
    private final BackupJobStartActionDTO startAction;
    private final Instant sendedAtInUtc;

    public BackupJobStartWebsocketMessage(String communicationId, BackupJobStartActionDTO startAction) {
        this(communicationId, startAction, TimestampUtil.nowInUtc());
    }

    public BackupJobStartWebsocketMessage(String communicationId, BackupJobStartActionDTO startAction, Instant sendedAtInUtc) {
        this.communicationId = communicationId;
        this.startAction = startAction;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public BackupJobStartWebsocketMessage(Map<String, Object> msgMap) {
        this(MapUtil.getValueAsString(msgMap, (String)"communicationId", null), new BackupJobStartActionDTO(MapUtil.getValueAsMap(msgMap, (String)"action", null)), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
        this.checkForWellKnownKeys(msgMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> msgMap) {
        MapUtil.checkForWellKnownKeys(msgMap, Set.of("communicationId", "action", "sendedAt"));
    }

    private Map<String, Object> asMap() throws IOException {
        return MapUtil.mapOf((Object[])new Object[]{"communicationId", this.communicationId, "action", JsonUtil.asMap((ToXContent)this.startAction), "sendedAt", this.sendedAtInUtc});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static BackupJobStartWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new BackupJobStartWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + BackupJobStartWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public BackupJobStartActionDTO getStartAction() {
        return this.startAction;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "BackupJobStartWebsocketMessage{communicationId='" + this.communicationId + "', startAction=" + String.valueOf(this.startAction) + ", sendedAtInUtc=" + String.valueOf(this.sendedAtInUtc) + "}";
    }
}

