/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.WebSocketEndpointConfigurator;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupJobInfosResponseWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BackupSnapshotCreatedInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllExceptSenderWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToAllWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastToWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobForcedStartAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobRestartAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStartAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStatsResponseWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ReplicationJobStopAcknowledgementWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerLoadedModulesWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.ServerStateInfoWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.TailsyncManualStartAcknowledgementWebsocketMessage;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.action.ActionListener;

@ServerEndpoint(value="/_bpc", configurator=WebSocketEndpointConfigurator.class)
public class WebSocket {
    private static final Logger LOGGER = Loggers.getLogger(WebSocket.class, (String[])new String[]{"os-bpc-plugin"});
    private Session session;
    private final Manager manager;

    public WebSocket(Manager manager) {
        this.manager = manager;
    }

    @OnOpen
    public void onOpen(Session session) {
        LOGGER.info("onOpen {}", (Object)session.getId());
        this.session = session;
        this.manager.registerWebSocket(this);
    }

    @OnClose
    public void onClose(CloseReason reason) {
        LOGGER.info("onClose {}", (Object)reason);
        this.manager.unregisterWebSocket(this.getId());
        this.session = null;
    }

    @OnError
    public void onError(Throwable t) {
        LOGGER.error("onError {}", (Object)(this.session == null ? null : this.session.getId()), (Object)t);
    }

    @OnMessage
    public void onMessage(String message) {
        LOGGER.debug("onMessage {}", (Object)message);
        if (message == null || message.trim().length() <= 0) {
            return;
        }
        String websocketId = this.getId();
        if (ServerStateInfoWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                ServerStateInfoWebsocketMessage serverStateInfoWebsocketMessage = ServerStateInfoWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedServerStateInfoWebsocketMessage(websocketId, serverStateInfoWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)ServerStateInfoWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (ServerLoadedModulesWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                ServerLoadedModulesWebsocketMessage serverLoadedModulesWebsocketMessage = ServerLoadedModulesWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedServerLoadedModulesWebsocketMessage(websocketId, serverLoadedModulesWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)ServerLoadedModulesWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (ReplicationJobStatsResponseWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                ReplicationJobStatsResponseWebsocketMessage replicationJobStatsResponseWebsocketMessage = ReplicationJobStatsResponseWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedReplicationJobStatsResponseWebsocketMessage(replicationJobStatsResponseWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)ReplicationJobStatsResponseWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (ReplicationJobStopAcknowledgementWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                ReplicationJobStopAcknowledgementWebsocketMessage acknowledgementWebsocketMessage = ReplicationJobStopAcknowledgementWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedWebsocketMessage(acknowledgementWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)ReplicationJobStopAcknowledgementWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (ReplicationJobStartAcknowledgementWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                ReplicationJobStartAcknowledgementWebsocketMessage acknowledgementWebsocketMessage = ReplicationJobStartAcknowledgementWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedWebsocketMessage(acknowledgementWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)ReplicationJobStartAcknowledgementWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (ReplicationJobForcedStartAcknowledgementWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                ReplicationJobForcedStartAcknowledgementWebsocketMessage acknowledgementWebsocketMessage = ReplicationJobForcedStartAcknowledgementWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedWebsocketMessage(acknowledgementWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)ReplicationJobForcedStartAcknowledgementWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (ReplicationJobRestartAcknowledgementWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                ReplicationJobRestartAcknowledgementWebsocketMessage acknowledgementWebsocketMessage = ReplicationJobRestartAcknowledgementWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedWebsocketMessage(acknowledgementWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)ReplicationJobRestartAcknowledgementWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (TailsyncManualStartAcknowledgementWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                TailsyncManualStartAcknowledgementWebsocketMessage acknowledgementWebsocketMessage = TailsyncManualStartAcknowledgementWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedWebsocketMessage(acknowledgementWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)TailsyncManualStartAcknowledgementWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (BackupJobInfosResponseWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                BackupJobInfosResponseWebsocketMessage backupJobInfosResponseWebsocketMessage = BackupJobInfosResponseWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedBackupJobInfosResponseWebsocketMessage(backupJobInfosResponseWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)BackupJobInfosResponseWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (BackupSnapshotCreatedInfoWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                BackupSnapshotCreatedInfoWebsocketMessage backupSnapshotCreatedInfoWebsocketMessage = BackupSnapshotCreatedInfoWebsocketMessage.createFromMessage((String)message);
                this.manager.processReceivedBackupSnapshotCreatedInfoWebsocketMessage(backupSnapshotCreatedInfoWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)BackupSnapshotCreatedInfoWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (BroadcastToAllWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage = BroadcastToAllWebsocketMessage.createFromMessage((String)message);
                String serverUUID = this.manager.getConnections().getServerUUIDForWebsocketId(websocketId);
                this.manager.processReceivedBroadcastToAllWebsocketMessage(websocketId, serverUUID, broadcastToAllWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)BroadcastToAllWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (BroadcastToAllExceptSenderWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                BroadcastToAllExceptSenderWebsocketMessage broadcastToAllExceptSenderWebsocketMessage = BroadcastToAllExceptSenderWebsocketMessage.createFromMessage((String)message);
                String serverUUID = this.manager.getConnections().getServerUUIDForWebsocketId(websocketId);
                this.manager.processReceivedBroadcastToAllExceptSenderWebsocketMessage(websocketId, serverUUID, broadcastToAllExceptSenderWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)BroadcastToAllExceptSenderWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        if (BroadcastToWebsocketMessage.canBeCreatedFromMessage((String)message)) {
            try {
                BroadcastToWebsocketMessage broadcastToWebsocketMessage = BroadcastToWebsocketMessage.createFromMessage((String)message);
                String serverUUID = this.manager.getConnections().getServerUUIDForWebsocketId(websocketId);
                this.manager.processReceivedBroadcastToWebsocketMessage(websocketId, serverUUID, broadcastToWebsocketMessage);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process a received '{}' websocket message.", (Object)BroadcastToWebsocketMessage.class.getSimpleName(), (Object)ex);
            }
            return;
        }
        try {
            BroadcastToAllWebsocketMessage broadcastToAllWebsocketMessage = new BroadcastToAllWebsocketMessage(message);
            String serverUUID = this.manager.getConnections().getServerUUIDForWebsocketId(websocketId);
            this.manager.processReceivedBroadcastToAllWebsocketMessage(websocketId, serverUUID, broadcastToAllWebsocketMessage);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to process a received kind of '{}' websocket message.", (Object)BroadcastToAllWebsocketMessage.class.getSimpleName(), (Object)ex);
        }
    }

    public String getId() {
        return this.session == null ? null : this.session.getId();
    }

    public void sendMessageAsync(WebsocketMessage websocketMessage, final ActionListener<Boolean> onComplete) {
        if (websocketMessage == null) {
            onComplete.onFailure(new Exception("A WebsocketMessage object must be given."));
        } else {
            try {
                String message = websocketMessage.getMessageToSend();
                if (StringUtil.isNullOrEmpty((String)message)) {
                    onComplete.onFailure(new Exception("Websocket message to send is null or empty."));
                } else if (this.session == null) {
                    onComplete.onFailure(new Exception("Websocket session is missing."));
                } else {
                    this.session.getAsyncRemote().sendText(message, new SendHandler(){

                        public void onResult(SendResult result) {
                            if (result != null && !result.isOK()) {
                                Throwable t = result.getException();
                                onComplete.onFailure(new Exception("Sending websocket message asynchronously failed.", t));
                            } else {
                                onComplete.onResponse((Object)Boolean.TRUE);
                            }
                        }
                    });
                }
            }
            catch (WebsocketMessageException ex) {
                onComplete.onFailure((Exception)((Object)ex));
            }
        }
    }
}

