/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.marshaller.csv;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Dictionary;
import org.apache.karaf.decanter.api.marshaller.Marshaller;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.karaf.decanter.marshaller.csv", immediate=true, property={"dataFormat=csv"})
public class CsvMarshaller
implements Marshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvMarshaller.class);
    private String separator = ",";

    @Activate
    public void activate(ComponentContext componentContext) {
        Dictionary config = componentContext.getProperties();
        this.separator = config.get("separator") != null ? (String)config.get("separator") : ",";
    }

    public void marshal(Object obj, OutputStream out) {
        String result = this.marshal(obj);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            writer.write(result);
        }
        catch (Exception e) {
            LOGGER.warn("Can't marshal on the output stream", (Throwable)e);
        }
    }

    public String marshal(Object obj) {
        return this.marshal((Event)obj);
    }

    private String marshal(Event event) {
        StringBuilder builder = new StringBuilder();
        for (String propertyName : event.getPropertyNames()) {
            Object propertyValue = event.getProperty(propertyName);
            if (propertyValue == null) continue;
            builder.append(propertyName).append("=").append(propertyValue.toString()).append(this.separator);
        }
        String result = builder.toString();
        result = result.substring(0, result.length() - 1);
        return result;
    }
}

