/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.lucene.store.Directory;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.RemoteDirectory;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.opensearch.index.store.lockmanager.RemoteStoreLockManagerFactory;
import org.opensearch.index.store.lockmanager.RemoteStoreMetadataLockManager;
import org.opensearch.plugins.IndexStorePlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryMissingException;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.threadpool.ThreadPool;

@PublicApi(since="2.3.0")
public class RemoteSegmentStoreDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    private final Supplier<RepositoriesService> repositoriesService;
    private final String segmentsPathFixedPrefix;
    private final ThreadPool threadPool;

    public RemoteSegmentStoreDirectoryFactory(Supplier<RepositoriesService> repositoriesService, ThreadPool threadPool, String segmentsPathFixedPrefix) {
        this.repositoriesService = repositoriesService;
        this.segmentsPathFixedPrefix = segmentsPathFixedPrefix;
        this.threadPool = threadPool;
    }

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath path) throws IOException {
        String repositoryName = indexSettings.getRemoteStoreRepository();
        String indexUUID = indexSettings.getIndex().getUUID();
        return this.newDirectory(repositoryName, indexUUID, path.getShardId(), indexSettings.getRemoteStorePathStrategy());
    }

    public Directory newDirectory(String repositoryName, String indexUUID, ShardId shardId, RemoteStorePathStrategy pathStrategy) throws IOException {
        return this.newDirectory(repositoryName, indexUUID, shardId, pathStrategy, null);
    }

    public Directory newDirectory(String repositoryName, String indexUUID, ShardId shardId, RemoteStorePathStrategy pathStrategy, String indexFixedPrefix) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory;
        block10: {
            assert (Objects.nonNull(pathStrategy));
            Repository repository = this.repositoriesService.get().repository(repositoryName);
            try {
                assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
                BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
                BlobPath repositoryBasePath = blobStoreRepository.basePath();
                String shardIdStr = String.valueOf(shardId.id());
                ConcurrentHashMap<String, String> pendingDownloadMergedSegments = new ConcurrentHashMap<String, String>();
                RemoteStorePathStrategy.ShardDataPathInput dataPathInput = ((RemoteStorePathStrategy.ShardDataPathInput.Builder)((RemoteStorePathStrategy.ShardDataPathInput.Builder)((RemoteStorePathStrategy.ShardDataPathInput.Builder)RemoteStorePathStrategy.ShardDataPathInput.builder().basePath(repositoryBasePath)).indexUUID(indexUUID)).shardId(shardIdStr).dataCategory(RemoteStoreEnums.DataCategory.SEGMENTS).dataType(RemoteStoreEnums.DataType.DATA).fixedPrefix(this.segmentsPathFixedPrefix)).indexFixedPrefix(indexFixedPrefix).build();
                BlobPath dataPath = pathStrategy.generatePath(dataPathInput);
                RemoteDirectory dataDirectory = new RemoteDirectory(blobStoreRepository.blobStore().blobContainer(dataPath), blobStoreRepository::maybeRateLimitRemoteUploadTransfers, blobStoreRepository::maybeRateLimitLowPriorityRemoteUploadTransfers, blobStoreRepository::maybeRateLimitRemoteDownloadTransfers, blobStoreRepository::maybeRateLimitLowPriorityDownloadTransfers, pendingDownloadMergedSegments);
                RemoteStorePathStrategy.ShardDataPathInput mdPathInput = ((RemoteStorePathStrategy.ShardDataPathInput.Builder)((RemoteStorePathStrategy.ShardDataPathInput.Builder)((RemoteStorePathStrategy.ShardDataPathInput.Builder)RemoteStorePathStrategy.ShardDataPathInput.builder().basePath(repositoryBasePath)).indexUUID(indexUUID)).shardId(shardIdStr).dataCategory(RemoteStoreEnums.DataCategory.SEGMENTS).dataType(RemoteStoreEnums.DataType.METADATA).fixedPrefix(this.segmentsPathFixedPrefix)).indexFixedPrefix(indexFixedPrefix).build();
                BlobPath mdPath = pathStrategy.generatePath(mdPathInput);
                RemoteDirectory metadataDirectory = new RemoteDirectory(blobStoreRepository.blobStore().blobContainer(mdPath));
                RemoteStoreMetadataLockManager mdLockManager = RemoteStoreLockManagerFactory.newLockManager(this.repositoriesService.get(), repositoryName, indexUUID, shardIdStr, pathStrategy, this.segmentsPathFixedPrefix, indexFixedPrefix);
                remoteSegmentStoreDirectory = new RemoteSegmentStoreDirectory(dataDirectory, metadataDirectory, mdLockManager, this.threadPool, shardId, pendingDownloadMergedSegments);
                if (repository == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryMissingException e) {
                    throw new IllegalArgumentException("Repository should be created before creating index with remote_store enabled setting", (Throwable)((Object)e));
                }
            }
            repository.close();
        }
        return remoteSegmentStoreDirectory;
    }

    public Supplier<RepositoriesService> getRepositoriesService() {
        return this.repositoriesService;
    }
}

