/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node.remotestore;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.node.remotestore.RemoteStorePinnedTimestampService;

public class RemoteStoreNodeStats
implements Writeable,
ToXContentFragment {
    public static final String STATS_NAME = "remote_store";
    public static final String LAST_SUCCESSFUL_FETCH_OF_PINNED_TIMESTAMPS = "last_successful_fetch_of_pinned_timestamps";
    private final long lastSuccessfulFetchOfPinnedTimestamps;

    public RemoteStoreNodeStats() {
        this.lastSuccessfulFetchOfPinnedTimestamps = (Long)RemoteStorePinnedTimestampService.getPinnedTimestamps().v1();
    }

    public long getLastSuccessfulFetchOfPinnedTimestamps() {
        return this.lastSuccessfulFetchOfPinnedTimestamps;
    }

    public RemoteStoreNodeStats(StreamInput in) throws IOException {
        this.lastSuccessfulFetchOfPinnedTimestamps = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.lastSuccessfulFetchOfPinnedTimestamps);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(STATS_NAME);
        builder.field(LAST_SUCCESSFUL_FETCH_OF_PINNED_TIMESTAMPS, this.lastSuccessfulFetchOfPinnedTimestamps);
        return builder.endObject();
    }

    public String toString() {
        return "RemoteStoreNodeStats{ lastSuccessfulFetchOfPinnedTimestamps=" + this.lastSuccessfulFetchOfPinnedTimestamps + "}";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != RemoteStoreNodeStats.class) {
            return false;
        }
        RemoteStoreNodeStats other = (RemoteStoreNodeStats)o;
        return this.lastSuccessfulFetchOfPinnedTimestamps == other.lastSuccessfulFetchOfPinnedTimestamps;
    }

    public int hashCode() {
        return Objects.hash(this.lastSuccessfulFetchOfPinnedTimestamps);
    }
}

