/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class MasterServerInfo
implements OpenSearchPluginDTO {
    public static final String NONE = "<<NONE>>";
    private final String serverUUID;
    private final Instant setAtInUtc;

    public MasterServerInfo(String serverUUID) {
        this.serverUUID = serverUUID == null ? NONE : serverUUID;
        this.setAtInUtc = TimestampUtil.nowInUtc();
    }

    public MasterServerInfo(Map<String, Object> map) {
        Objects.requireNonNull(map, "'map' must not be null");
        this.checkForWellKnownKeys(map);
        this.serverUUID = MapUtil.getValueAsString(map, (String)"serverUUID", (String)NONE);
        this.setAtInUtc = MapUtil.getValueAsInstant(map, (String)"setAt", (Instant)TimestampUtil.nowInUtc());
    }

    private void checkForWellKnownKeys(Map<String, Object> map) {
        MapUtil.checkForWellKnownKeys(map, Set.of("serverUUID", "setAt"));
    }

    public MasterServerInfo(StreamInput in) throws IOException {
        this.serverUUID = in.readOptionalString();
        this.setAtInUtc = in.readInstant();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.serverUUID);
        out.writeInstant(this.setAtInUtc);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("serverUUID", this.serverUUID);
        builder.field("setAt", TimestampUtil.formatAsIsoInstantString((Instant)this.setAtInUtc));
        builder.endObject();
        return builder;
    }

    public static MasterServerInfo fromXContent(XContentParser parser) throws IOException {
        return new MasterServerInfo(parser.map());
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public boolean isMasterServerSet() {
        return this.serverUUID != null && !this.serverUUID.equals(NONE);
    }

    public Instant getSetAtInUtc() {
        return this.setAtInUtc;
    }

    public LocalDateTime getSetAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.setAtInUtc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MasterServerInfo that = (MasterServerInfo)o;
        return Objects.equals(this.serverUUID, that.serverUUID) && Objects.equals(this.setAtInUtc, that.setAtInUtc);
    }

    public int hashCode() {
        return Objects.hash(this.serverUUID);
    }

    public String toString() {
        return "MasterServerInfo{serverUUID='" + this.serverUUID + "', setAtInUtc=" + String.valueOf(this.setAtInUtc) + "}";
    }
}

