/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage.client.azure;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.StorageSharedKeyCredential;
import de.virtimo.bpc.api.filestorage.FileStoreItem;
import de.virtimo.bpc.api.filestorage.ObjectStoreReference;
import de.virtimo.bpc.api.filestorage.clients.ObjectStorageClient;
import de.virtimo.bpc.api.filestorage.exception.FileStoreConnectionException;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageOperation;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageTypes;
import de.virtimo.bpc.api.multipart.UploadedFile;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AzureBlobStorageClient
implements ObjectStorageClient {
    private static final Logger LOGGER = LogManager.getLogger(AzureBlobStorageClient.class);
    private final BlobServiceClient blobServiceClient;

    public AzureBlobStorageClient(String endpointUrl, String accountName, String accountKey) throws FileStoreConnectionException {
        try {
            StorageSharedKeyCredential credential = new StorageSharedKeyCredential(accountName, accountKey);
            this.blobServiceClient = new BlobServiceClientBuilder().endpoint(endpointUrl).credential(credential).buildClient();
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AZURE_BLOB_STORAGE, FileStorageOperation.ESTABLISH_CONNECTION);
        }
    }

    public List<String> listBuckets() throws FileStoreConnectionException {
        LOGGER.info("Listing buckets");
        PagedIterable containers = this.blobServiceClient.listBlobContainers();
        try {
            return containers.stream().map(BlobContainerItem::getName).toList();
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AZURE_BLOB_STORAGE, FileStorageOperation.LIST_BUCKETS);
        }
    }

    public URL getPresignedDownloadURL(FileStoreItem storeItem, int urlValidityMinutes) throws FileStoreConnectionException {
        LOGGER.info("getPresignedDownloadURL storeItem={}, urlValidityMinutes={}", (Object)storeItem, (Object)urlValidityMinutes);
        ObjectStoreReference objectStoreReference = storeItem.getObjectStoreReference();
        BlobContainerClient blobContainerClient = this.blobServiceClient.getBlobContainerClient(objectStoreReference.bucket());
        BlobClient blobClient = blobContainerClient.getBlobClient(objectStoreReference.fileKey());
        BlobSasPermission permissions = new BlobSasPermission().setReadPermission(true);
        OffsetDateTime expiryTime = OffsetDateTime.now().plusMinutes(urlValidityMinutes);
        BlobServiceSasSignatureValues values = new BlobServiceSasSignatureValues(expiryTime, permissions).setStartTime(OffsetDateTime.now().minusMinutes(1L)).setContentDisposition(String.format("attachment; filename=\"%s\"", storeItem.getFilename()));
        String sasToken = blobClient.generateSas(values);
        String sasUrl = blobClient.getBlobUrl() + "?" + sasToken;
        try {
            return new URL(sasUrl);
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AZURE_BLOB_STORAGE, FileStorageOperation.GET_PRESIGNED_URL);
        }
    }

    public void uploadFile(UploadedFile file, String bucket, String fileKey, String contentType) throws FileStoreConnectionException {
        LOGGER.info("uploadFile file=..., bucket={}, fileKey={}, contentType={}", (Object)bucket, (Object)fileKey, (Object)contentType);
        try {
            BlobContainerClient blobContainerClient = this.blobServiceClient.getBlobContainerClient(bucket);
            BlobClient blobClient = blobContainerClient.getBlobClient(fileKey);
            blobClient.uploadFromFile(file.getTemporaryContentFile().toPath().toString());
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AZURE_BLOB_STORAGE, FileStorageOperation.UPLOAD_FILE);
        }
    }

    public void deleteFile(String bucket, String fileKey) throws FileStoreConnectionException {
        LOGGER.info("deleteFile bucket={}, fileKey={}", (Object)bucket, (Object)fileKey);
        try {
            BlobContainerClient blobContainerClient = this.blobServiceClient.getBlobContainerClient(bucket);
            BlobClient blobClient = blobContainerClient.getBlobClient(fileKey);
            blobClient.delete();
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AZURE_BLOB_STORAGE, FileStorageOperation.DELETE_FILE);
        }
    }

    public void close() {
    }
}

