/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage.client.aws;

import de.virtimo.bpc.api.filestorage.FileStoreItem;
import de.virtimo.bpc.api.filestorage.ObjectStoreReference;
import de.virtimo.bpc.api.filestorage.clients.ObjectStorageClient;
import de.virtimo.bpc.api.filestorage.exception.FileStoreConnectionCloseException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreConnectionException;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageOperation;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageTypes;
import de.virtimo.bpc.api.multipart.UploadedFile;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;

public class S3StorageClient
implements ObjectStorageClient {
    private static final Logger LOGGER = LogManager.getLogger(S3StorageClient.class);
    private final S3Client s3Client;
    private final S3Presigner presigner;

    public S3StorageClient(String endpointUrl, String region, String accessKey, String secretKey) throws FileStoreConnectionException {
        try {
            S3ClientBuilder builder = S3Client.builder();
            S3Presigner.Builder presignerBuilder = S3Presigner.builder();
            if (endpointUrl != null && !endpointUrl.isEmpty()) {
                builder.endpointOverride(URI.create(endpointUrl));
                presignerBuilder.endpointOverride(URI.create(endpointUrl));
                if (!endpointUrl.contains("amazonaws.com")) {
                    builder.forcePathStyle(Boolean.valueOf(true));
                    presignerBuilder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build());
                }
            }
            if (region != null && !region.isEmpty()) {
                builder.region(Region.of((String)region));
                presignerBuilder.region(Region.of((String)region));
            } else {
                builder.region(Region.US_EAST_1);
                presignerBuilder.region(Region.US_EAST_1);
            }
            this.s3Client = (S3Client)((S3ClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey)))).build();
            this.presigner = presignerBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey))).build();
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AWS_S3, FileStorageOperation.ESTABLISH_CONNECTION);
        }
    }

    public List<String> listBuckets() throws FileStoreConnectionException {
        LOGGER.info("Listing buckets");
        try {
            ListBucketsResponse listBucketResp = this.s3Client.listBuckets();
            return listBucketResp.buckets().stream().map(Bucket::name).toList();
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AWS_S3, FileStorageOperation.LIST_BUCKETS);
        }
    }

    public URL getPresignedDownloadURL(FileStoreItem storeItem, int urlValidityMinutes) throws FileStoreConnectionException {
        LOGGER.info("getPresignedDownloadURL storeItem={}, urlValidityMinutes={}", (Object)storeItem, (Object)urlValidityMinutes);
        ObjectStoreReference objectStoreReference = storeItem.getObjectStoreReference();
        try {
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(objectStoreReference.bucket()).key(objectStoreReference.fileKey()).responseContentDisposition(String.format("attachment; filename=\"%s\"", storeItem.getFilename())).responseContentType(storeItem.getContentType()).build();
            GetObjectPresignRequest presignGetRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofMinutes(urlValidityMinutes)).getObjectRequest(getObjectRequest).build();
            return this.presigner.presignGetObject(presignGetRequest).url();
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AWS_S3, FileStorageOperation.GET_PRESIGNED_URL);
        }
    }

    public void uploadFile(UploadedFile file, String bucket, String fileKey, String contentType) throws FileStoreConnectionException {
        LOGGER.info("uploadFile file=..., bucket={}, fileKey={}, contentType={}", (Object)bucket, (Object)fileKey, (Object)contentType);
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(fileKey).contentType(contentType).build();
        try {
            this.s3Client.putObject(putObjectRequest, file.getTemporaryContentFile().toPath());
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AWS_S3, FileStorageOperation.UPLOAD_FILE);
        }
    }

    public void deleteFile(String bucket, String fileKey) throws FileStoreConnectionException {
        LOGGER.info("deleteFile bucket={}, fileKey={}", (Object)bucket, (Object)fileKey);
        DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(fileKey).build();
        try {
            this.s3Client.deleteObject(deleteObjectRequest);
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.AWS_S3, FileStorageOperation.DELETE_FILE);
        }
    }

    public void close() throws FileStoreConnectionCloseException {
        try {
            this.s3Client.close();
            this.presigner.close();
        }
        catch (Exception e) {
            throw new FileStoreConnectionCloseException(e, FileStorageTypes.AWS_S3);
        }
    }
}

