/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 13;
    TimestampTzConverter tstzConverter = null;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;

    TimestamptzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.TIMESTAMPTZ, stmt, 13, isStoredInBindData);
        this.init(stmt, 181, 181, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
        this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
    }

    TimestamptzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.TIMESTAMPTZ, stmt, 13, false);
        this.init(stmt, 181, 181, form, false);
        this.initForDescribe(181, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
        this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
    }

    @Override
    String getString(int currentRow) throws SQLException {
        boolean am;
        String regname;
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        int regionID = 0;
        this.getBytesInternal(currentRow, this.tmpBytes);
        if ((TimestamptzAccessor.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
            regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.oracleTZ1(this.tmpBytes));
            TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
            if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.oracleTZ2(this.tmpBytes)))) {
                tzTab.updateTable(this.statement.connection, regionID);
            }
            regname = ZONEIDMAP.getRegion(regionID);
        } else {
            int off_hour = TimestamptzAccessor.oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
            int off_minute = Math.abs(TimestamptzAccessor.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
            regname = "GMT" + (off_hour < 0 ? "" : "+") + off_hour + (off_minute < 10 ? ":0" : ":") + off_minute;
        }
        Calendar calUTC = (Calendar)this.statement.getGMTCalendar().clone();
        int year = TimestamptzAccessor.oracleYear(this.tmpBytes);
        calUTC.set(1, year);
        calUTC.set(2, TimestamptzAccessor.oracleMonth(this.tmpBytes));
        calUTC.set(5, TimestamptzAccessor.oracleDay(this.tmpBytes));
        calUTC.set(11, TimestamptzAccessor.oracleHour(this.tmpBytes));
        calUTC.set(12, TimestamptzAccessor.oracleMin(this.tmpBytes));
        calUTC.set(13, TimestamptzAccessor.oracleSec(this.tmpBytes));
        calUTC.set(14, 0);
        if ((TimestamptzAccessor.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
            TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
            int offset_gmt = tzTab.getOffset(calUTC, regionID);
            calUTC.add(14, offset_gmt);
        } else {
            calUTC.add(10, TimestamptzAccessor.oracleTZ1(this.tmpBytes) - OFFSET_HOUR);
            calUTC.add(12, TimestamptzAccessor.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
        }
        year = calUTC.get(1);
        int month = calUTC.get(2) + 1;
        int date = calUTC.get(5);
        int hour = calUTC.get(11);
        int min = calUTC.get(12);
        int sec = calUTC.get(13);
        boolean bl = am = hour < 12;
        if (regname.length() > 3 && regname.startsWith("GMT")) {
            regname = regname.substring(3);
        }
        int nanos = TimestamptzAccessor.oracleNanos(this.tmpBytes);
        return this.toText(year, month, date, hour, min, sec, nanos, am, regname);
    }

    @Override
    Date getDate(int currentRow) throws SQLException {
        return this.tstzConverter.getDate(currentRow);
    }

    @Override
    Date getDate(int currentRow, Calendar cal) throws SQLException {
        return this.getDate(currentRow);
    }

    @Override
    Time getTime(int currentRow) throws SQLException {
        return this.tstzConverter.getTime(currentRow);
    }

    @Override
    Time getTime(int currentRow, Calendar cal) throws SQLException {
        return this.getTime(currentRow);
    }

    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        return this.tstzConverter.getTimestamp(currentRow);
    }

    @Override
    Timestamp getTimestamp(int currentRow, Calendar cal) throws SQLException {
        return this.getTimestamp(currentRow);
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.tstzConverter.getObject(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.tstzConverter.getOracleObject(currentRow);
    }

    @Override
    DATE getDATE(int currentRow) throws SQLException {
        TIMESTAMPTZ tstz = this.tstzConverter.getTIMESTAMPTZ(currentRow);
        if (tstz == null) {
            return null;
        }
        return oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tstz.getBytes());
    }

    @Override
    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        TIMESTAMPTZ tstz = this.tstzConverter.getTIMESTAMPTZ(currentRow);
        if (tstz == null) {
            return null;
        }
        return oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tstz.getBytes());
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        return this.tstzConverter.getTIMESTAMPTZ(currentRow);
    }

    @Override
    Calendar getCalendar(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPTZ(this.getBytesInternal(currentRow)), Calendar.class, this.statement.connection, null, null);
    }

    @Override
    LocalDate getLocalDate(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPTZ(this.getBytesInternal(currentRow)), LocalDate.class, this.statement.connection, null, null);
    }

    @Override
    LocalDateTime getLocalDateTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPTZ(this.getBytesInternal(currentRow)), LocalDateTime.class, this.statement.connection, null, null);
    }

    @Override
    LocalTime getLocalTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPTZ(this.getBytesInternal(currentRow)), LocalTime.class, this.statement.connection, null, null);
    }

    @Override
    OffsetDateTime getOffsetDateTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPTZ(this.getBytesInternal(currentRow)), OffsetDateTime.class, this.statement.connection, null, null);
    }

    @Override
    OffsetTime getOffsetTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPTZ(this.getBytesInternal(currentRow)), OffsetTime.class, this.statement.connection, null, null);
    }

    @Override
    ZonedDateTime getZonedDateTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPTZ(this.getBytesInternal(currentRow)), ZonedDateTime.class, this.statement.connection, null, null);
    }

    static int setHighOrderbits(int ID) {
        return (ID & 0x1FC0) >> 6;
    }

    static int setLowOrderbits(int ID) {
        return (ID & 0x3F) << 2;
    }

    static int getHighOrderbits(int ID) {
        return (ID & 0x7F) << 6;
    }

    static int getLowOrderbits(int ID) {
        return (ID & 0xFC) >> 2;
    }

    abstract class TimestampTzConverter {
        TimestampTzConverter() {
        }

        abstract Date getDate(int var1) throws SQLException;

        abstract Time getTime(int var1) throws SQLException;

        abstract Timestamp getTimestamp(int var1) throws SQLException;

        Object getObject(int currentRow) throws SQLException {
            return this.getTIMESTAMPTZ(currentRow);
        }

        Datum getOracleObject(int currentRow) throws SQLException {
            return this.getTIMESTAMPTZ(currentRow);
        }

        Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
            return this.getTIMESTAMPTZ(currentRow);
        }

        abstract TIMESTAMPTZ getTIMESTAMPTZ(int var1) throws SQLException;
    }

    class GmtTimestampTzConverter
    extends TimestampTzConverter {
        GmtTimestampTzConverter() {
        }

        @Override
        Date getDate(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            Calendar calUTC = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = DateTimeCommonAccessor.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calUTC.set(1, year);
            calUTC.set(2, DateTimeCommonAccessor.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(5, DateTimeCommonAccessor.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(11, DateTimeCommonAccessor.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(12, DateTimeCommonAccessor.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(13, DateTimeCommonAccessor.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(14, 0);
            long millis = calUTC.getTimeInMillis();
            return new Date(millis);
        }

        @Override
        Time getTime(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            Calendar calUTC = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = DateTimeCommonAccessor.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calUTC.set(1, year);
            calUTC.set(2, DateTimeCommonAccessor.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(5, DateTimeCommonAccessor.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(11, DateTimeCommonAccessor.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(12, DateTimeCommonAccessor.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(13, DateTimeCommonAccessor.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(14, 0);
            return new Time(calUTC.getTimeInMillis());
        }

        @Override
        Timestamp getTimestamp(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            Calendar calUTC = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = DateTimeCommonAccessor.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calUTC.set(1, year);
            calUTC.set(2, DateTimeCommonAccessor.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(5, DateTimeCommonAccessor.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(11, DateTimeCommonAccessor.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(12, DateTimeCommonAccessor.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(13, DateTimeCommonAccessor.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(14, 0);
            long millis = calUTC.getTimeInMillis();
            Timestamp result = new Timestamp(millis);
            int nanos = DateTimeCommonAccessor.oracleNanos(TimestamptzAccessor.this.tmpBytes);
            result.setNanos(nanos);
            return result;
        }

        @Override
        TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            return new TIMESTAMPTZ(TimestamptzAccessor.this.getBytesInternal(currentRow));
        }
    }

    class OldTimestampTzConverter
    extends TimestampTzConverter {
        OldTimestampTzConverter() {
        }

        @Override
        Date getDate(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(zone);
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = DateTimeCommonAccessor.oracleYear(TimestamptzAccessor.this.tmpBytes);
            cal.set(1, year);
            cal.set(2, DateTimeCommonAccessor.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            cal.set(5, DateTimeCommonAccessor.oracleDay(TimestamptzAccessor.this.tmpBytes));
            cal.set(11, DateTimeCommonAccessor.oracleHour(TimestamptzAccessor.this.tmpBytes));
            cal.set(12, DateTimeCommonAccessor.oracleMin(TimestamptzAccessor.this.tmpBytes));
            cal.set(13, DateTimeCommonAccessor.oracleSec(TimestamptzAccessor.this.tmpBytes));
            cal.set(14, 0);
            if ((DateTimeCommonAccessor.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & REGIONIDBIT) != 0) {
                int regionID = TimestamptzAccessor.getHighOrderbits(DateTimeCommonAccessor.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
                TIMEZONETAB tzTab = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(DateTimeCommonAccessor.oracleTZ2(TimestamptzAccessor.this.tmpBytes)))) {
                    tzTab.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                }
                int offset = tzTab.getOffset(cal, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(10, offset / 3600000);
                cal.add(12, offset % 3600000 / 60000);
            } else {
                cal.add(10, DateTimeCommonAccessor.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - OFFSET_HOUR);
                cal.add(12, DateTimeCommonAccessor.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - OFFSET_MINUTE);
            }
            long millis = cal.getTimeInMillis();
            return new Date(millis);
        }

        @Override
        Time getTime(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(zone);
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = DateTimeCommonAccessor.oracleYear(TimestamptzAccessor.this.tmpBytes);
            cal.set(1, year);
            cal.set(2, DateTimeCommonAccessor.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            cal.set(5, DateTimeCommonAccessor.oracleDay(TimestamptzAccessor.this.tmpBytes));
            cal.set(11, DateTimeCommonAccessor.oracleHour(TimestamptzAccessor.this.tmpBytes));
            cal.set(12, DateTimeCommonAccessor.oracleMin(TimestamptzAccessor.this.tmpBytes));
            cal.set(13, DateTimeCommonAccessor.oracleSec(TimestamptzAccessor.this.tmpBytes));
            cal.set(14, 0);
            if ((DateTimeCommonAccessor.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & REGIONIDBIT) != 0) {
                int regionID = TimestamptzAccessor.getHighOrderbits(DateTimeCommonAccessor.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
                TIMEZONETAB tzTab = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(DateTimeCommonAccessor.oracleTZ2(TimestamptzAccessor.this.tmpBytes)))) {
                    tzTab.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                }
                int offset = tzTab.getOffset(cal, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(10, offset / 3600000);
                cal.add(12, offset % 3600000 / 60000);
            } else {
                cal.add(10, DateTimeCommonAccessor.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - OFFSET_HOUR);
                cal.add(12, DateTimeCommonAccessor.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - OFFSET_MINUTE);
            }
            long millis = cal.getTimeInMillis();
            return new Time(millis);
        }

        @Override
        Timestamp getTimestamp(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(zone);
            Calendar calUTC = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = DateTimeCommonAccessor.oracleYear(TimestamptzAccessor.this.tmpBytes);
            cal.set(1, year);
            cal.set(2, DateTimeCommonAccessor.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            cal.set(5, DateTimeCommonAccessor.oracleDay(TimestamptzAccessor.this.tmpBytes));
            cal.set(11, DateTimeCommonAccessor.oracleHour(TimestamptzAccessor.this.tmpBytes));
            cal.set(12, DateTimeCommonAccessor.oracleMin(TimestamptzAccessor.this.tmpBytes));
            cal.set(13, DateTimeCommonAccessor.oracleSec(TimestamptzAccessor.this.tmpBytes));
            cal.set(14, 0);
            calUTC.set(1, year);
            calUTC.set(2, DateTimeCommonAccessor.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(5, DateTimeCommonAccessor.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(11, DateTimeCommonAccessor.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(12, DateTimeCommonAccessor.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(13, DateTimeCommonAccessor.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(14, 0);
            if ((DateTimeCommonAccessor.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & REGIONIDBIT) != 0) {
                int regionID = TimestamptzAccessor.getHighOrderbits(DateTimeCommonAccessor.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
                TIMEZONETAB tzTab = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(DateTimeCommonAccessor.oracleTZ2(TimestamptzAccessor.this.tmpBytes)))) {
                    tzTab.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                }
                int offset = tzTab.getOffset(calUTC, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(10, offset / 3600000);
                cal.add(12, offset % 3600000 / 60000);
            } else {
                cal.add(10, DateTimeCommonAccessor.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - OFFSET_HOUR);
                cal.add(12, DateTimeCommonAccessor.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - OFFSET_MINUTE);
            }
            long millis = cal.getTimeInMillis();
            Timestamp result = new Timestamp(millis);
            int nanos = DateTimeCommonAccessor.oracleNanos(TimestamptzAccessor.this.tmpBytes);
            result.setNanos(nanos);
            return result;
        }

        @Override
        TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            return new TIMESTAMPTZ(TimestamptzAccessor.this.getBytesInternal(currentRow));
        }
    }
}

