/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.validation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.zjsonpatch.JsonDiff;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.validation.PasswordValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;

public class RequestContentValidator
implements ToXContent {
    public static final RequestContentValidator NOOP_VALIDATOR = new RequestContentValidator(new ValidationContext(){

        @Override
        public Object[] params() {
            return new Object[0];
        }

        @Override
        public Settings settings() {
            return Settings.EMPTY;
        }

        @Override
        public Map<String, DataType> allowedKeys() {
            return Collections.emptyMap();
        }
    }){

        @Override
        public ValidationResult<JsonNode> validate(RestRequest request) {
            return ValidationResult.success(DefaultObjectMapper.objectMapper.createObjectNode());
        }

        @Override
        public ValidationResult<JsonNode> validate(RestRequest request, JsonNode jsonNode) {
            return ValidationResult.success(DefaultObjectMapper.objectMapper.createObjectNode());
        }
    };
    public static final String INVALID_KEYS_KEY = "invalid_keys";
    public static final String MISSING_MANDATORY_KEYS_KEY = "missing_mandatory_keys";
    public static final String MISSING_MANDATORY_OR_KEYS_KEY = "specify_one_of";
    protected static final Logger LOGGER = LogManager.getLogger(RequestContentValidator.class);
    protected ValidationError validationError;
    protected final ValidationContext validationContext;
    protected final Map<String, String> wrongDataTypes = new HashMap<String, String>();
    private final Set<String> missingMandatoryKeys = new HashSet<String>();
    private final Set<String> invalidKeys = new HashSet<String>();
    private final Set<String> missingMandatoryOrKeys = new HashSet<String>();

    protected RequestContentValidator(ValidationContext validationContext) {
        this.validationError = ValidationError.NONE;
        this.validationContext = validationContext;
    }

    public ValidationResult<JsonNode> validate(RestRequest request) throws IOException {
        return this.parseRequestContent(request).map(this::validateContentSize).map(jsonContent -> this.validate(request, (JsonNode)jsonContent));
    }

    public ValidationResult<JsonNode> validate(RestRequest request, JsonNode jsonContent) throws IOException {
        return this.validateContentSize(jsonContent).map(this::validateJsonKeys).map(this::validateDataType).map(this::nullValuesInArrayValidator).map(ignored -> this.validatePassword(request, jsonContent));
    }

    public ValidationResult<JsonNode> validate(RestRequest request, JsonNode patchedContent, JsonNode originalContent) throws IOException {
        JsonNode patch = JsonDiff.asJson((JsonNode)originalContent, (JsonNode)patchedContent);
        if (patch.isEmpty()) {
            return ValidationResult.error(RestStatus.OK, Responses.payload(RestStatus.OK, "No updates required"));
        }
        return this.validateContentSize(patchedContent).map(this::validateJsonKeys).map(this::validateDataType).map(this::nullValuesInArrayValidator).map(ignored -> this.validatePassword(request, patchedContent));
    }

    private ValidationResult<JsonNode> parseRequestContent(RestRequest request) {
        try {
            JsonNode jsonContent = DefaultObjectMapper.readTree(request.content().utf8ToString());
            return ValidationResult.success(jsonContent);
        }
        catch (IOException ioe) {
            this.validationError = ValidationError.BODY_NOT_PARSEABLE;
            return ValidationResult.error(RestStatus.BAD_REQUEST, this);
        }
    }

    protected ValidationResult<JsonNode> validateContentSize(JsonNode jsonContent) {
        if (jsonContent.isEmpty()) {
            this.validationError = ValidationError.PAYLOAD_MANDATORY;
            return ValidationResult.error(RestStatus.BAD_REQUEST, this);
        }
        return ValidationResult.success(jsonContent);
    }

    protected ValidationResult<JsonNode> validateJsonKeys(JsonNode jsonContent) {
        HashSet requestedKeys = new HashSet();
        jsonContent.fieldNames().forEachRemaining(requestedKeys::add);
        if (Collections.disjoint(requestedKeys, this.validationContext.mandatoryOrKeys())) {
            this.missingMandatoryOrKeys.addAll(this.validationContext.mandatoryOrKeys());
        }
        HashSet<String> mandatory = new HashSet<String>(this.validationContext.mandatoryKeys());
        mandatory.removeAll(requestedKeys);
        this.missingMandatoryKeys.addAll(mandatory);
        HashSet<String> allowed = new HashSet<String>(this.validationContext.allowedKeys().keySet());
        requestedKeys.removeAll(allowed);
        this.invalidKeys.addAll(requestedKeys);
        if (!(this.missingMandatoryKeys.isEmpty() && this.invalidKeys.isEmpty() && this.missingMandatoryOrKeys.isEmpty())) {
            this.validationError = ValidationError.INVALID_CONFIGURATION;
            return ValidationResult.error(RestStatus.BAD_REQUEST, this);
        }
        return ValidationResult.success(jsonContent);
    }

    private ValidationResult<JsonNode> validateDataType(JsonNode jsonContent) {
        try (JsonParser parser = DefaultObjectMapper.objectMapper.treeAsTokens((TreeNode)jsonContent);){
            JsonToken token;
            while ((token = parser.nextToken()) != null) {
                if (!token.equals((Object)JsonToken.FIELD_NAME)) continue;
                String currentName = parser.getCurrentName();
                DataType dataType = this.validationContext.allowedKeys().get(currentName);
                if (dataType == null) continue;
                JsonToken valueToken = parser.nextToken();
                switch (dataType.ordinal()) {
                    case 3: {
                        if (valueToken == JsonToken.VALUE_NUMBER_INT) break;
                        this.wrongDataTypes.put(currentName, "Integer expected");
                        break;
                    }
                    case 0: {
                        if (valueToken == JsonToken.VALUE_STRING) break;
                        this.wrongDataTypes.put(currentName, "String expected");
                        break;
                    }
                    case 1: {
                        if (valueToken == JsonToken.START_ARRAY || valueToken == JsonToken.END_ARRAY) break;
                        this.wrongDataTypes.put(currentName, "Array expected");
                        break;
                    }
                    case 2: {
                        if (valueToken.equals((Object)JsonToken.START_OBJECT) || valueToken.equals((Object)JsonToken.END_OBJECT)) break;
                        this.wrongDataTypes.put(currentName, "Object expected");
                    }
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Couldn't create JSON for payload {}", (Object)jsonContent, (Object)ioe);
            this.validationError = ValidationError.BODY_NOT_PARSEABLE;
            return ValidationResult.error(RestStatus.BAD_REQUEST, this);
        }
        if (!this.wrongDataTypes.isEmpty()) {
            this.validationError = ValidationError.WRONG_DATATYPE;
            return ValidationResult.error(RestStatus.BAD_REQUEST, this);
        }
        return ValidationResult.success(jsonContent);
    }

    private ValidationResult<JsonNode> nullValuesInArrayValidator(JsonNode jsonContent) {
        for (Map.Entry<String, DataType> allowedKey : this.validationContext.allowedKeys().entrySet()) {
            JsonNode value = jsonContent.get(allowedKey.getKey());
            if (value == null || !this.hasNullArrayElement(value)) continue;
            this.validationError = ValidationError.NULL_ARRAY_ELEMENT;
            return ValidationResult.error(RestStatus.BAD_REQUEST, this);
        }
        return ValidationResult.success(jsonContent);
    }

    private boolean hasNullArrayElement(JsonNode node) {
        for (JsonNode element : node) {
            if (!(element.isNull() ? node.isArray() : element.isContainerNode() && this.hasNullArrayElement(element))) continue;
            return true;
        }
        return false;
    }

    private ValidationResult<JsonNode> validatePassword(RestRequest request, JsonNode jsonContent) {
        if (jsonContent.has("password")) {
            PasswordValidator passwordValidator = PasswordValidator.of(this.validationContext.settings());
            String password = jsonContent.get("password").asText();
            if (Strings.isNullOrEmpty((String)password)) {
                this.validationError = ValidationError.INVALID_PASSWORD_TOO_SHORT;
                return ValidationResult.error(RestStatus.BAD_REQUEST, this);
            }
            String username = Optional.ofNullable(request.param("name")).orElseGet(() -> this.validationContext.hasParams() ? (String)this.validationContext.params()[0] : null);
            if (Strings.isNullOrEmpty((String)username)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Unable to validate username because no user is given");
                }
                this.validationError = ValidationError.NO_USERNAME;
                return ValidationResult.error(RestStatus.BAD_REQUEST, this);
            }
            this.validationError = passwordValidator.validate(username, password);
            if (this.validationError != ValidationError.NONE) {
                return ValidationResult.error(RestStatus.BAD_REQUEST, this);
            }
        }
        return ValidationResult.success(jsonContent);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        switch (this.validationError.ordinal()) {
            case 1: {
                builder.field("status", "error");
                builder.field("reason", ValidationError.INVALID_CONFIGURATION.message());
                this.addErrorMessage(builder, INVALID_KEYS_KEY, this.invalidKeys);
                this.addErrorMessage(builder, MISSING_MANDATORY_KEYS_KEY, this.missingMandatoryKeys);
                this.addErrorMessage(builder, MISSING_MANDATORY_OR_KEYS_KEY, this.missingMandatoryOrKeys);
                break;
            }
            case 4: {
                builder.field("status", "error");
                builder.field("reason", this.validationContext.settings().get("plugins.security.restapi.password_validation_error_message", "Password does not match minimum criteria"));
                break;
            }
            case 8: {
                builder.field("status", "error");
                builder.field("reason", ValidationError.WRONG_DATATYPE.message());
                for (Map.Entry<String, String> entry : this.wrongDataTypes.entrySet()) {
                    builder.field(entry.getKey(), entry.getValue());
                }
                break;
            }
            default: {
                builder.field("status", "error");
                builder.field("reason", this.validationError.message());
            }
        }
        builder.endObject();
        return builder;
    }

    private void addErrorMessage(XContentBuilder builder, String message, Set<String> keys) throws IOException {
        if (!keys.isEmpty()) {
            builder.startObject(message).field("keys", String.join((CharSequence)",", keys)).endObject();
        }
    }

    public static RequestContentValidator of(final ValidationContext validationContext) {
        return new RequestContentValidator(new ValidationContext(){
            private final Object[] params;
            private final Set<String> mandatoryKeys;
            private final Set<String> mandatoryOrKeys;
            private final Map<String, DataType> allowedKeys;
            {
                this.params = validationContext.params();
                this.mandatoryKeys = validationContext.mandatoryKeys();
                this.mandatoryOrKeys = validationContext.mandatoryOrKeys();
                this.allowedKeys = validationContext.allowedKeys();
            }

            @Override
            public Settings settings() {
                return validationContext.settings();
            }

            @Override
            public Object[] params() {
                return this.params;
            }

            @Override
            public Set<String> mandatoryKeys() {
                return this.mandatoryKeys;
            }

            @Override
            public Set<String> mandatoryOrKeys() {
                return this.mandatoryOrKeys;
            }

            @Override
            public Map<String, DataType> allowedKeys() {
                return this.allowedKeys;
            }
        });
    }

    public static enum ValidationError {
        NONE("ok"),
        INVALID_CONFIGURATION("Invalid configuration"),
        INVALID_PASSWORD_TOO_SHORT("Password is too short"),
        INVALID_PASSWORD_TOO_LONG("Password is too long"),
        INVALID_PASSWORD_INVALID_REGEX("Password does not match validation regex"),
        NO_USERNAME("No username is given"),
        WEAK_PASSWORD("Weak password"),
        SIMILAR_PASSWORD("Password is similar to user name"),
        WRONG_DATATYPE("Wrong datatype"),
        BODY_NOT_PARSEABLE("Could not parse content of request."),
        PAYLOAD_NOT_ALLOWED("Request body not allowed for this action."),
        PAYLOAD_MANDATORY("Request body required for this action."),
        SECURITY_NOT_INITIALIZED("Security index not initialized"),
        NULL_ARRAY_ELEMENT("`null` is not allowed as json array element");

        private final String message;

        private ValidationError(String message) {
            this.message = message;
        }

        public String message() {
            return this.message;
        }
    }

    public static interface ValidationContext {
        default public boolean hasParams() {
            return this.params() != null && this.params().length > 0;
        }

        default public Set<String> mandatoryKeys() {
            return Collections.emptySet();
        }

        default public Set<String> mandatoryOrKeys() {
            return Collections.emptySet();
        }

        public Object[] params();

        public Settings settings();

        public Map<String, DataType> allowedKeys();
    }

    public static enum DataType {
        STRING,
        ARRAY,
        OBJECT,
        INTEGER,
        BOOLEAN;

    }
}

