/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.url;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.apache.aries.jndi.url.OsgiName;

public final class OsgiNameParser
implements NameParser {
    private static final String OSGI_SCHEME = "osgi";
    private static final String ARIES_SCHEME = "aries";
    private static final String SERVICE_PATH = "service";
    private static final String SERVICES_PATH = "services";
    private static final String SERVICE_LIST_PATH = "servicelist";
    private static final String FRAMEWORK_PATH = "framework";

    @Override
    public Name parse(String name) throws NamingException {
        OsgiName result = new OsgiName(name);
        String urlScheme = result.getScheme();
        String schemePath = result.getSchemePath();
        if (!OSGI_SCHEME.equals(urlScheme) && !ARIES_SCHEME.equals(urlScheme)) {
            throw new InvalidNameException(name);
        }
        if (ARIES_SCHEME.equals(urlScheme) && !SERVICES_PATH.equals(schemePath)) {
            throw new InvalidNameException(name);
        }
        if (OSGI_SCHEME.equals(urlScheme) && !SERVICE_PATH.equals(schemePath) && !SERVICE_LIST_PATH.equals(schemePath) && !FRAMEWORK_PATH.equals(schemePath)) {
            throw new InvalidNameException(name);
        }
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof OsgiNameParser;
    }

    public int hashCode() {
        return 100003;
    }
}

