/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.storage;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.opensearch.rule.storage.AttributeValueStore;

public class DefaultAttributeValueStore<K extends String, V>
implements AttributeValueStore<K, V> {
    private final PatriciaTrie<V> trie;
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
    private static final ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();

    public DefaultAttributeValueStore() {
        this(new PatriciaTrie());
    }

    public DefaultAttributeValueStore(PatriciaTrie<V> trie) {
        this.trie = trie;
    }

    @Override
    public void put(K key, V value) {
        writeLock.lock();
        try {
            this.trie.put(key, value);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void remove(String key) {
        writeLock.lock();
        try {
            this.trie.remove((Object)key);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<V> get(String key) {
        readLock.lock();
        try {
            String longestMatchingPrefix = this.findLongestMatchingPrefix(key);
            for (Map.Entry possibleMatch : this.trie.prefixMap((Object)longestMatchingPrefix).entrySet()) {
                if (!key.startsWith((String)possibleMatch.getKey())) continue;
                Optional optional = Optional.of(possibleMatch.getValue());
                return optional;
            }
        }
        finally {
            readLock.unlock();
        }
        return Optional.empty();
    }

    private String findLongestMatchingPrefix(String key) {
        int low = 0;
        int high = key.length() - 1;
        while (low < high) {
            int mid = (high + low + 1) / 2;
            if (!this.trie.prefixMap((Object)key.substring(0, mid)).isEmpty()) {
                low = mid;
                continue;
            }
            high = mid - 1;
        }
        return key.substring(0, low);
    }

    @Override
    public void clear() {
        writeLock.lock();
        try {
            this.trie.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.trie.size();
    }
}

