/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public abstract class AbstractMaintenanceModeAcknowledgeEventHandler
extends AbstractEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(AbstractMaintenanceModeAcknowledgeEventHandler.class);
    private final BundleContext bundleContext;
    private final String moduleId;

    public AbstractMaintenanceModeAcknowledgeEventHandler(BundleContext bundleContext, String moduleId) {
        this.bundleContext = bundleContext;
        this.moduleId = moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(Event event) {
        LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
        try {
            Boolean maintenanceModeEnabled = (Boolean)event.getProperty("enabled");
            LOGGER.info("maintenanceModeEnabled? " + maintenanceModeEnabled);
            this.processNewMaintenanceMode(maintenanceModeEnabled);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to process the maintenance mode changed event: " + String.valueOf(event), (Throwable)ex);
        }
        finally {
            try (BpcServicesTracker<EventManager> eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);){
                eventManagerTracker.getService().fireMaintenanceModeAcknowledgedEvent(this.moduleId, this.getClass().getName());
            }
            catch (Exception ex) {
                LOGGER.error("Failed to send the maintenance mode acknowledged event.", (Throwable)ex);
            }
        }
    }

    public abstract void processNewMaintenanceMode(boolean var1);
}

