/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.EventHandlerEvent;
import de.virtimo.bpc.util.MapUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.service.event.Event;

public abstract class AbstractRestoreBackupDoneEventHandler
extends AbstractEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(AbstractRestoreBackupDoneEventHandler.class);

    @Override
    protected void processEvent(Event event) {
        LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
        RestoreBackupDoneEvent restoreBackupDoneEvent = new RestoreBackupDoneEvent(event);
        this.processRestoreBackupDoneEvent(restoreBackupDoneEvent);
    }

    public abstract void processRestoreBackupDoneEvent(RestoreBackupDoneEvent var1);

    public static class RestoreBackupDoneEvent
    implements EventHandlerEvent {
        private final String snapshotName;
        private final List<String> aliasesOfBackupIndices;
        private final List<Map<String, Object>> summary;

        public RestoreBackupDoneEvent(String snapshotName, List<String> aliasesOfBackupIndices, List<Map<String, Object>> summary) {
            this.snapshotName = snapshotName;
            this.aliasesOfBackupIndices = aliasesOfBackupIndices;
            this.summary = summary;
        }

        public RestoreBackupDoneEvent(Event event) {
            this((String)event.getProperty("snapshot"), (List)event.getProperty("aliases"), (List)event.getProperty("summary"));
        }

        @Override
        public Map<String, Object> asMap() {
            return MapUtil.mapOf("snapshot", this.snapshotName, "aliases", this.aliasesOfBackupIndices, "summary", this.summary);
        }

        public String getSnapshotName() {
            return this.snapshotName;
        }

        public List<String> getAliasesOfBackupIndices() {
            return this.aliasesOfBackupIndices;
        }

        public boolean containsAlias(String aliasOfBackupIndex) {
            return this.aliasesOfBackupIndices.contains(aliasOfBackupIndex);
        }

        public boolean containsOneOfTheAliases(Set<String> aliases) {
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!this.aliasesOfBackupIndices.contains(alias)) continue;
                    return true;
                }
            }
            return false;
        }

        public List<Map<String, Object>> getSummary() {
            return this.summary;
        }
    }
}

