/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.EventHandlerEvent;
import de.virtimo.bpc.util.MapUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.service.event.Event;

public abstract class AbstractRestoreBackupStartEventHandler
extends AbstractEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(AbstractRestoreBackupStartEventHandler.class);

    @Override
    protected void processEvent(Event event) {
        LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
        RestoreBackupStartEvent restoreBackupStartEvent = new RestoreBackupStartEvent(event);
        this.processRestoreBackupStartEvent(restoreBackupStartEvent);
    }

    public abstract void processRestoreBackupStartEvent(RestoreBackupStartEvent var1);

    public static class RestoreBackupStartEvent
    implements EventHandlerEvent {
        private final String snapshotName;
        private final List<String> aliasesOfBackupIndices;
        private final List<String> backupIndexNames;

        public RestoreBackupStartEvent(String snapshotName, List<String> aliasesOfBackupIndices, List<String> backupIndexNames) {
            this.snapshotName = snapshotName;
            this.aliasesOfBackupIndices = aliasesOfBackupIndices;
            this.backupIndexNames = backupIndexNames;
        }

        public RestoreBackupStartEvent(Event event) {
            this((String)event.getProperty("snapshot"), (List)event.getProperty("aliases"), (List)event.getProperty("indices"));
        }

        @Override
        public Map<String, Object> asMap() {
            return MapUtil.mapOf("snapshot", this.snapshotName, "aliases", this.aliasesOfBackupIndices, "indices", this.backupIndexNames);
        }

        public String getSnapshotName() {
            return this.snapshotName;
        }

        public List<String> getAliasesOfBackupIndices() {
            return this.aliasesOfBackupIndices;
        }

        public boolean containsAlias(String aliasOfBackupIndex) {
            return this.aliasesOfBackupIndices.contains(aliasOfBackupIndex);
        }

        public boolean containsOneOfTheAliases(Set<String> aliases) {
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!this.aliasesOfBackupIndices.contains(alias)) continue;
                    return true;
                }
            }
            return false;
        }

        public List<String> getBackupIndexNames() {
            return this.backupIndexNames;
        }
    }
}

