/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public interface BpcService {
    public static final Logger LOGGER = LogManager.getLogger(BpcService.class);

    public BundleContext getBundleContext();

    public void shutdownService();

    public static void unregister(BundleContext bundleContext, ServiceRegistration<?> serviceRegistration, Class serviceClazz) {
        if (serviceRegistration != null) {
            LOGGER.info("{}: Unregistering the '{}' service ...", (Object)bundleContext.getBundle().getSymbolicName(), (Object)serviceClazz.getSimpleName());
            long startTS = System.currentTimeMillis();
            try {
                ServiceReference serviceReference = serviceRegistration.getReference();
                Object service = bundleContext.getService(serviceReference);
                if (service instanceof BpcService) {
                    ((BpcService)service).shutdownService();
                }
                bundleContext.ungetService(serviceReference);
                serviceRegistration.unregister();
                LOGGER.info("{}: Unregistered the '{}' service in {} ms", (Object)bundleContext.getBundle().getSymbolicName(), (Object)serviceClazz.getSimpleName(), (Object)(System.currentTimeMillis() - startTS));
            }
            catch (Exception ex) {
                LOGGER.error("{}: Failed to unregister the '{}' service.", (Object)bundleContext.getBundle().getSymbolicName(), (Object)serviceClazz.getSimpleName(), (Object)ex);
            }
        }
    }
}

