/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class BpcServicesTracker<T>
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(BpcServicesTracker.class);
    private final BundleContext bundleContext;
    private final Class<T> typeParameterClass;
    private final String filter;
    private ServiceTracker serviceTracker;
    private T _service;

    public static void stopAll(Object from) {
        if (from != null) {
            BpcServicesTracker.stopAll(from, from.getClass());
        }
    }

    public static void stopAll(Object from, Class<?> clazz) {
        if (from != null && clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(from);
                    if (!(fieldValue instanceof BpcServicesTracker)) continue;
                    BpcServicesTracker bpcServicesTracker = (BpcServicesTracker)fieldValue;
                    bpcServicesTracker.stop();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to stop the BPC service tracker: {} ({})", (Object)field, from);
                }
            }
        }
    }

    public BpcServicesTracker(BundleContext bundleContext, Class<T> typeParameterClass, String filter) {
        LOGGER.debug("BpcServicesTracker bundleContext={}, typeParameterClass={}, filter={}", (Object)bundleContext, typeParameterClass, (Object)filter);
        this.bundleContext = bundleContext;
        this.typeParameterClass = typeParameterClass;
        this.filter = filter;
        this.start();
    }

    public BpcServicesTracker(BundleContext bundleContext, Class<T> typeParameterClass) {
        this(bundleContext, typeParameterClass, null);
    }

    public void start() {
        LOGGER.debug("{}: start", (Object)this.typeParameterClass.getName());
        if (this.serviceTracker == null) {
            this.serviceTracker = this.createServiceTracker(this.bundleContext);
            this.serviceTracker.open();
        }
    }

    public boolean isStopped() {
        LOGGER.debug("{}: isStopped", (Object)this.typeParameterClass.getName());
        return this.serviceTracker == null;
    }

    public void stop() {
        LOGGER.debug("{}: stop", (Object)this.typeParameterClass.getName());
        if (this.serviceTracker != null) {
            try {
                this.serviceTracker.close();
            }
            catch (RuntimeException ex) {
                LOGGER.error("{}: Could not close the service tracker", (Object)this.typeParameterClass.getName());
            }
            finally {
                this.serviceTracker = null;
            }
        }
    }

    @Override
    public void close() {
        LOGGER.debug("{}: close", (Object)this.typeParameterClass.getName());
        this.stop();
    }

    private ServiceTracker createServiceTracker(BundleContext bundleContext) {
        String listenerFilter = "(objectClass=" + this.typeParameterClass.getName() + ")";
        if (this.filter != null && this.filter.length() > 0) {
            listenerFilter = "(&" + listenerFilter + "(" + this.filter + "))";
        }
        try {
            Filter serviceFilter = bundleContext.createFilter(listenerFilter);
            return new ServiceTracker(bundleContext, serviceFilter, null){

                public Object addingService(ServiceReference reference) {
                    Object service = this.context.getService(reference);
                    BpcServicesTracker.this._service = service;
                    return service;
                }

                public void removedService(ServiceReference reference, Object service) {
                    BpcServicesTracker.this._service = null;
                    this.context.ungetService(reference);
                }
            };
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    @NotNull
    public T getService() throws ServiceNotFoundException {
        return this.getService(30L);
    }

    @NotNull
    public T getService(long timeoutInSeconds) throws ServiceNotFoundException {
        if (this._service == null) {
            ServiceTracker localServiceTracker = this.serviceTracker;
            if (localServiceTracker == null) {
                throw new ServiceNotFoundException(this.typeParameterClass);
            }
            try {
                this._service = localServiceTracker.waitForService(timeoutInSeconds * 1000L);
            }
            catch (InterruptedException e) {
                throw new ServiceNotFoundException(this.typeParameterClass);
            }
        }
        if (this._service == null) {
            throw new ServiceNotFoundException(this.typeParameterClass);
        }
        return this._service;
    }
}

