/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public interface Checker {
    public static final Logger LOGGER = LogManager.getLogger(Checker.class);

    public void startChecker();

    public void stopChecker();

    public static void stop(Checker checker) {
        if (checker != null) {
            Bundle checkerBundle = FrameworkUtil.getBundle(checker.getClass());
            LOGGER.info("{}: Stopping the {}", (Object)checkerBundle.getSymbolicName(), (Object)checker.getClass().getSimpleName());
            long startTS = System.currentTimeMillis();
            try {
                checker.stopChecker();
                LOGGER.info("{}: Stopped the {} in {} ms", (Object)checkerBundle.getSymbolicName(), (Object)checker.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - startTS));
            }
            catch (Exception ex) {
                LOGGER.error("{}: Failed to stop the {}", (Object)checkerBundle.getSymbolicName(), (Object)checker.getClass().getSimpleName(), (Object)ex);
            }
        }
    }
}

