/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler;
import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.AbstractRestoreBackupStartEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.util.MapUtil;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;

public class EventRegistration {
    private static final Logger LOGGER = LogManager.getLogger(EventRegistration.class);
    private BundleContext bundleContext;
    private final List<ServiceRegistration<EventHandler>> registeredEventHandlers;

    public EventRegistration(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.registeredEventHandlers = new ArrayList<ServiceRegistration<EventHandler>>();
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.unregisterAllEventHandler();
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllEventHandler() {
        LOGGER.info("unregisterAllEventHandler");
        try {
            for (ServiceRegistration<EventHandler> eventHandlerServiceRegistration : this.registeredEventHandlers) {
                try {
                    EventManager.unregisterEventHandler(eventHandlerServiceRegistration);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to unregister the event handler: " + String.valueOf(eventHandlerServiceRegistration), (Throwable)ex);
                }
            }
        }
        finally {
            this.registeredEventHandlers.clear();
        }
    }

    private void register(AbstractEventHandler eventHandler, Map<String, ?> properties) {
        if (this.bundleContext == null) {
            LOGGER.warn("Failed to register the given EventHandler due to missing BundleContext. Maybe a unit test?");
            return;
        }
        this.registeredEventHandlers.add((ServiceRegistration<EventHandler>)this.bundleContext.registerService(EventHandler.class, (Object)eventHandler, this.mapToDictionary(properties)));
    }

    private <K, V> Dictionary<K, V> mapToDictionary(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return new Hashtable<K, V>(map);
    }

    public void forEventTopic(String eventTopic, AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{eventTopic}));
    }

    public void forAllBpcEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/*"}));
    }

    public void forModuleUpdatedEvents(String moduleId, AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/Configuration/moduleUpdated"}, "event.filter", "(&(moduleId=" + moduleId + ")(moduleInstanceId=noinstance))"));
    }

    public void forModuleUpdatedEvents(String moduleId, String settingName, AbstractSettingUpdatedEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/Configuration/moduleUpdated"}, "event.filter", "(&(moduleId=" + moduleId + ")(moduleInstanceId=noinstance)(settingName=" + settingName + "))"));
    }

    public void forModuleInstanceCreatedEvents(String moduleId, String instanceType, AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/Configuration/moduleInstanceCreated"}, "event.filter", "(&(moduleId=" + moduleId + ")(!(moduleInstanceId=noinstance))(moduleInstanceType=" + instanceType + "))"));
    }

    public void forModuleInstanceUpdatedEvents(String moduleId, String instanceType, AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/Configuration/moduleUpdated"}, "event.filter", "(&(moduleId=" + moduleId + ")(!(moduleInstanceId=noinstance))(moduleInstanceType=" + instanceType + "))"));
    }

    public void forModuleInstanceDeletedEvents(String moduleId, String instanceType, AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/Configuration/moduleDeleted"}, "event.filter", "(&(moduleId=" + moduleId + ")(!(moduleInstanceId=noinstance))(moduleInstanceType=" + instanceType + "))"));
    }

    public void forAnyBackendModuleLoadedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/backendModuleLoaded"}));
    }

    public void forAnyBackendModuleUnloadedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/backendModuleUnloaded"}));
    }

    public void forAnyBackendModuleReloadedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/backendModuleReloaded"}));
    }

    public void forBackendModuleLoadedEvents(String moduleId, AbstractBackendModuleLoadedEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/backendModuleLoaded"}, "event.filter", "(moduleId=" + moduleId + ")"));
    }

    public void forBackendModuleLoadedAndAutoCreateModuleInstancesDoneEvents(String moduleId, AbstractBackendModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/backendModuleLoadedAndAutoCreateModuleInstancesDone"}, "event.filter", "(moduleId=" + moduleId + ")"));
    }

    public void forBackendModuleUnloadedEvents(String moduleId, AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/backendModuleUnloaded"}, "event.filter", "(moduleId=" + moduleId + ")"));
    }

    public void forBackendModuleReloadedEvents(String moduleId, AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/backendModuleReloaded"}, "event.filter", "(moduleId=" + moduleId + ")"));
    }

    public void forLicenseChangedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/licenseChanged"}));
    }

    public void forLicenseExpiredEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/licenseExpired"}));
    }

    public void forOpenSearchPluginEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/os-bpc-plugin"}));
    }

    public void forOpenSearchPluginWebsocketConnectedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/os-bpc-plugin"}, "event.filter", "(WebsocketState=" + String.valueOf((Object)OpenSearchBpcPluginManager.WebsocketState.CONNECTED) + ")"));
    }

    public void forOpenSearchPluginWebsocketDisconnectedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/os-bpc-plugin"}, "event.filter", "(|(WebsocketState=" + String.valueOf((Object)OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED) + ")(WebsocketState=" + String.valueOf((Object)OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED_DUE_TO_ERROR) + "))"));
    }

    public void forRestoreBackupStartEvents(AbstractRestoreBackupStartEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/backup/restore/start"}));
    }

    public void forRestoreBackupDoneEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/backup/restore/done"}));
    }

    public void forForceLocalIdentityProviderEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/forceLocalIdentityProvider"}));
    }

    public void forMaintenanceModeConfigPropertyChangedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/maintenanceMode/configPropertyUpdated"}));
    }

    public void forMaintenanceModeAcknowledgeEvents(AbstractMaintenanceModeAcknowledgeEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/maintenanceMode/acknowledge"}));
    }

    public void forMaintenanceModeAcknowledgedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/maintenanceMode/acknowledged"}));
    }

    public void forNotificationAddedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/notification/notificationAdded"}));
    }

    public void forNotificationUpdatedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/notification/notificationUpdated"}));
    }

    public void forNotificationDeletedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/notification/notificationDeleted"}));
    }

    public void forUserSessionAddedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/auth/sessionAdded"}));
    }

    public void forUserSessionRemovedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/auth/sessionRemoved"}));
    }

    public void forServerModeChangedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/serverModeChanged"}));
    }

    public void forServerUuidUpdatedEvents(AbstractEventHandler eventHandler) {
        this.register(eventHandler, MapUtil.mapOf("event.topics", new String[]{"de/virtimo/bpc/core/serverUUID/configPropertyUpdated"}));
    }

    public void forClientEvents(AbstractEventHandler eventHandler, String eventName) {
        if (eventName == null) {
            eventName = "*";
        }
        this.register(eventHandler, MapUtil.mapOf("event.topics", "de/virtimo/bpc/client/" + eventName));
    }
}

