/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch;

import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.Map;
import java.util.Objects;

public class ManagedIndexConfig {
    private final String aliasName;
    private final boolean createOnStart;
    private final boolean hidden;
    private final Map<String, Object> settings;
    private final Map<String, Object> mappings;

    public ManagedIndexConfig(String aliasName, boolean createOnStart, boolean hidden, Map<String, Object> settings, Map<String, Object> mappings) {
        Objects.requireNonNull(aliasName, "aliasName must not be null");
        this.aliasName = aliasName;
        this.createOnStart = createOnStart;
        this.hidden = hidden;
        this.settings = settings;
        this.mappings = mappings;
    }

    public ManagedIndexConfig(Map<String, Object> managedIndexConfig) {
        this(MapUtil.getValueAsString(managedIndexConfig, "name", null), MapUtil.getValueAsBoolean(managedIndexConfig, "create_on_start", true), MapUtil.getValueAsBoolean(managedIndexConfig, "hidden", false), MapUtil.getValueAsMap(managedIndexConfig, "settings", null), MapUtil.getValueAsMap(managedIndexConfig, "mappings", null));
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public boolean hasAliasName() {
        return !StringUtil.isNullOrEmpty(this.aliasName);
    }

    public boolean canBeUsedForExactAliasName(String indexAliasName) {
        return this.aliasName != null && this.aliasName.equalsIgnoreCase(indexAliasName);
    }

    public boolean canBeUsedMatchingWildcard(String indexAliasName) {
        if (indexAliasName != null && this.aliasName != null && this.aliasName.endsWith("-*") && !indexAliasName.equals(this.aliasName)) {
            String prefix = this.aliasName.substring(0, this.aliasName.length() - 1);
            return indexAliasName.startsWith(prefix) && !indexAliasName.equalsIgnoreCase(prefix);
        }
        return false;
    }

    public boolean isCreateOnStart() {
        return this.createOnStart;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean hasSettings() {
        return this.settings != null && !this.settings.isEmpty();
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public boolean hasMappings() {
        return this.mappings != null && !this.mappings.isEmpty();
    }

    public Map<String, Object> getMappings() {
        return this.mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedIndexConfig that = (ManagedIndexConfig)o;
        return this.createOnStart == that.createOnStart && this.hidden == that.hidden && Objects.equals(this.aliasName, that.aliasName) && Objects.equals(this.settings, that.settings) && Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.aliasName);
    }

    public String toString() {
        return "ManagedIndexConfig{aliasName='" + this.aliasName + "', createOnStart=" + this.createOnStart + ", hidden=" + this.hidden + ", settings=" + String.valueOf(this.settings) + ", mappings=" + String.valueOf(this.mappings) + "}";
    }
}

