/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.security;

import de.virtimo.bpc.api.security.Check;
import de.virtimo.bpc.api.security.CheckResultBuilder;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCheck
implements Check {
    private static final Logger LOGGER = LogManager.getLogger(AbstractCheck.class);

    @Override
    public float getWeight() {
        return 1.0f;
    }

    @Override
    public int getMaximumScore() {
        return 1;
    }

    protected CheckResultBuilder getCheckResultBuilderFromInterimResults(List<InterimResult> interimResults) {
        Objects.requireNonNull(interimResults, "Interim results cannot be null");
        if (interimResults.isEmpty()) {
            throw new IllegalArgumentException("Interim results cannot be empty");
        }
        int points = this.calculatePoints(interimResults);
        String detailMessage = this.buildDetailMessage(interimResults);
        return new CheckResultBuilder().withCheckId(this.getIdentifier()).withPoints(points).withDetailMessage(detailMessage);
    }

    private int calculatePoints(List<InterimResult> interimResults) {
        int points = interimResults.stream().mapToInt(InterimResult::points).sum();
        return Math.max(0, points);
    }

    private String buildDetailMessage(List<InterimResult> interimResults) {
        StringBuilder message = new StringBuilder();
        for (InterimResult result : interimResults) {
            if (result.message() == null || result.message().isEmpty()) continue;
            message.append(result.message()).append(" (").append(this.formatPoints(result.points())).append(")\n");
        }
        return message.toString();
    }

    private String formatPoints(int points) {
        return String.format("%+d", points);
    }

    public record InterimResult(int points, String message) {
    }
}

