/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.security;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.security.AbstractCheck;
import de.virtimo.bpc.api.security.CheckResultStorageService;
import de.virtimo.bpc.util.DictionaryUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public abstract class AbstractCheckBpcService
extends AbstractCheck
implements BpcService {
    private final ServiceRegistration<ConfigurationListener> securityCheckConfigurationListenerRegistration;
    protected final BpcServicesTracker<CheckResultStorageService> checkResultStorageServiceTracker;
    protected final BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker;
    protected final EventRegistration eventRegistration;
    protected BundleContext bundleContext;

    public AbstractCheckBpcService(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.securityCheckConfigurationListenerRegistration = bundleContext.registerService(ConfigurationListener.class, (Object)new ConfigurationListenerImpl(this), null);
        this.checkResultStorageServiceTracker = new BpcServicesTracker<CheckResultStorageService>(bundleContext, CheckResultStorageService.class);
        this.configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class);
        this.eventRegistration = new EventRegistration(bundleContext);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        BpcServicesTracker.stopAll(this);
        BpcService.unregister(this.bundleContext, this.securityCheckConfigurationListenerRegistration, ConfigurationListener.class);
        this.eventRegistration.unregisterAllEventHandler();
    }

    public void modified(Map<String, Object> properties) {
        LOGGER.debug("Configuration modified");
    }

    public Map<String, Object> getProperties() {
        Map<String, Object> properties;
        try {
            properties = Optional.ofNullable(this.configurationAdminTracker.getService().getConfiguration("de.virtimo.bpc.core.security.checks")).map(c -> c.getProcessedProperties(null)).map(DictionaryUtil::convertToMap).orElse(Collections.emptyMap());
        }
        catch (Exception e) {
            LOGGER.error("Error while reading Check config properties", (Throwable)e);
            return Collections.emptyMap();
        }
        return properties;
    }

    public static class ConfigurationListenerImpl
    implements ConfigurationListener {
        private final AbstractCheckBpcService check;

        public ConfigurationListenerImpl(AbstractCheckBpcService check) {
            this.check = check;
        }

        public void configurationEvent(ConfigurationEvent configurationEvent) {
            BpcService.LOGGER.debug("configurationEvent: {}", (Object)configurationEvent);
            if (configurationEvent.getType() == 1 && "de.virtimo.bpc.core.security.checks".equals(configurationEvent.getPid())) {
                this.check.modified(this.check.getProperties());
            }
        }
    }
}

