/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.security;

import de.virtimo.bpc.api.security.CheckResult;
import de.virtimo.bpc.api.security.CheckResultImpl;
import de.virtimo.bpc.util.StringUtil;
import java.util.Date;
import java.util.List;

public class CheckResultBuilder {
    private String checkId;
    private int points;
    private Date timestamp;
    private String detailMessage;
    private String checkResultId;
    private List<String> tags;

    public CheckResultBuilder withCheckId(String checkId) {
        this.checkId = checkId;
        return this;
    }

    public CheckResultBuilder withPoints(int points) {
        this.points = points;
        return this;
    }

    public CheckResultBuilder withTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public CheckResultBuilder withDetailMessage(String detailMessage) {
        this.detailMessage = detailMessage;
        return this;
    }

    public CheckResultBuilder withCheckResultId(String checkResultId) {
        this.checkResultId = checkResultId;
        return this;
    }

    public CheckResultBuilder withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CheckResult build() {
        if (this.timestamp == null) {
            this.timestamp = new Date();
        }
        if (StringUtil.isNullOrEmpty(this.checkResultId)) {
            throw new IllegalStateException("CheckResultBuilder requires a check result identifier.");
        }
        if (StringUtil.isNullOrEmpty(this.checkId)) {
            throw new IllegalStateException("CheckResultBuilder requires a check identifier.");
        }
        return new CheckResultImpl(this.checkId, this.points, this.timestamp, this.detailMessage, this.checkResultId, this.tags);
    }
}

