/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.storage;

import de.virtimo.bpc.api.storage.StoreItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class StoreItems
implements Iterable<StoreItem> {
    private final String storeId;
    private final Integer start;
    private final Integer limit;
    private final List<StoreItem> items;

    public StoreItems(String storeId, Integer start, Integer limit) {
        this.storeId = storeId;
        this.start = start;
        this.limit = limit;
        this.items = new ArrayList<StoreItem>();
    }

    public String getStoreId() {
        return this.storeId;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public long size() {
        return this.items.size();
    }

    public List<StoreItem> getItems() {
        return this.items;
    }

    public StoreItem get(int index) {
        return this.items.get(index);
    }

    public void add(StoreItem storeItem) {
        this.items.add(storeItem);
    }

    @Override
    @NotNull
    public Iterator<StoreItem> iterator() {
        return this.items.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreItems that = (StoreItems)o;
        return Objects.equals(this.storeId, that.storeId) && Objects.equals(this.start, that.start) && Objects.equals(this.limit, that.limit) && Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hash(this.storeId, this.start, this.limit, this.items);
    }

    public String toString() {
        return "StoreItems{storeId='" + this.storeId + "', start=" + this.start + ", limit=" + this.limit + ", items=" + String.valueOf(this.items) + "}";
    }
}

