/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.AbstractBundleBasedConfiguration;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.service.EventManagerImpl;
import de.virtimo.bpc.util.BoolUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.UUIDGenerator;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class CoreBundleConfigurationImpl
extends AbstractBundleBasedConfiguration
implements CoreBundleConfiguration,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(CoreBundleConfiguration.class);
    private static final String CORE_CONFIGURATION_KARAF_UUID = "de.virtimo.bpc.core.karaf.uuid";
    private static final String CORE_CONFIGURATION_CORE_NAME = "de.virtimo.bpc.core.name";
    private static final String CORE_CONFIGURATION_CORE_VERSION = "de.virtimo.bpc.core.version";
    public static final String CORE_CONFIGURATION_MAINTENANCE_MODE_ENABLED = "de.virtimo.bpc.core.maintenancemode";
    private static final String CORE_CONFIGURATION_MAINTENANCE_MODE_FILE_SYSTEM_LIMIT_IN_MB = "de.virtimo.bpc.core.maintenancemode.fileSystemLimitInMB";
    private static final String CORE_CONFIGURATION_MAINTENANCE_MODE_MESSAGE = "de.virtimo.bpc.core.maintenancemode.message";
    private static final String CORE_CONFIGURATION_FORCE_LOCAL_IDENTITY_PROVIDER = "de.virtimo.bpc.core.forceLocalIdentityProvider";
    private static final String CORE_CONFIGURATION_COOKIE_SECURE = "de.virtimo.bpc.core.cookieSecure";
    private static final String CORE_CONFIGURATION_COOKIE_NAME = "de.virtimo.bpc.core.cookieName";
    public static final String CORE_CONFIGURATION_COOKIE_NAME_DEFAULT_VALUE = "BPC_J_S";
    public static final String CORE_CONFIGURATION_IP_PINNING_CHECK = "de.virtimo.bpc.core.ipPinningCheck";
    private static final String CORE_CONFIGURATION_IP_PINNING_CHECK_HTTP_HEADER = "de.virtimo.bpc.core.ipPinningCheck.httpHeader";
    public static final String CORE_CONFIGURATION_IP_PINNING_CHECK_HTTP_HEADER_DEFAULT_VALUE = "X-Forwarded-For";
    private static final String CORE_CONFIGURATION_AVAILABLE_FOR_REPLICATION_ENABLED = "de.virtimo.bpc.core.availableForReplication";
    private static final String CORE_CONFIGURATION_OPENSEARCH_BACKUP_REPOSITORY_CLEANUP_CRON_PATTERN = "de.virtimo.bpc.core.opensearch.backupRepository.cleanupCronPattern";
    private static final String CORE_CONFIGURATION_OPENAPI_ENABLED = "de.virtimo.bpc.core.openapi.enabled";
    public static final String CORE_CONFIGURATION_PID = "de.virtimo.bpc.core";
    private final Configuration configuration;
    private final Properties defaultProperties;
    private Dictionary<String, Object> currentProperties;
    private final ServiceRegistration<ConfigurationListener> coreConfigurationListenerRegistration;
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker;

    public CoreBundleConfigurationImpl(BundleContext bundleContext) throws ServiceNotFoundException, IOException {
        this.bundleContext = bundleContext;
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class);
        this.configuration = this.configurationAdminTracker.getService().getConfiguration(CORE_CONFIGURATION_PID, null);
        this.defaultProperties = this.loadResourceProperties("bundle.properties");
        CoreBundleConfigurationImpl.keepKarafPropertiesFileUpToDate(this.configuration, this.defaultProperties);
        this.currentProperties = this.configuration.getProperties();
        this.coreConfigurationListenerRegistration = bundleContext.registerService(ConfigurationListener.class, (Object)new CoreConfigurationListener(bundleContext), null);
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
    }

    private static void keepKarafPropertiesFileUpToDate(Configuration configuration, Properties bundleProperties) throws IOException {
        Object value;
        LOGGER.info("keepKarafPropertiesFileUpToDate configuration=..., propertiesFromBundle=...");
        Hashtable<String, String> storedProps = configuration.getProperties();
        if (storedProps == null) {
            storedProps = new Hashtable<String, String>();
        } else {
            Enumeration keys = ((Dictionary)storedProps).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key == null || (value = ((Dictionary)storedProps).get(key)) == null || value instanceof String) continue;
                ((Dictionary)storedProps).put(key, String.valueOf(value));
            }
        }
        for (String key : bundleProperties.stringPropertyNames()) {
            value = bundleProperties.getProperty(key);
            LOGGER.info("Read Property: {} = {}", (Object)key, value);
            if (((Dictionary)storedProps).get(key) != null) continue;
            ((Dictionary)storedProps).put(key, (String)value);
        }
        ((Dictionary)storedProps).put(CORE_CONFIGURATION_CORE_VERSION, bundleProperties.getProperty(CORE_CONFIGURATION_CORE_VERSION));
        if (((Dictionary)storedProps).get(CORE_CONFIGURATION_KARAF_UUID) == null) {
            ((Dictionary)storedProps).put(CORE_CONFIGURATION_KARAF_UUID, UUID.randomUUID().toString());
        }
        if (((Dictionary)storedProps).get("de.virtimo.bpc.metrics.basic_auth.username") == null) {
            ((Dictionary)storedProps).put("de.virtimo.bpc.metrics.basic_auth.username", "virtimo");
        }
        if (((Dictionary)storedProps).get("de.virtimo.bpc.metrics.basic_auth.password") == null) {
            ((Dictionary)storedProps).put("de.virtimo.bpc.metrics.basic_auth.password", UUIDGenerator.randomUUID());
        }
        configuration.update(storedProps);
        LOGGER.info("Properties: {}", storedProps);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
        BpcService.unregister(this.bundleContext, this.coreConfigurationListenerRegistration, ConfigurationListener.class);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public String getServerUUID() {
        return this.getSystemPropertyValueAsString(CORE_CONFIGURATION_KARAF_UUID, null);
    }

    @Override
    public String getBpcName() {
        return this.getSystemPropertyValueAsString(CORE_CONFIGURATION_CORE_NAME, "BPC");
    }

    @Override
    public String getCoreVersion() {
        return this.getSystemPropertyValueAsString(CORE_CONFIGURATION_CORE_VERSION, null);
    }

    @Override
    public boolean isMaintenanceModeEnabled() {
        return this.getUnprocessedSystemPropertyValueAsBoolean(CORE_CONFIGURATION_MAINTENANCE_MODE_ENABLED, false);
    }

    @Override
    public void setMaintenanceModeEnabled(boolean enabled) throws IOException {
        this.setSystemPropertyValue(CORE_CONFIGURATION_MAINTENANCE_MODE_ENABLED, enabled);
    }

    @Override
    public void setMaintenanceModeEnabled(boolean enabled, String message) throws IOException {
        if (message != null) {
            this.setSystemPropertyValue(CORE_CONFIGURATION_MAINTENANCE_MODE_MESSAGE, message);
        }
        this.setSystemPropertyValue(CORE_CONFIGURATION_MAINTENANCE_MODE_ENABLED, enabled);
    }

    @Override
    public String getMaintenanceModeMessage() {
        return this.getUnprocessedSystemPropertyValueAsString(CORE_CONFIGURATION_MAINTENANCE_MODE_MESSAGE, null);
    }

    @Override
    public long getMaintenanceModeFileSystemLimitInMB() {
        return this.getSystemPropertyValueAsLong(CORE_CONFIGURATION_MAINTENANCE_MODE_FILE_SYSTEM_LIMIT_IN_MB, 10240L);
    }

    @Override
    public boolean isForceLocalIdentityProviderEnabled() {
        return this.getUnprocessedSystemPropertyValueAsBoolean(CORE_CONFIGURATION_FORCE_LOCAL_IDENTITY_PROVIDER, false);
    }

    @Override
    public void setForceLocalIdentityProviderEnabled(boolean enabled) throws IOException {
        this.setSystemPropertyValue(CORE_CONFIGURATION_FORCE_LOCAL_IDENTITY_PROVIDER, enabled);
    }

    @Override
    public int getSystemCheckerIntervalInSeconds() {
        return this.getSystemPropertyValueAsInt("de.virtimo.bpc.core.systemchecker.interval", 30);
    }

    @Override
    public boolean isSecureCookieFlagSet() {
        return this.getSystemPropertyValueAsBoolean(CORE_CONFIGURATION_COOKIE_SECURE, Boolean.FALSE);
    }

    @Override
    public String getCookieName() {
        return this.getSystemPropertyValueAsString(CORE_CONFIGURATION_COOKIE_NAME, CORE_CONFIGURATION_COOKIE_NAME_DEFAULT_VALUE);
    }

    @Override
    public boolean isIpPinningCheckEnabled() {
        return this.getSystemPropertyValueAsBoolean(CORE_CONFIGURATION_IP_PINNING_CHECK, Boolean.TRUE);
    }

    @Override
    public String getIpPinningCheckHttpHeaderName() {
        return this.getSystemPropertyValueAsString(CORE_CONFIGURATION_IP_PINNING_CHECK_HTTP_HEADER, CORE_CONFIGURATION_IP_PINNING_CHECK_HTTP_HEADER_DEFAULT_VALUE);
    }

    @Override
    public boolean isAvailableForReplicationEnabled() {
        return this.getSystemPropertyValueAsBoolean(CORE_CONFIGURATION_AVAILABLE_FOR_REPLICATION_ENABLED, Boolean.TRUE);
    }

    @Override
    public String getOpenSearchBackupRepositoryCleanupCronPattern() {
        return this.getSystemPropertyValueAsString(CORE_CONFIGURATION_OPENSEARCH_BACKUP_REPOSITORY_CLEANUP_CRON_PATTERN, "0 30 9 L * ?");
    }

    @Override
    public Map<String, String> getKeyValueMap() {
        return Map.of(CORE_CONFIGURATION_KARAF_UUID, this.getServerUUID(), CORE_CONFIGURATION_CORE_NAME, this.getBpcName(), CORE_CONFIGURATION_CORE_VERSION, this.getCoreVersion(), CORE_CONFIGURATION_COOKIE_NAME, this.getCookieName(), CORE_CONFIGURATION_AVAILABLE_FOR_REPLICATION_ENABLED, Boolean.toString(this.isAvailableForReplicationEnabled()), CORE_CONFIGURATION_FORCE_LOCAL_IDENTITY_PROVIDER, Boolean.toString(this.isForceLocalIdentityProviderEnabled()));
    }

    public class CoreConfigurationListener
    implements ConfigurationListener {
        private final BundleContext bundleContext;

        public CoreConfigurationListener(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
        }

        private boolean isEnabled(Object booleanObject) {
            return BoolUtil.getBoolean(booleanObject, Boolean.FALSE);
        }

        public void configurationEvent(ConfigurationEvent configurationEvent) {
            LOGGER.info("configurationEvent: {}", (Object)configurationEvent);
            try {
                if (configurationEvent.getType() == 1) {
                    LOGGER.info("Configuration update event for PID: {}", (Object)configurationEvent.getPid());
                    if (CoreBundleConfigurationImpl.CORE_CONFIGURATION_PID.equals(configurationEvent.getPid())) {
                        CoreBundleConfigurationImpl.this.clearCaches();
                        this.processUpdatedBpcCoreConfigurationFile(configurationEvent);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Could not get the updated core configuration.", (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processUpdatedBpcCoreConfigurationFile(ConfigurationEvent configurationEvent) throws IOException {
            block5: {
                LOGGER.debug("processUpdatedBpcCoreConfigurationFile configurationEvent={}", (Object)configurationEvent);
                ServiceReference configurationAdminReference = configurationEvent.getReference();
                ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(configurationAdminReference);
                try {
                    Configuration configuration = configurationAdmin.getConfiguration(configurationEvent.getPid());
                    if (configuration == null) break block5;
                    Dictionary updatedProperties = configuration.getProperties();
                    LOGGER.info("Updated core properties: {}", (Object)updatedProperties);
                    if (updatedProperties == null) break block5;
                    try {
                        EventManager eventManager = CoreBundleConfigurationImpl.this.eventManagerTracker.getService();
                        this.checkForUpdatedMaintenanceMode(eventManager, updatedProperties);
                        this.checkForUpdatedForceLocalIdentityProvider(eventManager, updatedProperties);
                        this.checkForUpdateServerUUID(eventManager, updatedProperties);
                        this.checkForUpdatedOpenapiConfig(eventManager, updatedProperties);
                    }
                    catch (ModuleNotFoundException | ServiceNotFoundException ex) {
                        LOGGER.error("Failed to process an configuration event due to missing service.", (Throwable)ex);
                    }
                    CoreBundleConfigurationImpl.this.currentProperties = updatedProperties;
                }
                finally {
                    this.bundleContext.ungetService(configurationAdminReference);
                }
            }
        }

        private void checkForUpdatedMaintenanceMode(EventManager eventManager, Dictionary<String, Object> updatedProperties) throws ModuleNotFoundException {
            Object previousMaintenanceMode = CoreBundleConfigurationImpl.this.currentProperties.get(CoreBundleConfigurationImpl.CORE_CONFIGURATION_MAINTENANCE_MODE_ENABLED);
            Object updatedMaintenanceMode = updatedProperties.get(CoreBundleConfigurationImpl.CORE_CONFIGURATION_MAINTENANCE_MODE_ENABLED);
            Boolean enabled = this.isEnabled(previousMaintenanceMode) && !this.isEnabled(updatedMaintenanceMode) ? Boolean.FALSE : (!this.isEnabled(previousMaintenanceMode) && this.isEnabled(updatedMaintenanceMode) ? Boolean.TRUE : null);
            if (enabled != null) {
                SystemAuditLog.info("MaintenanceMode", "Maintenance mode configuration setting updated: [karaf]/etc/de.virtimo.bpc.core.cfg", previousMaintenanceMode, updatedMaintenanceMode);
                eventManager.fireEvent("de/virtimo/bpc/core/maintenanceMode/configPropertyUpdated", "enabled", enabled);
            }
        }

        private void checkForUpdatedForceLocalIdentityProvider(EventManager eventManager, Dictionary<String, Object> updatedProperties) {
            Object previousForceLocalIdentityProvider = CoreBundleConfigurationImpl.this.currentProperties.get(CoreBundleConfigurationImpl.CORE_CONFIGURATION_FORCE_LOCAL_IDENTITY_PROVIDER);
            Object updatedForceLocalIdentityProvider = updatedProperties.get(CoreBundleConfigurationImpl.CORE_CONFIGURATION_FORCE_LOCAL_IDENTITY_PROVIDER);
            Boolean enabled = this.isEnabled(previousForceLocalIdentityProvider) && !this.isEnabled(updatedForceLocalIdentityProvider) ? Boolean.FALSE : (!this.isEnabled(previousForceLocalIdentityProvider) && this.isEnabled(updatedForceLocalIdentityProvider) ? Boolean.TRUE : null);
            if (enabled != null) {
                SystemAuditLog.info("ForceLocalIdentityProvider", "Force local identity provider configuration setting updated: [karaf]/etc/de.virtimo.bpc.core.cfg", previousForceLocalIdentityProvider, updatedForceLocalIdentityProvider);
                eventManager.fireEvent("de/virtimo/bpc/core/forceLocalIdentityProvider", "enabled", enabled);
            }
        }

        private void checkForUpdateServerUUID(EventManager eventManager, Dictionary<String, Object> updatedProperties) {
            Object updatedServerUUID;
            Object previousServerUUID = CoreBundleConfigurationImpl.this.currentProperties.get(CoreBundleConfigurationImpl.CORE_CONFIGURATION_KARAF_UUID);
            if (!Objects.equals(previousServerUUID, updatedServerUUID = updatedProperties.get(CoreBundleConfigurationImpl.CORE_CONFIGURATION_KARAF_UUID))) {
                if (eventManager instanceof EventManagerImpl) {
                    ((EventManagerImpl)eventManager).setServerUUID(String.valueOf(updatedServerUUID));
                }
                SystemAuditLog.info("ServerUUID", "Server UUID updated: [karaf]/etc/de.virtimo.bpc.core.cfg", previousServerUUID, updatedServerUUID);
                eventManager.fireEvent("de/virtimo/bpc/core/serverUUID/configPropertyUpdated", MapUtil.mapOf("old", previousServerUUID, "new", updatedServerUUID));
            }
        }

        private void checkForUpdatedOpenapiConfig(EventManager eventManager, Dictionary<String, Object> updatedProperties) {
            Object previousOpenApiEnabled = CoreBundleConfigurationImpl.this.currentProperties.get(CoreBundleConfigurationImpl.CORE_CONFIGURATION_OPENAPI_ENABLED);
            Object updatedOpenApiEnabled = updatedProperties.get(CoreBundleConfigurationImpl.CORE_CONFIGURATION_OPENAPI_ENABLED);
            Boolean enabled = this.isEnabled(previousOpenApiEnabled) && !this.isEnabled(updatedOpenApiEnabled) ? Boolean.FALSE : (!this.isEnabled(previousOpenApiEnabled) && this.isEnabled(updatedOpenApiEnabled) ? Boolean.TRUE : null);
            if (enabled != null) {
                SystemAuditLog.info("OpenAPI Enabling", "OpenAPI enabled configuration setting updated: [karaf]/etc/de.virtimo.bpc.core.cfg", previousOpenApiEnabled, updatedOpenApiEnabled);
                try {
                    CoreModule coreModule = CoreBundleConfigurationImpl.this.getCoreModule();
                    coreModule.restartCoreBundle();
                }
                catch (ModuleNotFoundException | ServiceNotFoundException e) {
                    LOGGER.error("Failed to load CoreModule - cannot restart Bundle to change OpenApi enabling/disabling.", (Throwable)e);
                }
            }
        }
    }
}

