/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler;
import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.AbstractServerModeChangedEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.AbstractSettingsUpdatedEventHandler;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.PaxJdbcConfigurationUpdatedInfo;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerPlaceholder;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.backendconnections.BackendConnections;
import de.virtimo.bpc.core.SettingsImpl;
import de.virtimo.bpc.core.SystemChecker;
import de.virtimo.bpc.core.apikey.APIKeys;
import de.virtimo.bpc.core.apikey.APIKeysChecker;
import de.virtimo.bpc.core.auth.IdentityProviderChecker;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.UnsupportedIdentityProviderOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.idp.IdentityProviderWithUnsupportedOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.jaas.JaasProvider;
import de.virtimo.bpc.core.auth.keycloak.KeycloakIdentityProvider;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.core.db.DataSourceSettings;
import de.virtimo.bpc.core.exception.TimestampedException;
import de.virtimo.bpc.core.license.License;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.core.opensearch.ModuleManagerImpl;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.message.SetAsMasterServerWebsocketMessage;
import de.virtimo.bpc.util.ListUtil;
import de.virtimo.bpc.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.ws.rs.core.HttpHeaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class CoreModule
implements Module,
PropertyChangeListener {
    private static final Logger LOGGER = LogManager.getLogger(CoreModule.class);
    public static final String MODULE_ID = "_core";
    public static final String MODULE_NAME = "Core Services";
    public static final String SETTING_REST_BASE_URL = "baseUrl";
    public static final String SETTING_REST_MODULE_URL = "moduleUrl";
    public static final String SETTING_MODULE_NAME = "module_name";
    public static final String SETTING_MODULE_ICON_CLASS = "module_iconCls";
    public static final String SETTING_MODULE_RESTRICTED_ACCESS = "module_restrictInstanceAccess";
    public static final String SETTING_MODULE_FORCE_LOAD = "moduleForceLoad";
    public static final String SETTING_MODULEHEADER_ENABLED = "moduleHeader_enabled";
    public static final String SETTING_MODULEHEADER_DESCRIPTION = "moduleHeader_description";
    public static final String SETTING_LICENCED_MODULES = "licencedModules";
    public static final String SETTING_LICENSE_NOTIFICATIONS = "licenseNotifications";
    public static final String SETTING_THEME_NAME = "theme_name";
    public static final String AVAILABLE_THEMES = "themes_available";
    public static final String SETTING_LOGIN_SHOWTENANT = "login_showTenant";
    public static final String SETTING_LOGIN_TENANT = "login_tenantDefaultValue";
    public static final String SETTING_LOGIN_WELCOMEMSG = "login_welcomeMsg";
    public static final String SETTING_LOGIN_TITLE = "login_title";
    public static final String SETTING_LOGIN_SHOW_PW_RESET = "login_showReset";
    public static final String SETTING_WELCOMENOTIFICATION = "welcomeNotification";
    public static final String SETTING_BROWSER_TITLE = "browser_title";
    public static final String SETTING_BROWSER_FAV_ICON = "gui_favIcon";
    public static final String SETTING_LOGIN_DEFAULTLANGUAGE = "login_defaultLanguage";
    public static final String SETTING_LOGIN_SHOWLANGUAGESELECTOR = "login_showLanguageSelector";
    public static final String SETTING_LOGIN_REDIRECT_URL = "login_redirectUrl";
    public static final String SETTING_CLIENT_PATH = "clientPath";
    public static final String SETTING_CLIENT_PATH_DEFAULT_VALUE = "/";
    public static final String SETTING_CUSTOM_TRANSLATIONS = "customTranslations";
    public static final String SETTING_DEPLOYMENT = "deployment";
    public static final String SETTING_TRANSLATIONS_FALLBACK_LANGUAGE = "translationsFallbackLanguage";
    public static final String SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION = "identityProviderBackendConnection";
    public static final String SETTING_BPC_BASE_URL = "bpcBaseUrl";
    public static final String SETTING_BPC_BASE_URL_DEFAULT_VALUE = "http://localhost:8181";
    public static final String SETTING_INDEX_CREATION_SETTINGS = "indexCreationSettings";
    public static final String SETTING_INDEX_TEMPLATES = "indexTemplates";
    public static final String SETTING_INDEX_DYNAMIC_TEMPLATES = "indexDynamicTemplates";
    public static final String INDEX_TEMPLATES_NAME_PREFIX = "bpc:";
    public static final String SETTING_BPC_CONFIGURATION_BACKUP_ON_CHANGES = "bpcConfigurationBackup_onChanges";
    public static final String SETTING_BACKUP_JOBS = "backupJobs";
    public static final String SETTING_BACKUP_REPOSITORY = "backupRepository";
    public static final String SETTING_COOKIE_BANNER_TEXT = "cookie_bannerText";
    public static final String SETTING_COOKIE_SHOW_BANNER = "cookie_showBanner";
    public static final String SETTING_MANDATORY_ROLE_TO_ACCESS_BPC = "mandatoryRoleToAccessBPC";
    public static final String CSRF_TOKEN_NAME = "X-Csrf-Token";
    public static final String CORE_CONFIGURATION_ENCRYPTION_KEY = "de.virtimo.bpc.core.encryption.key";
    public static final String DEFAULT_ENCRYPTION_KEY = "virtimo_berlin";
    public static final String EVENT_PROPERTY_NAME_BROADCAST_OPENSEARCH_WEBSOCKET_MESSAGE = "BroadcastMessage";
    public static final String EVENT_PROPERTY_NAME_INDEX_OPERATION = "IndexOperation";
    public static final String EVENT_PROPERTY_NAME_INDEX_DELETED = "IndexDeleted";
    public static final String EVENT_PROPERTY_NAME_SET_AS_MASTER_SERVER = "SetAsMasterServer";
    public static final String EVENT_PROPERTY_NAME_START_REPLICATION_JOB_ACTION = "StartReplicationJobAction";
    public static final String EVENT_PROPERTY_NAME_STOP_REPLICATION_JOB_ACTION = "StopReplicationJobAction";
    public static final String EVENT_PROPERTY_NAME_FORCED_START_OF_REPLICATION_JOB_ACTION = "ForcedStartOfReplicationJobAction";
    public static final String EVENT_PROPERTY_NAME_RESTART_OF_REPLICATION_JOB_ACTION = "RestartOfReplicationJobAction";
    public static final String EVENT_PROPERTY_NAME_REFRESH_LOOKUPJOINS_OF_REPLICATION_JOB_ACTION = "RefreshLookupJoinsOfReplicationJobAction";
    public static final String EVENT_PROPERTY_NAME_REFRESH_LOOKUPJOINS_OF_ALL_REPLICATION_JOBS_ACTION = "RefreshLookupJoinsOfAllReplicationJobsAction";
    public static final String EVENT_PROPERTY_NAME_CLEAR_LOOKUPJOIN_CACHES_OF_REPLICATION_JOBS_ACTION = "ClearLookupJoinCachesOfReplicationJobsAction";
    public static final String EVENT_PROPERTY_NAME_GET_REPLICATION_JOB_STATS_ACTION = "GetReplicationJobStatsAction";
    public static final String EVENT_PROPERTY_NAME_MANUAL_START_OF_TAILSYNC_ACTION = "ManualStartOfTailsyncAction";
    public static final String EVENT_PROPERTY_NAME_GET_BACKUP_JOB_INFOS_ACTION = "GetBackupJobInfosAction";
    public static final String EVENT_PROPERTY_NAME_DELETE_BACKUP_JOB_ACTION = "DeleteBackupJobAction";
    public static final String EVENT_PROPERTY_NAME_START_BACKUP_JOB_ACTION = "StartBackupJobAction";
    public static final String EVENT_PROPERTY_NAME_SCHEDULE_BACKUP_JOB_ACTION = "ScheduleBackupJobAction";
    private final BundleContext bundleContext;
    private Bundle moduleBundle;
    private ModuleConfiguration moduleConfiguration;
    private IdentityProvider identityProvider;
    private ModuleManager moduleManager;
    private List<TimestampedException> lastOccurredExceptions;
    private String uuidOfMasterServer;
    private final BpcServicesTracker<LookupJoinsManager> lookupJoinsManagerTracker;
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final BpcServicesTracker<BackupManager> backupManagerTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<LicenseService> licenseServiceTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private final BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker;
    private final EventRegistration eventRegistration;
    private CountDownLatch maintenanceModeLatch;
    private static final Object IDENTITY_PROVIDER_LOCK = new Object();
    private IdentityProviderChecker identityProviderChecker;
    private APIKeysChecker apiKeysChecker;
    private SystemChecker systemChecker;

    public CoreModule(ModuleManager moduleManager, Bundle moduleBundle) {
        LOGGER.info("CoreModule");
        this.moduleManager = moduleManager;
        this.moduleBundle = moduleBundle;
        this.moduleConfiguration = this.getDefaultConfiguration();
        this.bundleContext = moduleBundle.getBundleContext();
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(this.bundleContext, LicenseService.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
        this.lookupJoinsManagerTracker = new BpcServicesTracker<LookupJoinsManager>(this.bundleContext, LookupJoinsManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(this.bundleContext, DatabaseManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(this.bundleContext, BackupManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(this.bundleContext, ConfigurationAdmin.class);
        this.eventRegistration = new EventRegistration(this.bundleContext);
        this.eventRegistration.forMaintenanceModeConfigPropertyChangedEvents(new MaintenanceModeConfigPropertyChangedEventHandler());
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents(new MaintenanceModeAcknowlegeEventHandler(this.bundleContext));
        this.eventRegistration.forMaintenanceModeAcknowledgedEvents(new MaintenanceModeAcknowledgedEventHandler());
        this.eventRegistration.forForceLocalIdentityProviderEvents(new ForceLocalIdentityProviderEventHandler());
        this.eventRegistration.forOpenSearchPluginWebsocketConnectedEvents(new OpenSearchBpcPluginWebsocketConnectedEventHandler());
        this.eventRegistration.forOpenSearchPluginWebsocketDisconnectedEvents(new OpenSearchBpcPluginWebsocketDisconnectedEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new OpenSearchBpcPluginSetAsMasterOrSlaveClusterMessageEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new OpenSearchBpcPluginIndexOperationEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new OpenSearchBpcPluginBroadcastWebsocketMessageEventHandler());
        this.eventRegistration.forModuleInstanceUpdatedEvents("backendconnection", "data_source", new DataSourceUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceDeletedEvents("backendconnection", "data_source", new DataSourceDeletedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents(MODULE_ID, SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION, new IdentityProviderBackendConnectionUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceUpdatedEvents("backendconnection", "identity_provider", new IdentityProviderUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceDeletedEvents("backendconnection", "identity_provider", new IdentityProviderDeletedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents(MODULE_ID, SETTING_LICENCED_MODULES, new LicensedModulesSettingUpdatedEventHandler());
        this.eventRegistration.forBackendModuleLoadedAndAutoCreateModuleInstancesDoneEvents("backendconnection", new BackendConnectionsModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler());
        this.eventRegistration.forLicenseChangedEvents(new LicenseChangedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents(MODULE_ID, new FrontendUrlRelatedSettingsUpdatedEventHandler());
        this.eventRegistration.forBackendModuleLoadedEvents(MODULE_ID, new CoreModuleLoadedEventHandler());
        this.eventRegistration.forClientEvents(new ChatEventHandler(), "chat");
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        Checker.stop(this.identityProviderChecker);
        Checker.stop(this.apiKeysChecker);
        Checker.stop(this.systemChecker);
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
        if (this.identityProvider != null) {
            this.identityProvider.destroy();
        }
        if (this.moduleConfiguration != null) {
            this.moduleConfiguration.removePropertyChangeListener(this);
            this.moduleConfiguration.destroy();
            this.moduleConfiguration = null;
        }
        this.moduleManager = null;
    }

    public boolean isMasterAndSlaveServerAlreadyDefined() {
        return this.uuidOfMasterServer != null;
    }

    public boolean isAlreadySetAsUuidOfMasterServer(String serverUUID) {
        return this.uuidOfMasterServer != null && this.uuidOfMasterServer.equals(serverUUID);
    }

    public void setUuidOfMasterServer(String uuidOfMasterServer) {
        this.uuidOfMasterServer = uuidOfMasterServer;
    }

    public boolean isMasterServer() {
        try {
            String thisServerUUID = this.coreBundleConfigurationTracker.getService().getServerUUID();
            return this.uuidOfMasterServer != null && this.uuidOfMasterServer.equals(thisServerUUID);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Failed to check if this server is the master due to missing service. When it does not have the server than it is also not the master server.", (Throwable)ex);
            return false;
        }
    }

    @Override
    public Bundle getModuleBundle() {
        return this.moduleBundle;
    }

    @Override
    public void setModuleBundle(Bundle moduleBundle) {
        this.moduleBundle = moduleBundle;
    }

    public boolean isForceLocalIdentityProviderEnabled() {
        LOGGER.debug("isForceLocalIdentityProviderEnabled");
        try {
            return this.coreBundleConfigurationTracker.getService().isForceLocalIdentityProviderEnabled();
        }
        catch (Throwable ex) {
            LOGGER.error("Could not get the core configuration to read the force local identity provider value.", ex);
            return Boolean.FALSE;
        }
    }

    public boolean isMaintenanceModeEnabled() {
        LOGGER.debug("isMaintenanceModeEnabled");
        try {
            return this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled();
        }
        catch (Throwable ex) {
            LOGGER.error("Could not get the core bundle configuration to read the maintenance mode status.", ex);
            return Boolean.FALSE;
        }
    }

    public boolean isMaintenanceModeUpdateAlreadyRunning() {
        return this.maintenanceModeLatch != null;
    }

    private int getNumberOfModulesSupportingMaintenanceMode() {
        LOGGER.info("getNumberOfModulesSupportingMaintenanceMode");
        int result = 0;
        try {
            BundleContext bundleContext = this.getModuleBundle().getBundleContext();
            Collection sr = bundleContext.getServiceReferences(EventHandler.class, "(event.topics=de/virtimo/bpc/core/maintenanceMode/acknowledge)");
            if (sr != null) {
                for (ServiceReference serviceReference : sr) {
                    ++result;
                    EventHandler maintenanceModeHandler = (EventHandler)bundleContext.getService(serviceReference);
                    LOGGER.info("Found maintenance mode handler: {}", (Object)maintenanceModeHandler);
                    bundleContext.ungetService(serviceReference);
                }
            } else {
                LOGGER.error("Hey BPC developer, there is an error in your get service references filter (CoreModule.getNumberOfModulesSupportingMaintenanceMode)! ;-)");
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the number of modules supporting the maintenance mode", (Throwable)ex);
            result = 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enableMaintenanceMode(boolean writeToConfigIsNecessary) {
        LOGGER.info("enableMaintenanceMode writeToConfigIsNecessary={}", (Object)writeToConfigIsNecessary);
        if (this.maintenanceModeLatch != null) {
            LOGGER.info("Nothing to do. Still waiting for modules to accept the maintenance mode status update!");
            return;
        }
        if (writeToConfigIsNecessary && this.isMaintenanceModeEnabled()) {
            LOGGER.info("Nothing to do. The maintenance mode is already enabled!");
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        try {
            int numberOfModulesSupportingMaintenanceMode = this.getNumberOfModulesSupportingMaintenanceMode();
            this.maintenanceModeLatch = new CountDownLatch(numberOfModulesSupportingMaintenanceMode);
            if (writeToConfigIsNecessary) {
                this.coreBundleConfigurationTracker.getService().setMaintenanceModeEnabled(true);
            }
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/maintenanceMode/acknowledge", "enabled", Boolean.TRUE);
            try {
                LOGGER.info("Maintenance mode enabled ... now waiting for {} acknowledgement events", (Object)numberOfModulesSupportingMaintenanceMode);
                this.maintenanceModeLatch.await(60L, TimeUnit.SECONDS);
                LOGGER.info("Maintenance mode enabled ... waited {} ms for all acknowledgements", (Object)(System.currentTimeMillis() - startTimeMillis));
                this.maintenanceModeLatch = null;
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                this.maintenanceModeLatch = null;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not enable the maintenance mode.", (Throwable)ex);
            return;
        }
        finally {
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/maintenanceMode", "enabled", this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled());
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("Failed to inform the frontends about the maintenance mode state.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disableMaintenanceMode(boolean writeToConfigIsNecessary) {
        LOGGER.info("disableMaintenanceMode writeToConfigIsNecessary={}", (Object)writeToConfigIsNecessary);
        if (this.maintenanceModeLatch != null) {
            LOGGER.info("Nothing to do. Still waiting for modules to accept the maintenance mode status update!");
            return;
        }
        if (writeToConfigIsNecessary && !this.isMaintenanceModeEnabled()) {
            LOGGER.info("Nothing to do. The maintenance mode is not enabled!");
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        try {
            int numberOfModulesSupportingMaintenanceMode = this.getNumberOfModulesSupportingMaintenanceMode();
            this.maintenanceModeLatch = new CountDownLatch(numberOfModulesSupportingMaintenanceMode);
            if (writeToConfigIsNecessary) {
                this.coreBundleConfigurationTracker.getService().setMaintenanceModeEnabled(false);
            }
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/maintenanceMode/acknowledge", "enabled", Boolean.FALSE);
            try {
                LOGGER.info("Maintenance mode disabled ... now waiting for {} acknowledgement events", (Object)numberOfModulesSupportingMaintenanceMode);
                this.maintenanceModeLatch.await(60L, TimeUnit.SECONDS);
                LOGGER.info("Maintenance mode disabled ... waited {} ms for all acknowledgements", (Object)(System.currentTimeMillis() - startTimeMillis));
                this.maintenanceModeLatch = null;
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                this.maintenanceModeLatch = null;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not disable the maintenance mode.", (Throwable)ex);
            return;
        }
        finally {
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/maintenanceMode", "enabled", this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled());
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("Failed to inform the frontends about the maintenance mode state.", (Throwable)ex);
            }
        }
    }

    public long getMaintenanceModeFileSystemLimitInMB() throws ServiceNotFoundException {
        LOGGER.info("getMaintenanceModeFileSystemLimitInMB");
        return this.coreBundleConfigurationTracker.getService().getMaintenanceModeFileSystemLimitInMB();
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        LOGGER.info("getDefaultConfiguration");
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/core/default_module_settings.json").build();
    }

    @Override
    public String getModuleId() {
        return MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public void setConfiguration(ModuleConfiguration moduleConfiguration) {
        LOGGER.info("setConfiguration");
        ModuleConfiguration oldModuleConfiguration = this.moduleConfiguration;
        if (oldModuleConfiguration != null) {
            oldModuleConfiguration.removePropertyChangeListener(this);
        }
        moduleConfiguration.addPropertyChangeListener(this);
        this.moduleConfiguration = moduleConfiguration;
        this.refreshDataSources();
        this.refreshOpenSearchIndexTemplates(moduleConfiguration);
        this.updateLicenseSettingToPreventManipulation();
    }

    @Override
    public ModuleConfiguration getConfiguration() {
        LOGGER.debug("getConfiguration");
        return this.moduleConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityProvider getIdentityProvider() {
        LOGGER.debug("getIdentityProvider");
        Object object = IDENTITY_PROVIDER_LOCK;
        synchronized (object) {
            return this.identityProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityManager getIdentityManager() {
        LOGGER.debug("getIdentityManager");
        Object object = IDENTITY_PROVIDER_LOCK;
        synchronized (object) {
            if (this.identityProvider instanceof IdentityManager) {
                return (IdentityManager)((Object)this.identityProvider);
            }
            return IdentityManagerPlaceholder.getInstance();
        }
    }

    @Override
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Setting setting;
        Object newValue;
        LOGGER.info("Got a property change event: {}", (Object)evt);
        if (evt.getSource() instanceof ModuleConfiguration && "apiKeys".equalsIgnoreCase(evt.getPropertyName()) && (newValue = evt.getNewValue()) instanceof Setting && APIKeys.fixApiKeyIDs(setting = (Setting)newValue)) {
            try {
                this.getConfiguration().updateSetting(setting);
            }
            catch (SettingException ex) {
                LOGGER.error("Failed to fix/adjust the IDs of API keys.", (Throwable)ex);
            }
        }
    }

    public List<TimestampedException> getLastOccurredExceptions() {
        return this.lastOccurredExceptions;
    }

    private synchronized void keepAsLastOccurredException(TimestampedException timestampedException) {
        LOGGER.info("keepAsLastOccurredException timestampedException=...");
        if (this.lastOccurredExceptions == null) {
            this.lastOccurredExceptions = new ArrayList<TimestampedException>();
        }
        this.lastOccurredExceptions.add(timestampedException);
        while (this.lastOccurredExceptions.size() >= 12) {
            this.lastOccurredExceptions.remove(0);
        }
    }

    private void refreshDataSources() {
        LOGGER.info("refreshDataSources");
        try {
            List<Map<String, Object>> paxJdbcDataSourceConfigurations = DataSourceSettings.getAllPaxJdbcDataSourceConfigurations(this.moduleManager);
            PaxJdbcConfigurationUpdatedInfo configUpdatedInfo = this.databaseManagerTracker.getService().createOrUpdateDataSourcesByUsingPaxJdbcConfigurations(paxJdbcDataSourceConfigurations);
            LOGGER.info("refreshDataSources result: {}", (Object)configUpdatedInfo);
        }
        catch (Exception ex) {
            LOGGER.error("Database sources processing failed.", (Throwable)ex);
            this.keepAsLastOccurredException(new TimestampedException(ex));
        }
    }

    private void refreshOpenSearchIndexTemplates(ModuleConfiguration moduleConfiguration) {
        LOGGER.info("refreshOpenSearchTemplates moduleConfiguration=...");
        try {
            Setting indexTemplatesSetting = moduleConfiguration.getSetting(SETTING_INDEX_TEMPLATES);
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            oss.refreshOpenSearchIndexTemplates(indexTemplatesSetting);
        }
        catch (Exception ex) {
            LOGGER.error("OpenSearch templates refreshing failed.", (Throwable)ex);
            this.keepAsLastOccurredException(new TimestampedException(ex));
        }
    }

    public static IdentityProviderConfiguration getCurrentIdentityProviderConfiguration(BundleContext bundleContext) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        try (BpcServicesTracker<ModuleManager> moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);){
            CoreModule coreModule = (CoreModule)moduleManagerTracker.getService().getModuleById(MODULE_ID);
            IdentityProviderConfiguration identityProviderConfiguration = coreModule.getCurrentIdentityProviderConfiguration();
            return identityProviderConfiguration;
        }
    }

    public IdentityProviderConfiguration getCurrentIdentityProviderConfiguration() throws ModuleNotFoundException, ModuleInstanceNotFoundException {
        String identityProviderBackendConnectionId = this.moduleConfiguration.getSettingValue(SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION).asString();
        return BackendConnections.getIdentityProviderConfiguration(this.moduleManager, identityProviderBackendConnectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldTryToRefreshIdentityProvider() {
        LOGGER.info("shouldTryToRefreshIdentityProvider");
        Object object = IDENTITY_PROVIDER_LOCK;
        synchronized (object) {
            block9: {
                if (this.isForceLocalIdentityProviderEnabled()) {
                    LOGGER.info("shouldTryToRefreshIdentityProvider: Not necessary, forced local identity provider is active");
                    return false;
                }
                if (this.identityProvider == null) {
                    try {
                        String idpBackendConnectionId = (String)this.moduleConfiguration.getSetting(SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION).getValue();
                        if (StringUtil.isNullOrEmpty(idpBackendConnectionId)) {
                            LOGGER.info("shouldTryToRefreshIdentityProvider: Not necessary, the identity provider backend connection ID is not set.");
                            return false;
                        }
                        IdentityProviderConfiguration idpConfiguration = BackendConnections.getIdentityProviderConfiguration(this.moduleManager, idpBackendConnectionId);
                        if (idpConfiguration == null) {
                            LOGGER.info("shouldTryToRefreshIdentityProvider: Not necessary, the identity provider backend connection configuration is somehow 'null'.");
                            return false;
                        }
                        break block9;
                    }
                    catch (Exception ex) {
                        LOGGER.info("shouldTryToRefreshIdentityProvider: Not necessary, failed to get the identity provider backend connection configuration.");
                        return false;
                    }
                }
                LOGGER.info("shouldTryToRefreshIdentityProvider: Not necessary, a identity provider is already set.");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIdentityProvider() {
        LOGGER.info("refreshIdentityProvider");
        Object object = IDENTITY_PROVIDER_LOCK;
        synchronized (object) {
            try {
                IdentityProvider idp;
                int idpSessionExpirationMinutes;
                String idpName;
                IdentityProviderConfiguration idpConfiguration;
                BundleContext bundleContext = this.getModuleBundle().getBundleContext();
                if (this.isForceLocalIdentityProviderEnabled()) {
                    LOGGER.warn("Forced local identity provider, using JAAS with realm 'karaf'");
                    idpConfiguration = null;
                } else {
                    try {
                        String idpBackendConnectionId = (String)this.moduleConfiguration.getSetting(SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION).getValue();
                        if (!StringUtil.isNullOrEmpty(idpBackendConnectionId)) {
                            idpConfiguration = BackendConnections.getIdentityProviderConfiguration(this.moduleManager, idpBackendConnectionId);
                        } else {
                            LOGGER.warn("No identity provider backend connection ID set. You could activate the local/Karaf IDP as a fallback for temporary use.");
                            idpConfiguration = null;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to get the identity provider backend connection. You could activate the local/Karaf IDP as a fallback for temporary use.", (Throwable)ex);
                        idpConfiguration = null;
                    }
                }
                if (idpConfiguration == null) {
                    try {
                        idpConfiguration = BackendConnections.getIdentityProviderConfiguration(this.moduleManager, "idp_karaf");
                        if (!"karaf".equalsIgnoreCase(idpConfiguration.getIdentityProviderName())) {
                            idpConfiguration = null;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Strange, failed to get the automatically created identity provider backend connection 'idp_karaf'. Going to use the local/Karaf IDP as a fallback anyway.", (Throwable)ex);
                        idpConfiguration = null;
                    }
                }
                if (idpConfiguration != null) {
                    idpName = idpConfiguration.getIdentityProviderName();
                    idpSessionExpirationMinutes = idpConfiguration.getSessionExpirationInMinutes();
                } else {
                    idpName = "karaf";
                    idpSessionExpirationMinutes = 480;
                }
                try {
                    switch (idpName) {
                        case "oidc": {
                            idp = new OidcIdentityProvider(bundleContext, idpConfiguration, idpSessionExpirationMinutes);
                            break;
                        }
                        case "keycloak": {
                            idp = new KeycloakIdentityProvider(bundleContext, idpConfiguration, idpSessionExpirationMinutes);
                            break;
                        }
                        default: {
                            String loginContextId = idpName.equalsIgnoreCase("local") ? "karaf" : idpName;
                            LOGGER.info("Using JAAS with realm '{}'", (Object)loginContextId);
                            if (this.identityProvider instanceof JaasProvider && loginContextId.equals(((JaasProvider)this.identityProvider).getLoginContextId())) {
                                idp = this.identityProvider;
                                ((JaasProvider)this.identityProvider).setSessionExpirationInMinutes(idpSessionExpirationMinutes);
                                break;
                            }
                            idp = new JaasProvider(bundleContext, loginContextId, idpSessionExpirationMinutes, this.coreBundleConfigurationTracker.getService());
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    if (idpName.equals("karaf")) {
                        LOGGER.error("Failed to initialize the identity provider: '{}'.", (Object)idpName, (Object)ex);
                    } else {
                        LOGGER.error("Failed to initialize the identity provider: '{}'. You could activate the local/Karaf IDP as a fallback for temporary use.", (Object)idpName, (Object)ex);
                    }
                    idp = null;
                }
                if (idp instanceof IdentityProviderWithUnsupportedOperationsFallbackHandler) {
                    UnsupportedIdentityProviderOperationsFallbackHandler handler = null;
                    if (idpConfiguration != null) {
                        try {
                            handler = new UnsupportedIdentityProviderOperationsFallbackHandler(idpConfiguration.getModuleConfiguration());
                        }
                        catch (Exception ex) {
                            LOGGER.error("Failed to initialize the UnsupportedIdentityProviderOperationsFallbackHandler", (Throwable)ex);
                        }
                    }
                    ((IdentityProviderWithUnsupportedOperationsFallbackHandler)((Object)idp)).setUnsupportedIdentityProviderOperationsFallbackHandler(handler);
                }
                if (this.identityProvider != null && this.identityProvider != idp) {
                    this.clientSessionManagerTracker.getService().removeAllSessions(true, this.identityProvider);
                    this.identityProvider.destroy();
                }
                if (idp instanceof JaasProvider) {
                    JaasProvider jaasProvider = (JaasProvider)idp;
                    jaasProvider.replaceDefaultPasswordsOfShippedUsers("default_virtimo_password", ListUtil.listOf("bpcadmin", "virtimo"));
                }
                this.identityProvider = idp;
            }
            catch (Exception ex) {
                LOGGER.error("Identity provider processing failed.", (Throwable)ex);
                this.keepAsLastOccurredException(new TimestampedException(ex));
            }
        }
    }

    private void updateLicenseSettingToPreventManipulation() {
        LOGGER.info("updateLicenseSettingToPreventManipulation");
        try {
            this.updateLicenceSetting(this.licenseServiceTracker.getService().getLicense());
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Updating core license setting failed.", (Throwable)ex);
            this.keepAsLastOccurredException(new TimestampedException(ex));
        }
    }

    private void updateLicenceSetting(License license) {
        LOGGER.info("updateLicenceSetting license={}", (Object)license);
        try {
            Map oldLicensedSettingValue = (Map)this.getConfiguration().getSetting(SETTING_LICENCED_MODULES).getValue();
            HashMap<String, Object> newLicenseSettingValue = oldLicensedSettingValue == null ? new HashMap<String, Object>() : new HashMap(oldLicensedSettingValue);
            Map<String, Object> licenseDetails = this.licenseServiceTracker.getService().getLicenseDetails(license);
            if (licenseDetails != null) {
                newLicenseSettingValue.putAll(licenseDetails);
            }
            if (oldLicensedSettingValue == null || !newLicenseSettingValue.equals(oldLicensedSettingValue)) {
                SimpleSettingImpl newLicenceSetting = new SimpleSettingImpl(this.getConfiguration().getSetting(SETTING_LICENCED_MODULES));
                newLicenceSetting.setValue(newLicenseSettingValue);
                this.getConfiguration().updateSetting(newLicenceSetting, true);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Updating core license setting failed.", (Throwable)ex);
            this.keepAsLastOccurredException(new TimestampedException(ex));
        }
    }

    public boolean isBpcConfigurationIndexBackupOnChangesEnabled() {
        LOGGER.info("isBpcConfigurationIndexBackupOnChangesEnabled");
        return (Boolean)this.getConfiguration().getSetting(SETTING_BPC_CONFIGURATION_BACKUP_ON_CHANGES).getValue();
    }

    public boolean isBpcConfigurationIndexBackupNecessary(List<Setting> settings) {
        LOGGER.info("isBpcConfigurationIndexBackupNecessary settings=...");
        if (settings == null) {
            return false;
        }
        return this.isBpcConfigurationIndexBackupNecessary(new SettingsImpl(settings));
    }

    public boolean isBpcConfigurationIndexBackupNecessary(Settings settings) {
        LOGGER.info("isBpcConfigurationIndexBackupNecessary settings=...");
        if (settings == null || settings.isEmpty()) {
            return false;
        }
        Iterator iterator = settings.iterator();
        if (iterator.hasNext()) {
            Setting setting = (Setting)iterator.next();
            return true;
        }
        return false;
    }

    public void createBpcConfigurationSnapshot(UserSession userSession) {
        LOGGER.info("createBpcConfigurationSnapshot userSession=...");
        try {
            BackupSnapshotInfo snapshotInfo = this.backupManagerTracker.getService().startBackupJob("core:bpc-configuration");
            UserAuditLog.info(userSession, "BackupCreated", "Backup with the snapshot name '" + String.valueOf(snapshotInfo.getSnapshotName()) + "' created");
        }
        catch (Exception ex) {
            LOGGER.error("Failed to create the 'bpc-configuration' index snapshot/backup.", (Throwable)ex);
            UserAuditLog.warning(userSession, "BackupFailed", "Backup of the 'bpc-configuration' index failed. Please be sure that 'path.repo' is set in the OpenSearch configuration.");
        }
    }

    public String getBpcFrontendUrl() {
        String bpcBaseUrl = this.getConfiguration().getSettingValue(SETTING_BPC_BASE_URL).asString(SETTING_BPC_BASE_URL_DEFAULT_VALUE);
        String bpcClientPath = this.getConfiguration().getSettingValue(SETTING_CLIENT_PATH).asString(SETTING_CLIENT_PATH_DEFAULT_VALUE);
        return StringUtil.glue(bpcBaseUrl, bpcClientPath, '/');
    }

    public boolean isUserAllowedToAccessBPC(UserSession userSession) {
        if (userSession == null) {
            return false;
        }
        if (userSession.hasRole("bpcadmin")) {
            return true;
        }
        String mandatoryRoleToAccessBPC = this.getConfiguration().getSettingValue(SETTING_MANDATORY_ROLE_TO_ACCESS_BPC).asString(null);
        return StringUtil.isNullOrEmpty(mandatoryRoleToAccessBPC) || userSession.hasRole(mandatoryRoleToAccessBPC);
    }

    public ServerStateInfoDTO createServerStateInfoDTO(String serverUUID, String bpcName, String bpcUrl, boolean maintenanceModeEnabled, boolean availableForReplication, boolean masterServer) {
        String serverHttpsPort;
        String serverHttpPort;
        String serverVersion = System.getProperty("karaf.version");
        String serverHostname = null;
        String serverAddress = null;
        try {
            serverHostname = InetAddress.getLocalHost().getHostName();
            serverAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.info("Could not get the server hostname and address.");
        }
        try {
            Configuration paxWebConf = this.configurationAdminTracker.getService().getConfiguration("org.ops4j.pax.web");
            Object httpPortObject = paxWebConf.getProcessedProperties(null).get("org.osgi.service.http.port");
            serverHttpPort = (String)httpPortObject;
            Object httpsPortObject = paxWebConf.getProcessedProperties(null).get("org.osgi.service.http.port.secure");
            serverHttpsPort = (String)httpsPortObject;
        }
        catch (Exception ex) {
            LOGGER.error("Could not get the server http/https ports from the configuration file: org.ops4j.pax.web.cfg", (Throwable)ex);
            serverHttpPort = "8181";
            serverHttpsPort = "8282";
        }
        return new ServerStateInfoDTO(serverUUID, serverVersion, serverHostname, serverAddress, serverHttpPort, serverHttpsPort, bpcName, bpcUrl, maintenanceModeEnabled, availableForReplication, masterServer);
    }

    public void restartCoreBundle() {
        final String karafNameFromEtcSystemProperties = System.getProperty("karaf.name");
        final String symbolicNameOfBundleToRestart = this.bundleContext.getBundle().getSymbolicName();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                CoreModule.this.restartBundleByUsingJMX(karafNameFromEtcSystemProperties, symbolicNameOfBundleToRestart);
            }
        }, 1000L);
    }

    private void restartBundleByUsingJMX(String karafNameFromEtcSystemProperties, String symbolicNameOfBundleToRestart) {
        LOGGER.info("restartBundleByUsingJMX karafNameFromEtcSystemProperties={}, symbolicNameOfBundleToRestart={}", (Object)karafNameFromEtcSystemProperties, (Object)symbolicNameOfBundleToRestart);
        try {
            ObjectName mBeanName = new ObjectName("org.apache.karaf:type=bundle,name=" + karafNameFromEtcSystemProperties);
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.invoke(mBeanName, "restart", new Object[]{symbolicNameOfBundleToRestart}, new String[]{String.class.getName()});
        }
        catch (Exception ex) {
            LOGGER.error("Failed to restart the bundle '{}' by using JMX.", (Object)symbolicNameOfBundleToRestart, (Object)ex);
        }
    }

    public static boolean isRequestFromOtherBpcServer(HttpHeaders hh, CoreBundleConfiguration coreBundleConfiguration, OpenSearchBpcPluginManager openSearchBpcPluginManager) throws ServiceNotFoundException {
        ConnectedServersDTO connectedServers;
        String callingServerUUID;
        if (hh != null && !StringUtil.isNullOrEmpty(callingServerUUID = hh.getHeaderString("X-Active-Active")) && !callingServerUUID.equals(coreBundleConfiguration.getServerUUID()) && (connectedServers = openSearchBpcPluginManager.getConnectedServers()) != null) {
            ConnectedServerDTO connectedServer = connectedServers.getConnectedServerByUUID(callingServerUUID);
            return connectedServer != null;
        }
        return false;
    }

    private class MaintenanceModeConfigPropertyChangedEventHandler
    extends AbstractEventHandler {
        private MaintenanceModeConfigPropertyChangedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            Boolean maintenanceModeEnabled = (Boolean)event.getProperty("enabled");
            LOGGER.debug("maintenanceModeEnabled? {}", (Object)maintenanceModeEnabled);
            if (maintenanceModeEnabled.booleanValue()) {
                CoreModule.this.enableMaintenanceMode(false);
            } else {
                CoreModule.this.disableMaintenanceMode(false);
            }
        }
    }

    private class MaintenanceModeAcknowlegeEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeAcknowlegeEventHandler(BundleContext bundleContext) {
            super(bundleContext, CoreModule.MODULE_ID);
        }

        @Override
        public void processNewMaintenanceMode(boolean maintenanceModeEnabled) {
            LOGGER.info("{}.processNewMaintenanceMode enabled={}", (Object)this.getClass().getSimpleName(), (Object)maintenanceModeEnabled);
            try {
                CoreBundleConfiguration coreBundleConfiguration = CoreModule.this.coreBundleConfigurationTracker.getService();
                ServerStateInfoDTO serverStateInfo = CoreModule.this.createServerStateInfoDTO(coreBundleConfiguration.getServerUUID(), coreBundleConfiguration.getBpcName(), CoreModule.this.getBpcFrontendUrl(), maintenanceModeEnabled, coreBundleConfiguration.isAvailableForReplicationEnabled(), CoreModule.this.isMasterServer());
                CoreModule.this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin-send-state-info-message", "msg", serverStateInfo);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process the maintenance mode changed event.", (Throwable)ex);
            }
        }
    }

    private class MaintenanceModeAcknowledgedEventHandler
    extends AbstractEventHandler {
        private MaintenanceModeAcknowledgedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            if (CoreModule.this.maintenanceModeLatch != null) {
                LOGGER.info("Received an maintenance mode enabled acknowledgement from module '{}' handler: {}", event.getProperty("moduleId"), event.getProperty("handler"));
                CoreModule.this.maintenanceModeLatch.countDown();
            } else {
                LOGGER.info("Ignoring event ... there core does not wait for maintenance mode enabled acknowledgements");
            }
        }
    }

    private class ForceLocalIdentityProviderEventHandler
    extends AbstractEventHandler {
        private ForceLocalIdentityProviderEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            Boolean forceLocalIdentityProviderEnabled = (Boolean)event.getProperty("enabled");
            LOGGER.debug("forceLocalIdentityProviderEnabled? {}", (Object)forceLocalIdentityProviderEnabled);
            CoreModule.this.refreshIdentityProvider();
        }
    }

    private class OpenSearchBpcPluginWebsocketConnectedEventHandler
    extends AbstractEventHandler {
        private OpenSearchBpcPluginWebsocketConnectedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                EventManager eventManager = CoreModule.this.eventManagerTracker.getService();
                CoreBundleConfiguration coreBundleConfiguration = CoreModule.this.coreBundleConfigurationTracker.getService();
                ServerStateInfoDTO serverStateInfo = CoreModule.this.createServerStateInfoDTO(coreBundleConfiguration.getServerUUID(), coreBundleConfiguration.getBpcName(), CoreModule.this.getBpcFrontendUrl(), coreBundleConfiguration.isMaintenanceModeEnabled(), coreBundleConfiguration.isAvailableForReplicationEnabled(), CoreModule.this.isMasterServer());
                eventManager.fireEvent("de/virtimo/os-bpc-plugin-send-state-info-message", "msg", serverStateInfo);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process the event={}", (Object)event, (Object)ex);
            }
        }
    }

    private class OpenSearchBpcPluginWebsocketDisconnectedEventHandler
    extends AbstractEventHandler {
        private OpenSearchBpcPluginWebsocketDisconnectedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                EventManager eventManager = CoreModule.this.eventManagerTracker.getService();
                CoreBundleConfiguration coreBundleConfiguration = CoreModule.this.coreBundleConfigurationTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                if (CoreModule.this.isMasterServer()) {
                    LOGGER.warn("Websocket connection to the 'os-bpc-plugin' was closed. Setting this server with the UUID '{}' as slave.", (Object)thisServerUUID);
                    CoreModule.this.setUuidOfMasterServer(null);
                    eventManager.fireEvent("de/virtimo/bpc/core/serverModeChanged", new AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent(thisServerUUID, "UNKNOWN"));
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process the event={}", (Object)event, (Object)ex);
            }
        }
    }

    private class OpenSearchBpcPluginSetAsMasterOrSlaveClusterMessageEventHandler
    extends AbstractEventHandler {
        private OpenSearchBpcPluginSetAsMasterOrSlaveClusterMessageEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains(CoreModule.EVENT_PROPERTY_NAME_SET_AS_MASTER_SERVER);
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                EventManager eventManager = CoreModule.this.eventManagerTracker.getService();
                CoreBundleConfiguration coreBundleConfiguration = CoreModule.this.coreBundleConfigurationTracker.getService();
                String thisServerUUID = coreBundleConfiguration.getServerUUID();
                SetAsMasterServerWebsocketMessage setAsMasterServerWebsocketMessage = (SetAsMasterServerWebsocketMessage)event.getProperty(CoreModule.EVENT_PROPERTY_NAME_SET_AS_MASTER_SERVER);
                String newMasterServerUUID = setAsMasterServerWebsocketMessage.getServerUUID();
                if (!CoreModule.this.isAlreadySetAsUuidOfMasterServer(CoreModule.this.uuidOfMasterServer)) {
                    CoreModule.this.setUuidOfMasterServer(newMasterServerUUID);
                    eventManager.fireEvent("de/virtimo/bpc/core/serverModeChanged", new AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent(thisServerUUID, newMasterServerUUID));
                }
                ServerStateInfoDTO serverStateInfo = CoreModule.this.createServerStateInfoDTO(coreBundleConfiguration.getServerUUID(), coreBundleConfiguration.getBpcName(), CoreModule.this.getBpcFrontendUrl(), coreBundleConfiguration.isMaintenanceModeEnabled(), coreBundleConfiguration.isAvailableForReplicationEnabled(), CoreModule.this.isMasterServer());
                eventManager.fireEvent("de/virtimo/os-bpc-plugin-send-state-info-message", "msg", serverStateInfo);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process the event={}", (Object)event, (Object)ex);
            }
        }
    }

    private class OpenSearchBpcPluginIndexOperationEventHandler
    extends AbstractEventHandler {
        private OpenSearchBpcPluginIndexOperationEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains(CoreModule.EVENT_PROPERTY_NAME_INDEX_OPERATION);
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                final LookupJoinsManager lookupJoinsManager = CoreModule.this.lookupJoinsManagerTracker.getService();
                final IndexOperationDTO indexOperation = (IndexOperationDTO)event.getProperty(CoreModule.EVENT_PROPERTY_NAME_INDEX_OPERATION);
                if (!indexOperation.getIndexAndAliasNames().contains("bpc-configuration") && CoreModule.this.isMasterServer()) {
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            try {
                                lookupJoinsManager.handleOpenSearchBpcPluginIndexOperation(indexOperation);
                            }
                            catch (ServiceNotFoundException ex) {
                                LOGGER.error("Failed to handle OpenSearch index operation", (Throwable)ex);
                            }
                        }
                    }, 1500L);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process the event={}", (Object)event, (Object)ex);
            }
        }
    }

    private class OpenSearchBpcPluginBroadcastWebsocketMessageEventHandler
    extends AbstractEventHandler {
        private OpenSearchBpcPluginBroadcastWebsocketMessageEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains(CoreModule.EVENT_PROPERTY_NAME_BROADCAST_OPENSEARCH_WEBSOCKET_MESSAGE);
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                final BroadcastWebsocketMessage broadcastWebsocketMessage = (BroadcastWebsocketMessage)event.getProperty(CoreModule.EVENT_PROPERTY_NAME_BROADCAST_OPENSEARCH_WEBSOCKET_MESSAGE);
                if (broadcastWebsocketMessage.isType("BpcConfigurationIndexRestored")) {
                    LOGGER.warn("Necessary restart of the backend core module (bpc-be-core) due to a restored 'bpc-configuration' index backup ...");
                    CoreModule.this.restartCoreBundle();
                } else {
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (CoreModule.this.moduleManager instanceof ModuleManagerImpl) {
                                ((ModuleManagerImpl)CoreModule.this.moduleManager).handleOpenSearchBpcPluginBroadcastWebsocketMessage(broadcastWebsocketMessage);
                            }
                        }
                    }, 1500L);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process the event={}", (Object)event, (Object)ex);
            }
        }
    }

    private class DataSourceUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private DataSourceUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList("driverName", "url", "user", "password", "configuration"));
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            CoreModule.this.refreshDataSources();
        }
    }

    private class DataSourceDeletedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private DataSourceDeletedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            CoreModule.this.refreshDataSources();
        }
    }

    private class IdentityProviderBackendConnectionUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private IdentityProviderBackendConnectionUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOGGER.info("{}.processSetting setting=...", (Object)this.getClass().getSimpleName());
            if (CoreModule.this.moduleManager.getModule("backendconnection") != null) {
                CoreModule.this.refreshIdentityProvider();
            }
        }
    }

    private class IdentityProviderUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private final List<String> mandatorySettingNames = Arrays.asList("identityProvider", "identityProvider_mappings", "identityProvider_sessionExpirationMinutes", "identityProvider_jdbc_dataSource", "identityProvider_oidc_clientId", "identityProvider_oidc_clientSecret", "identityProvider_oidc_scope", "identityProvider_oidc_claimNameRights", "identityProvider_oidc_claimNameRoles", "identityProvider_oidc_claimNameOrganisations", "identityProvider_oidc_metadataDiscoveryUri", "identityProvider_oidc_postAuthenticationRedirectUri", "identityProvider_oidc_postLogoutRedirectUri", "identityProvider_oidc_pkceMethod", "identityProvider_oidc_allowAccessTokenAuthentication", "identityProvider_oidc_verifyAccessTokenAtIDP");
        private final List<String> dynamicallyReadSettingNames = Arrays.asList("identityProvider_pwdValidationRegExp", "identityProvider_ussChangePasswordEnabled", "identityProvider_ussChangeOrganisationEnabled", "identityProvider_healthEndpoint");
        private final List<String> fetchAdditionalInfoSettingNames = Arrays.asList("identityProvider.additionalInfoUrl", "identityProvider.additionalInfoEnabled", "identityProvider.additionalInfoEntriesPrefix", "identityProvider.additionalInfoUrlBasicAuthUsername", "identityProvider.additionalInfoUrlBasicAuthPassword");

        private IdentityProviderUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            ArrayList<String> allIdpSettingNames = new ArrayList<String>();
            allIdpSettingNames.addAll(this.mandatorySettingNames);
            allIdpSettingNames.addAll(this.dynamicallyReadSettingNames);
            allIdpSettingNames.addAll(this.fetchAdditionalInfoSettingNames);
            return this.isModuleUpdatedEventOfSettings(event, allIdpSettingNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onUpdateOfIdentityProviderMappings(String idpInstanceId) throws ModuleNotFoundException, ModuleInstanceNotFoundException {
            LOGGER.info("onUpdateOfIdentityProviderMappings idpInstanceId={}", (Object)idpInstanceId);
            Object object = IDENTITY_PROVIDER_LOCK;
            synchronized (object) {
                ModuleConfiguration idpModuleConfiguration;
                if (CoreModule.this.identityProvider instanceof IdentityProviderWithUnsupportedOperationsFallbackHandler && (idpModuleConfiguration = BackendConnections.getModuleConfigurationOfIdentityProvider(CoreModule.this.moduleManager, idpInstanceId)) != null) {
                    IdentityProviderWithUnsupportedOperationsFallbackHandler idp = (IdentityProviderWithUnsupportedOperationsFallbackHandler)((Object)CoreModule.this.identityProvider);
                    idp.getUnsupportedIdentityProviderOperationsFallbackHandler().initialize(idpModuleConfiguration);
                }
            }
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                String idpInstanceId;
                String eventInstanceId;
                IdentityProviderConfiguration idpConfiguration = CoreModule.this.getCurrentIdentityProviderConfiguration();
                if (idpConfiguration != null && (eventInstanceId = (String)event.getProperty("moduleInstanceId")).equals(idpInstanceId = idpConfiguration.getInstanceId())) {
                    if (this.isModuleUpdatedEventOfSettings(event, this.fetchAdditionalInfoSettingNames)) {
                        LOGGER.info("Identity provider must not be refreshed due to a 'fetchAdditionalInfo' setting updated event: {}", (Object)event);
                    } else if (this.isModuleUpdatedEventOfSettings(event, this.dynamicallyReadSettingNames)) {
                        LOGGER.info("Identity provider must not be refreshed due to a 'dynamicallyRead' setting updated event: {}", (Object)event);
                    } else if (this.isModuleUpdatedEventOfSettings(event, Arrays.asList("identityProvider_mappings"))) {
                        this.onUpdateOfIdentityProviderMappings(idpInstanceId);
                    } else {
                        CoreModule.this.refreshIdentityProvider();
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("{}: Failed to get the configuration of the currently used identity provider.", (Object)this.getClass().getSimpleName(), (Object)ex);
            }
        }
    }

    private class IdentityProviderDeletedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private IdentityProviderDeletedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                String idpInstanceId;
                String eventInstanceId;
                IdentityProviderConfiguration idpConfiguration = CoreModule.this.getCurrentIdentityProviderConfiguration();
                if (idpConfiguration != null && (eventInstanceId = (String)event.getProperty("moduleInstanceId")).equals(idpInstanceId = idpConfiguration.getInstanceId())) {
                    CoreModule.this.refreshIdentityProvider();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("{}: Failed to get the configuration of the currently used identity provider.", (Object)this.getClass().getSimpleName(), (Object)ex);
            }
        }
    }

    private class LicensedModulesSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private LicensedModulesSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOGGER.info("{}.processSetting setting=...", (Object)this.getClass().getSimpleName());
            CoreModule.this.updateLicenseSettingToPreventManipulation();
        }
    }

    private class BackendConnectionsModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler
    extends AbstractBackendModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler {
        private BackendConnectionsModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler() {
        }

        @Override
        public void processModule(Module module) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            CoreModule.this.refreshIdentityProvider();
        }
    }

    private class LicenseChangedEventHandler
    extends AbstractEventHandler {
        private LicenseChangedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            License license = (License)event.getProperty("license");
            CoreModule.this.updateLicenceSetting(license);
        }
    }

    private class FrontendUrlRelatedSettingsUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private FrontendUrlRelatedSettingsUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList(CoreModule.SETTING_BPC_BASE_URL, CoreModule.SETTING_CLIENT_PATH));
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            try {
                CoreBundleConfiguration coreBundleConfiguration = CoreModule.this.coreBundleConfigurationTracker.getService();
                EventManager eventManager = CoreModule.this.eventManagerTracker.getService();
                ServerStateInfoDTO serverStateInfo = CoreModule.this.createServerStateInfoDTO(coreBundleConfiguration.getServerUUID(), coreBundleConfiguration.getBpcName(), CoreModule.this.getBpcFrontendUrl(), coreBundleConfiguration.isMaintenanceModeEnabled(), coreBundleConfiguration.isAvailableForReplicationEnabled(), CoreModule.this.isMasterServer());
                eventManager.fireEvent("de/virtimo/os-bpc-plugin-send-state-info-message", "msg", serverStateInfo);
            }
            catch (Exception ex) {
                LOGGER.warn("{}: Failed to inform the 'os-bpc-plugin' about my new server state..", (Object)this.getClass().getSimpleName(), (Object)ex);
            }
        }
    }

    private class CoreModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private CoreModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOGGER.info("{}.processLoadedModule module=...", (Object)this.getClass().getSimpleName());
            CoreModule coreModule = (CoreModule)module;
            if (coreModule.equals(CoreModule.this)) {
                CoreModule.this.identityProviderChecker = new IdentityProviderChecker(coreModule);
                CoreModule.this.identityProviderChecker.startChecker();
                CoreModule.this.apiKeysChecker = new APIKeysChecker(CoreModule.this.bundleContext, coreModule);
                CoreModule.this.apiKeysChecker.startChecker();
                try {
                    CoreModule.this.systemChecker = new SystemChecker(CoreModule.this.bundleContext, coreModule, CoreModule.this.coreBundleConfigurationTracker.getService().getSystemCheckerIntervalInSeconds());
                    CoreModule.this.systemChecker.startChecker();
                }
                catch (ServiceNotFoundException ex) {
                    LOGGER.error("Failed to start the system checker. The CoreBundleConfiguration service was not found.", (Throwable)ex);
                }
            }
        }
    }

    private static class ChatEventHandler
    extends AbstractEventHandler {
        private ChatEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
        }
    }
}

