/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class SystemChecker
implements Checker {
    private static final Logger LOGGER = LogManager.getLogger(SystemChecker.class);
    public static final String INTERVAL_IN_SECONDS_PROPERTY_NAME = "de.virtimo.bpc.core.systemchecker.interval";
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private final BundleContext bundleContext;
    private CoreModule coreModule;
    private final int systemCheckerIntervalInSeconds;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;

    public SystemChecker(BundleContext bundleContext, CoreModule coreModule, int systemCheckerIntervalInSeconds) {
        this.bundleContext = bundleContext;
        this.coreModule = coreModule;
        this.systemCheckerIntervalInSeconds = systemCheckerIntervalInSeconds;
    }

    @Override
    public void startChecker() {
        LOGGER.info("startChecker");
        if (this.checkerHandle != null) {
            LOGGER.warn("System checker is already running");
            return;
        }
        BpcServicesTracker.stopAll(this);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-systemchecker"));
        this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createCheckerRunnable(), 15L, this.systemCheckerIntervalInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void stopChecker() {
        LOGGER.info("stopChecker");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOGGER.info("Running system checker cancelled");
            } else {
                LOGGER.warn("Could not cancel the running system checker");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        BpcServicesTracker.stopAll(this);
        this.coreModule = null;
    }

    private Runnable createCheckerRunnable() {
        LOGGER.info("createCheckerRunnable");
        return new Runnable(){

            @Override
            public void run() {
                try {
                    OpenSearchService oss = SystemChecker.this.openSearchServiceTracker.getService();
                    long maintenanceModeDiscLimitInMB = SystemChecker.this.coreModule.getMaintenanceModeFileSystemLimitInMB();
                    boolean fileSystemLimitReached = false;
                    Map<String, Object> fsStats = oss.getFilesystemStats();
                    Map nodes = (Map)fsStats.get("nodes");
                    for (String nodeUUID : nodes.keySet()) {
                        Map nodeAttrs = (Map)nodes.get(nodeUUID);
                        String nodeName = (String)nodeAttrs.get("name");
                        Map total = (Map)((Map)nodeAttrs.get("fs")).get("total");
                        long discTotalInMB = (Long)total.get("total_in_bytes") / 1000L / 1000L;
                        long discFreeInMB = (Long)total.get("free_in_bytes") / 1000L / 1000L;
                        long discAvailableInMB = (Long)total.get("available_in_bytes") / 1000L / 1000L;
                        float availableDiskPercent = discAvailableInMB * 100L / discTotalInMB;
                        LOGGER.info("{} - Disc Total: {} MB, Free: {} MB, Avail: {} MB ({} %), Limit: {} MB to activate the maintenance mode", (Object)nodeName, (Object)discTotalInMB, (Object)discFreeInMB, (Object)discAvailableInMB, (Object)Float.valueOf(availableDiskPercent), (Object)maintenanceModeDiscLimitInMB);
                        if (discAvailableInMB > maintenanceModeDiscLimitInMB) continue;
                        fileSystemLimitReached = true;
                    }
                    if (fileSystemLimitReached) {
                        LOGGER.error("Reached the file system limit of {} MB ... activating the maintenance mode.", (Object)maintenanceModeDiscLimitInMB);
                        if (!SystemChecker.this.coreModule.isMaintenanceModeEnabled()) {
                            SystemAuditLog.warning("MaintenanceModeEnabled", "Requested while reaching the file system limit of " + maintenanceModeDiscLimitInMB + " MB");
                        }
                        SystemChecker.this.coreModule.enableMaintenanceMode(true);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to perform the system check.", t);
                }
            }
        };
    }
}

